SELECT t_pricechange.id                               pricechange_id,
       s.id                                           price_id,
       s.f_price_id                                   price_code,
       s.f_gasproperties                              price_type,
       u.f_userfiles_id                               customer_code,
       isnull(s.f_stairmonths, 1)                     cycle,
       t_pricechange.f_perform_date                   pricedate,
       isnull(s.f_stair_start_date, s.f_perform_date) cycledate,
       t_pricechange.f_operator                       operator,
       u.f_userfiles_id                               user_id,
       s.f_version                                    version
FROM t_pricechange
         INNER JOIN t_userfiles u ON u.f_userinfo_id = t_pricechange.f_userinfo_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id and u.f_filialeid = s.f_filialeid
WHERE s.f_state = '有效'
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND g.f_calculation = '表端结算'
  AND t_pricechange.f_userinfo_id is not null
  AND t_pricechange.id =
      (SELECT MAX(ID) FROM t_pricechange c where c.f_userinfo_id = t_pricechange.f_userinfo_id)
  AND u.f_table_state = '正常'
ORDER BY t_pricechange.id DESC
