SELECT s.id                              sellid,
       u.f_user_id,
       u.f_userfiles_id                  customer_code,
       abs(s.f_preamount)                money,
       u.f_balance_amount                account_money,
       'CZ' + CONVERT(VARCHAR(20), s.id) cid,
       s.f_operator                      operator,
       s.f_operate_date                 charge_date,
       u.f_price_id                      price_id,
       u.f_userinfo_id                   f_userinfo_id,
       'refund' type,
       g.f_calculation,
       u.f_filialeid
FROM t_sellinggas s
         LEFT JOIN t_userfiles u ON u.f_userfiles_id = s.f_userfiles_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
WHERE s.f_state = '有效'
  AND s.f_type = '退费'
  AND (s.f_sendsuccess <> '成功' OR s.f_sendsuccess IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
--   AND g.f_calculation = '表端结算'
  AND u.f_table_state = '正常'
union all
SELECT s.id                              sellid,
       u.f_user_id,
       u.f_userfiles_id                  customer_code,
       abs(s.f_preamount)                money,
       u.f_balance_amount                account_money,
       'CZ' + CONVERT(VARCHAR(20), s.id) cid,
       s.f_operator                      operator,
       s.f_operate_date                 charge_date,
       u.f_price_id                      price_id,
       u.f_userinfo_id                   f_userinfo_id,
       'correct' type,
       g.f_calculation,
       u.f_filialeid
FROM t_sellinggas s
         LEFT JOIN t_userfiles u ON u.f_userfiles_id = s.f_userfiles_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
         LEFT JOIN t_sellinggas tsp on s.f_old_sell_id = tsp.id
WHERE s.f_state = '撤销'
  AND (s.f_sendsuccess <> '成功' OR s.f_sendsuccess IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
--  AND g.f_calculation = '表端结算'
  AND u.f_table_state = '正常'
  AND tsp.f_sendsuccess = '成功'
  AND tsp.f_state = '冲正'
  AND tsp.f_type IN ('物联网开户','物联网收费')
