/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.AuthenticationTools;
import com.aote.webmeter.tools.iot.NorthApiClientTools;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.ModifyDeviceInforInDTO;
import com.iotplatform.client.dto.RegDirectDeviceInDTO2;
import com.iotplatform.client.dto.RegDirectDeviceOutDTO;
import com.iotplatform.client.invokeapi.DeviceManagement;

public class DeviceManagementTools {
    private static final String DEVICE_BINDED_1 = "100416";
    private static final String DEVICE_BINDED_2 = "100426";
    private static final String DEVICE_CANCEL_BINDED_1 = "100403";
    private static final String DEVICE_CANCEL_BINDED_2 = "100418";

    public String regDevice(String nodeId) {
        RegDirectDeviceOutDTO radded;
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        RegDirectDeviceInDTO2 rabid = new RegDirectDeviceInDTO2();
        rabid.setNodeId(nodeId);
        rabid.setVerifyCode(nodeId);
        rabid.setTimeout(Integer.valueOf(0));
        try {
            String authToken = AuthenticationTools.getAuthToken();
            radded = dm.regDirectDevice(rabid, WebMeterInfo.getString("telecomAPIKey"), authToken);
        }
        catch (NorthApiException e) {
            String errorCode = e.getError_code();
            if (DEVICE_BINDED_1.equals(errorCode) || DEVICE_BINDED_2.equals(errorCode)) {
                return "\u8bbe\u5907\u5df2\u88ab\u6ce8\u518c";
            }
            throw new WebmeterException(e);
        }
        return radded.getDeviceId();
    }

    public int modifyDeviceInfo(String deviceId, String name) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        ModifyDeviceInforInDTO maid = new ModifyDeviceInforInDTO();
        maid.setName(name);
        maid.setManufacturerId(WebMeterInfo.getString("manuFacturerId"));
        maid.setManufacturerName(WebMeterInfo.getString("manuFacturerName"));
        maid.setDeviceType(WebMeterInfo.getString("deviceType"));
        maid.setModel(WebMeterInfo.getString("meterModel"));
        maid.setProtocolType("CoAP");
        try {
            dm.modifyDeviceInfo(maid, deviceId, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            return 0;
        }
        catch (NorthApiException e) {
            throw new WebmeterException(e);
        }
    }

    public int cancelDevice(String deviceId) {
        DeviceManagement dm = new DeviceManagement(NorthApiClientTools.getNorthApiClient());
        try {
            String authToken = AuthenticationTools.getAuthToken();
            dm.deleteDirectDevice(deviceId, null, WebMeterInfo.getString("telecomAPIKey"), authToken);
            return 0;
        }
        catch (NorthApiException e) {
            String errorCode = e.getError_code();
            if (DEVICE_CANCEL_BINDED_1.equals(errorCode) || DEVICE_CANCEL_BINDED_2.equals(errorCode)) {
                return 0;
            }
            throw new WebmeterException(e);
        }
    }
}

