/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.module.ModuleMapper;
import com.aote.webmeter.enums.ModuleEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.enums.WebmeterExceptionCodeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.WebmeterPropertiesTools;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebMeterInfo {
    private static final Logger LOGGER = Logger.getLogger(WebMeterInfo.class);
    private static final Map<String, HashMap<String, String>> PROPERTIES_MAP;
    private static final ThreadLocal<String> MODULE_NAME;
    private static final ThreadLocal<SaleVersionEnum> SALE_NAME;

    public static void load() {
        Map map = ModuleMapper.getMap();
        for (String moduleName : map.keySet()) {
            String modulePath = (String)((Map)map.get(moduleName)).get("path");
            HashMap<String, String> config = modulePath != null ? WebmeterPropertiesTools.readWebMeter(modulePath, moduleName) : WebmeterPropertiesTools.readWebMeter(moduleName);
            if (config == null) continue;
            String saleNameParam = WebmeterPropertiesEnum.SALE_NAME.getValue();
            if (config.containsKey(saleNameParam)) {
                if (!SaleVersionEnum.is(config.get(saleNameParam))) {
                    throw new WebmeterException(WebmeterExceptionCodeEnum.SALE_VERSION_NOT_FIND_FAIL, "\u6a21\u5757\uff1a" + moduleName);
                }
            } else {
                LOGGER.warn((Object)("\u3010" + moduleName + "\u3011\u6a21\u5757\u53c2\u6570\u6587\u4ef6\u672a\u914d\u7f6e\u8425\u6536\u7248\u672c\u540d\u79f0(" + saleNameParam + ")\uff0c\u53ef\u80fd\u5bfc\u81f4\u901a\u7528\u4e1a\u52a1\u517c\u5bb9\u6027\u95ee\u9898"));
            }
            PROPERTIES_MAP.put(moduleName, config);
            LOGGER.debug((Object)("\u3010" + moduleName + "\u3011\u6a21\u5757\u53c2\u6570\u6587\u4ef6\u5df2\u52a0\u8f7d"));
        }
    }

    public static void setModuleName(String name) {
        if (PROPERTIES_MAP.containsKey(name)) {
            MODULE_NAME.set(name);
            String saleNameParam = WebmeterPropertiesEnum.SALE_NAME.getValue();
            if (WebMeterInfo.has(saleNameParam).booleanValue()) {
                WebMeterInfo.setSaleName(SaleVersionEnum.toType(WebMeterInfo.getString(saleNameParam)));
            } else if (WebMeterInfo.has(ModuleEnum.PUBLIC_MODULE.getValue(), saleNameParam).booleanValue()) {
                WebMeterInfo.setSaleName(SaleVersionEnum.toType(WebMeterInfo.getStringByModule(ModuleEnum.PUBLIC_MODULE.getValue(), saleNameParam)));
            }
        } else {
            throw new WebmeterException(WebmeterExceptionCodeEnum.MODULE_NOT_FIND_FAIL, "\u6a21\u5757\uff1a" + name);
        }
    }

    public static void setSaleName(SaleVersionEnum saleVersionEnum) {
        SALE_NAME.set(saleVersionEnum);
    }

    public static String getString(String key) {
        return PROPERTIES_MAP.get(MODULE_NAME.get()).get(key);
    }

    public static String getString(String key, String defaultValue) {
        String value = PROPERTIES_MAP.get(MODULE_NAME.get()).get(key);
        return value != null ? value : defaultValue;
    }

    public static Map<String, String> getMap() {
        return PROPERTIES_MAP.get(MODULE_NAME.get());
    }

    public static String getStringByModule(String moduleName, String key) {
        return PROPERTIES_MAP.get(moduleName).get(key);
    }

    public static String getModuleName() {
        return MODULE_NAME.get();
    }

    public static String getSaleName() {
        return SALE_NAME.get().getValue();
    }

    public static SaleVersionEnum getSaleNameEnum() throws WebmeterException {
        SaleVersionEnum saleVersionEnum = SALE_NAME.get();
        if (saleVersionEnum == null) {
            throw new WebmeterException(WebmeterExceptionCodeEnum.SALE_VERSION_NULL_FAIL, "\u6a21\u5757\uff1a" + MODULE_NAME.get());
        }
        return saleVersionEnum;
    }

    public static Boolean has(String key) {
        return PROPERTIES_MAP.get(MODULE_NAME.get()).containsKey(key);
    }

    public static Boolean has(String module, String key) {
        return PROPERTIES_MAP.get(module).containsKey(key);
    }

    public static void removeModuleName() {
        MODULE_NAME.remove();
    }

    public static void removeSaleName() {
        SALE_NAME.remove();
    }

    public static Boolean hasModule(String key) {
        return PROPERTIES_MAP.containsKey(key);
    }

    static {
        MODULE_NAME = new ThreadLocal();
        SALE_NAME = new ThreadLocal();
        PROPERTIES_MAP = new HashMap<String, HashMap<String, String>>(1);
        WebMeterInfo.load();
    }
}

