/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.af.plugins.calculate.StairpriceSettlement;
import com.af.plugins.calculate.UnitpriceSettlement;
import com.aote.util.other.RedisTools;
import com.aote.webmeter.tools.Util;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class RedisBalance {
    private static final Logger LOGGER = Logger.getLogger(RedisBalance.class);

    public JSONObject redisSettlement(String meterNumber, JSONObject params) {
        JSONObject result;
        BigDecimal price;
        JSONObject priceDetail;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        LOGGER.debug((Object)("\u4f20\u5165\u53c2\u6570:" + params.toString()));
        JSONObject value = new JSONObject(RedisTools.getValue((String)meterNumber));
        BigDecimal lastBalance = new BigDecimal(value.getString("lastBalance"));
        BigDecimal lastTableBase = new BigDecimal(value.getString("lastTableBase"));
        String priceType = value.getString("priceType");
        JSONArray priceArray = value.getJSONArray("priceArray");
        BigDecimal tableBase = new BigDecimal(params.getString("tableBase"));
        BigDecimal useGas = tableBase.subtract(lastTableBase);
        JSONArray jsonArray = new JSONArray();
        if ("1".equals(priceType)) {
            priceDetail = priceArray.getJSONObject(0);
            price = new BigDecimal(priceDetail.getString("price"));
            result = new UnitpriceSettlement().calcCharge(jsonArray.put((Object)new JSONObject().put("f_unitprice", (Object)price)), useGas);
        } else if ("2".equals(priceType)) {
            for (int i = 0; i < priceArray.length() - 1; ++i) {
                jsonArray.put((Object)priceArray.getJSONObject(i));
            }
            priceDetail = priceArray.getJSONObject(priceArray.length() - 1);
            jsonArray.put((Object)priceDetail);
            BigDecimal sumAmount = new BigDecimal(params.getString("sumAmount"));
            jsonArray.put((Object)new JSONObject().put("sumamount", (Object)sumAmount));
            result = new StairpriceSettlement().calcCharge(jsonArray, useGas);
            JSONArray chargePrice = result.getJSONArray("chargeprice");
            price = Util.convertBigDecimal(chargePrice.getJSONObject(0).get("f_price"));
            for (int i = 1; i < chargePrice.length(); ++i) {
                JSONObject chargeJson = chargePrice.getJSONObject(i);
                if (Util.convertBigDecimal(chargeJson.get("f_gas")).compareTo(new BigDecimal("0")) <= 0) continue;
                price = Util.convertBigDecimal(chargeJson.get("f_price"));
            }
        } else {
            throw new RuntimeException("\u5c1a\u672a\u652f\u6301\u5176\u4ed6\u6c14\u4ef7\u7c7b\u578b\uff01");
        }
        BigDecimal useAmount = Util.convertBigDecimal(result.get("chargenum"));
        BigDecimal balance = lastBalance.subtract(useAmount);
        String balanceStr = decimalFormat.format(balance);
        value.put("lastBalance", (Object)balanceStr);
        value.put("lastTableBase", (Object)tableBase.toString());
        value.put("unitPrice", (Object)price.toString());
        RedisTools.setValue((String)meterNumber, (String)value.toString());
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("returnCode", (Object)"SUCCESS");
        jsonObject2.put("balance", (Object)balanceStr);
        jsonObject2.put("unitPrice", (Object)price.toString());
        System.out.println(value.toString());
        return jsonObject2;
    }
}

