/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.wenxi;

import com.af.plugins.CommonTools;
import com.aote.webmeter.module.xinlisystem.XinLiSystemTools;
import com.aote.webmeter.tools.Util;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class WenXiSpecialCharge {
    static Logger log = Logger.getLogger(WenXiSpecialCharge.class);

    public static JSONObject computeDate(int stairmonths) {
        JSONObject info = XinLiSystemTools.countDate(new Date());
        Calendar cal = Calendar.getInstance();
        JSONObject result = new JSONObject();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        if ("4".equals(info.getString("months"))) {
            result.put("startDate", (Object)info.getString("startDate"));
            cal.add(1, 1);
            if (info.has("endDate")) {
                result.put("endDate", (Object)info.getString("endDate"));
            } else {
                result.put("endDate", (Object)(cal.get(1) + info.getString("date")));
            }
            log.debug((Object)("\u91c7\u6696\u5b63\u9636\u68af\u6c14\u4ef7\u65f6\u95f4\uff1a" + result));
        } else if (stairmonths == 1) {
            cal.set(5, 16);
            result.put("startDate", (Object)format.format(cal.getTime()));
            cal.add(2, 1);
            result.put("endDate", (Object)format.format(cal.getTime()));
            log.debug((Object)("\u9636\u68af\u6c14\u4ef7\u65f6\u95f4\uff1a" + result));
        } else if (stairmonths == 6) {
            result.put("startDate", (Object)(cal.get(1) + "0316"));
            result.put("endDate", (Object)(cal.get(1) + "0916"));
            log.debug((Object)("\u9636\u68af\u6c14\u4ef7\u65f6\u95f4\uff1a" + result));
        } else {
            result.put("startDate", (Object)info.getString("startDate"));
            result.put("endDate", (Object)(cal.get(1) + info.getString("date")));
            log.debug((Object)("\u9636\u68af\u6c14\u4ef7\u65f6\u95f4\uff1a" + result));
        }
        return result;
    }

    public JSONObject compute(JSONObject stairInfo, BigDecimal sumAmount, BigDecimal gas) {
        BigDecimal stair3amount;
        BigDecimal stair2amount;
        BigDecimal stair1amount;
        BigDecimal stair1num = new BigDecimal("0");
        BigDecimal stair2num = new BigDecimal("0");
        BigDecimal stair3num = new BigDecimal("0");
        BigDecimal stair4num = new BigDecimal("0");
        BigDecimal stair1fee = new BigDecimal("0");
        BigDecimal stair2fee = new BigDecimal("0");
        BigDecimal stair3fee = new BigDecimal("0");
        BigDecimal stair4fee = new BigDecimal("0");
        BigDecimal chargenum = new BigDecimal("0");
        int stairMonths = stairInfo.getInt("f_stairmonths");
        JSONObject info = XinLiSystemTools.countDate(new Date());
        if ("4".equals(info.getString("months"))) {
            stair1amount = Util.convertBigDecimal("f_stair1heatamount");
            stair2amount = Util.convertBigDecimal("f_stair2heatamount");
            stair3amount = Util.convertBigDecimal("f_stair2heatamount");
        } else {
            stair1amount = CommonTools.mul((Object)Util.convertBigDecimal("f_stair1amount"), (Object)stairMonths);
            stair2amount = CommonTools.mul((Object)Util.convertBigDecimal("f_stair2amount"), (Object)stairMonths);
            stair3amount = CommonTools.mul((Object)Util.convertBigDecimal("f_stair3amount"), (Object)stairMonths);
        }
        RoundingMode mode = RoundingMode.HALF_UP;
        BigDecimal stair1price = Util.convertBigDecimal("f_stair1price").setScale(2, mode);
        BigDecimal stair2price = Util.convertBigDecimal("f_stair2price").setScale(2, mode);
        BigDecimal stair3price = Util.convertBigDecimal("f_stair3price").setScale(2, mode);
        BigDecimal stair4price = Util.convertBigDecimal("f_stair4price").setScale(2, mode);
        if (!"\u672a\u8bbe".equals(stairInfo.getString("f_stairtype"))) {
            BigDecimal allAmount = sumAmount.add(gas);
            if (sumAmount.compareTo(stair1amount) < 0) {
                if (allAmount.compareTo(stair1amount) < 0) {
                    stair1num = gas;
                    stair1fee = gas.multiply(stair1price);
                    chargenum = gas.multiply(stair1price);
                } else if (allAmount.compareTo(stair1amount) >= 0 && allAmount.compareTo(stair2amount) < 0) {
                    stair1num = stair1amount.subtract(sumAmount);
                    stair1fee = stair1amount.subtract(sumAmount).multiply(stair1price);
                    stair2num = allAmount.subtract(stair1amount);
                    stair2fee = allAmount.subtract(stair1amount).multiply(stair2price);
                    chargenum = stair1fee.add(stair2fee);
                } else if (allAmount.compareTo(stair2amount) >= 0 && allAmount.compareTo(stair3amount) < 0) {
                    stair1num = stair1amount.subtract(sumAmount);
                    stair1fee = stair1amount.subtract(sumAmount).multiply(stair1price);
                    stair2num = stair2amount.subtract(stair1amount);
                    stair2fee = stair2amount.subtract(stair1amount).multiply(stair2price);
                    stair3num = allAmount.subtract(stair2amount);
                    stair3fee = allAmount.subtract(stair2amount).multiply(stair3price);
                    chargenum = stair1fee.add(stair2fee).add(stair3fee);
                } else if (allAmount.compareTo(stair3amount) >= 0) {
                    stair1num = stair1amount.subtract(sumAmount);
                    stair1fee = stair1amount.subtract(sumAmount).multiply(stair1price);
                    stair2num = stair2amount.subtract(stair1amount);
                    stair2fee = stair2amount.subtract(stair1amount).multiply(stair2price);
                    stair3num = stair3amount.subtract(stair2amount);
                    stair3fee = stair3amount.subtract(stair2amount).multiply(stair3price);
                    stair4num = allAmount.subtract(stair3amount);
                    stair4fee = allAmount.subtract(stair3amount).multiply(stair4price);
                    chargenum = stair1fee.add(stair2fee).add(stair3fee).add(stair4fee);
                }
            } else if (sumAmount.compareTo(stair1amount) >= 0 && sumAmount.compareTo(stair2amount) < 0) {
                if (allAmount.compareTo(stair2amount) < 0) {
                    stair2num = gas;
                    chargenum = stair2fee = gas.multiply(stair2price);
                } else if (allAmount.compareTo(stair2amount) >= 0 && allAmount.compareTo(stair3amount) < 0) {
                    stair2num = stair2amount.subtract(sumAmount);
                    stair2fee = stair2amount.subtract(sumAmount).multiply(stair2price);
                    stair3num = allAmount.subtract(stair2amount);
                    stair3fee = allAmount.subtract(stair2amount).multiply(stair3price);
                    chargenum = stair2fee.add(stair3fee);
                } else {
                    stair2num = stair2amount.subtract(sumAmount);
                    stair2fee = stair2amount.subtract(sumAmount).multiply(stair2price);
                    stair3num = stair3amount.subtract(stair2amount);
                    stair3fee = stair3amount.subtract(stair2amount).multiply(stair3price);
                    stair4num = allAmount.subtract(stair3amount);
                    stair4fee = allAmount.subtract(stair3amount).multiply(stair4price);
                    chargenum = stair2fee.add(stair3fee).add(stair4fee);
                }
            } else if (sumAmount.compareTo(stair2amount) >= 0 && sumAmount.compareTo(stair3amount) < 0) {
                if (allAmount.compareTo(stair3amount) < 0) {
                    stair3num = gas;
                    chargenum = stair3fee = gas.multiply(stair3price);
                } else {
                    stair3num = stair3amount.subtract(sumAmount);
                    stair3fee = stair3amount.subtract(sumAmount).multiply(stair3price);
                    stair4num = allAmount.subtract(stair3amount);
                    stair4fee = allAmount.subtract(stair3amount).multiply(stair4price);
                    chargenum = stair3fee.add(stair4fee);
                }
            } else if (sumAmount.compareTo(stair3amount) >= 0) {
                stair4num = gas;
                chargenum = stair4fee = gas.multiply(stair4price);
            }
        } else {
            chargenum = gas.multiply(stair1price);
            stair1num = new BigDecimal("0");
            stair2num = new BigDecimal("0");
            stair3num = new BigDecimal("0");
            stair4num = new BigDecimal("0");
            stair1fee = new BigDecimal("0");
            stair2fee = new BigDecimal("0");
            stair3fee = new BigDecimal("0");
            stair4fee = new BigDecimal("0");
        }
        JSONObject jo = new JSONObject();
        jo.put("stair1num", (Object)stair1num);
        jo.put("stair1fee", (Object)stair1fee);
        jo.put("stair2num", (Object)stair2num);
        jo.put("stair2fee", (Object)stair2fee);
        jo.put("stair3num", (Object)stair3num);
        jo.put("stair3fee", (Object)stair3fee);
        jo.put("stair4num", (Object)stair4num);
        jo.put("stair4fee", (Object)stair4fee);
        jo.put("chargenum", (Object)chargenum);
        return jo;
    }
}

