/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.laidenb.parsedata;

public class TranscodeUtil {
    private static final char[] ALPHABET;
    private static final byte[] CODES;

    public static String byteArrayToBase64Str(byte[] byteArray) {
        return new String(TranscodeUtil.encode(byteArray));
    }

    public static byte[] base64StrToByteArray(String base64Str) {
        char[] dataArr = new char[base64Str.length()];
        base64Str.getChars(0, base64Str.length(), dataArr, 0);
        return TranscodeUtil.decode(dataArr);
    }

    private static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = ALPHABET[quad ? val & 0x3F : 64];
            out[index + 2] = ALPHABET[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = ALPHABET[(val >>= 6) & 0x3F];
            out[index] = ALPHABET[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    private static byte[] decode(char[] data) {
        int len = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == '=') {
            --len;
        }
        if (data.length > 1 && data[data.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (char datum : data) {
            byte value = CODES[datum & 0xFF];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new Error("miscalculated data length!");
        }
        return out;
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        StringBuilder buffer = new StringBuilder(byteArray.length * 2);
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                buffer.append("0");
            }
            buffer.append(Long.toString(byteArray[i] & 0xFF, 16));
        }
        return buffer.toString().toUpperCase();
    }

    public static byte[] hexStrToByteArray(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] encrypted = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            encrypted[i] = (byte)(high * 16 + low);
        }
        return encrypted;
    }

    public static void main(String[] args) {
    }

    static {
        int i;
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        CODES = new byte[256];
        for (i = 0; i < 256; ++i) {
            TranscodeUtil.CODES[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            TranscodeUtil.CODES[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            TranscodeUtil.CODES[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            TranscodeUtil.CODES[i] = (byte)(52 + i - 48);
        }
        TranscodeUtil.CODES[43] = 62;
        TranscodeUtil.CODES[47] = 63;
    }
}

