/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.laidenb.parsedata;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class Tools {
    public static String getNow() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = df.format(new Date());
        return str;
    }

    public static String getNowDT() {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        String str = df.format(new Date());
        return str;
    }

    public static String getNowWeek() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5  EEEE");
        String str = df.format(new Date());
        return str;
    }

    public static String formatFloat(double db) {
        DecimalFormat df = new DecimalFormat("#.00");
        return df.format(db);
    }

    public static String formatRecNo(String recNo) {
        switch (recNo.length()) {
            case 1: {
                recNo = "000" + recNo;
                break;
            }
            case 2: {
                recNo = "00" + recNo;
                break;
            }
            case 3: {
                recNo = "0" + recNo;
                break;
            }
            default: {
                recNo = "0001";
            }
        }
        return recNo;
    }

    public static String getLastYear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(1, -1);
        Date y = c.getTime();
        String year = format.format(y);
        return year;
    }

    public static String getForNDay(int n) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -n);
        String dayDate = new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
        return dayDate;
    }

    public static String getForNRDay(int n) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, n);
        String dayDate = new SimpleDateFormat("yyyyMMdd").format(cal.getTime());
        return dayDate;
    }

    public static String getForNMonth(int n) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -n);
        String monthDate = new SimpleDateFormat("yyyy-MM").format(cal.getTime());
        return monthDate;
    }

    public static String getForNHours(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - n);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String lpad(String id, int len, char c) {
        if (!id.equals("")) {
            while (id.length() < len) {
                id = c + id;
            }
        }
        return id;
    }

    public static Integer getIntDate(String str) {
        str = str.replace("-", "").substring(0, 8);
        Integer intDate = Integer.parseInt(str);
        return intDate;
    }

    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static boolean isNum(String str) {
        return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public static String getMacByIp() throws IOException {
        String MacStr = "";
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mac.length; ++i) {
                int temp = mac[i] & 0xFF;
                String str = Integer.toHexString(temp);
                if (str.length() == 1) {
                    sb.append("0" + str);
                    continue;
                }
                sb.append(str);
            }
            MacStr = sb.toString().toUpperCase();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return MacStr;
    }

    public static String getCurDateY() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return format.format(date);
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static Date strToDateTime(String str) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = df.parse(str);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static String getCurDate() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getFirstDateByCurMonth() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        return format.format(date) + "-01";
    }

    public static String getCurMonth() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        return format.format(date);
    }

    public static String getLastOneYear() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, -1);
        date = calendar.getTime();
        String currentDate = format.format(date);
        return currentDate;
    }

    public static String getLastOneMonth() {
        Calendar curr = Calendar.getInstance();
        curr.set(2, curr.get(2) - 1);
        curr.set(5, curr.get(5) + 1);
        Date date = curr.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getLastOneYears() {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, -1);
        date = calendar.getTime();
        String currentDate = format.format(date);
        return currentDate;
    }

    public static String NullToEmpty(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static int buildRandom(int length) {
        int num = 1;
        double random = Math.random();
        if (random < 0.1) {
            random += 0.1;
        }
        for (int i = 0; i < length; ++i) {
            num *= 10;
        }
        return (int)(random * (double)num);
    }

    public static String hexToBinary(String hex, int n) {
        int decimal = Integer.parseInt(hex, 16);
        String binaryString = Integer.toBinaryString(decimal);
        while (binaryString.length() < n) {
            binaryString = "0" + binaryString;
        }
        return binaryString;
    }

    public static String numToBinary(int num, int n) {
        String binaryString = Integer.toBinaryString(num);
        while (binaryString.length() < n) {
            binaryString = "0" + binaryString;
        }
        return binaryString;
    }

    public static String Integer2HexStr(Integer n) {
        String hex = Integer.toHexString(n);
        if (hex.length() == 1) {
            hex = '0' + hex;
        }
        return hex.toUpperCase();
    }

    public static String getCurrTime() {
        Date now = new Date();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = outFormat.format(now);
        return s;
    }

    public static String getPayNo() {
        String currTime = Tools.getCurrTime();
        int strRandom = Tools.buildRandom(4);
        return currTime + strRandom;
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static void main(String[] args) {
    }
}

