/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.laidenb;

import com.aote.webmeter.module.laidenb.parsedata.TranscodeUtil;
import com.aote.webmeter.module.laidenb.parsedata.UDPDataParse;
import com.aote.webmeter.tools.iot.SignalDeliveryTools;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class LaiDeTools {
    private static final Logger LOGGER = Logger.getLogger(LaiDeTools.class);

    public static JSONObject getData(String isSessionKey, String seUid, String seKey, String seTempKey, String data) {
        if (isSessionKey.equals("1")) {
            data = UDPDataParse.EncryptData_SE(seUid, seKey, seTempKey, "ranStr", data);
        }
        assert (data != null);
        String cmdBase64Value = TranscodeUtil.byteArrayToBase64Str(TranscodeUtil.hexStrToByteArray(data));
        JSONObject result = new JSONObject();
        result.put("ControlCode", (Object)cmdBase64Value);
        result.put("DataLen", data.length() / 2);
        return result;
    }

    public static void main(String[] args) {
        try {
            LaiDeTools.getTransData("", "0", "8104515300000000", "62ADBE451742B9137F522979457BA0CD2B01FC8157201B0F593BA0029D356EE75B1155EF2A72FEEE360F1C7885500197567A2BC2659260F04E3AFE8585A651BC", "6FA7AD5423A683BA5D7DC1288008011687ACC1E887DBD5CD3D56AF0A1D73849BB7F79D472DFA319E8B99559D6B31D81D7C3EAD791D400E09C10639E8C310A0F0", new JSONObject().put("TransData", (Object)"aDAgIAAAAAABgQBQ3Rnk384+U4pxpoeM9yjWPnXzgqi6EG3dwCrpMJjBvkjEJRNZyGPfVK/NZvzae7FKNwEz0WuhTtRuFOv04L29s19C33O6wM6lPr1ky7X5Hx9gFg=="));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getTransData(String deviceId, String isSessionKey, String seUid, String seKey, String seTempKey, JSONObject dataObject) throws IOException {
        String transData_hex = TranscodeUtil.byteArrayToHexStr(TranscodeUtil.base64StrToByteArray(dataObject.get("TransData").toString()));
        int isEncry = 0;
        if (isSessionKey.equals("1")) {
            transData_hex = UDPDataParse.DecryptData_SE(seUid, seKey, seTempKey, "ranStr", transData_hex);
            isEncry = 1;
        }
        String result = UDPDataParse.ParseData(isEncry, transData_hex);
        JSONObject resultObject = new JSONObject(result);
        String meterNumber = resultObject.getString("CodeNumber");
        if (isSessionKey.equals("0") && !result.substring(result.indexOf(64) + 1).equals("0000000000000000")) {
            JSONObject keyResult = new JSONObject(UDPDataParse.WriteGetSEKey(meterNumber, Integer.parseInt(meterNumber.substring(3)), ""));
            if (keyResult.getString("Result").equals("SUCCESS")) {
                String realData = keyResult.getString("CMDHEXString");
                JSONObject realObject = LaiDeTools.getData(isSessionKey, seUid, seKey, seTempKey, realData);
                LOGGER.debug((Object)("\u4e0b\u53d1\u534f\u5546\u5bc6\u94a5\u8bf7\u6c42 \u8bfb\u51faSE\u5bc6\u94a5\u4fe1\u606f:" + realObject));
                SignalDeliveryTools.myPostCommand("MeterControl", "Control", deviceId, realObject);
            } else {
                LOGGER.error((Object)"\u4e0b\u53d1\u534f\u5546\u5bc6\u94a5\u8bf7\u6c42 \u89e3\u6790\u5931\u8d25");
            }
            return null;
        }
        return resultObject;
    }

    public static JSONObject getCommonData(String deviceId, JSONObject resultDetail) throws IOException {
        JSONObject result = new JSONObject();
        String controlAckData = resultDetail.get("ControlAck").toString();
        String controlAckData_hex = TranscodeUtil.byteArrayToHexStr(TranscodeUtil.base64StrToByteArray(controlAckData));
        String MeterNo = controlAckData_hex.substring(4, 18);
        if (controlAckData_hex.length() >= 30) {
            if (controlAckData_hex.startsWith("89", 18) & controlAckData_hex.startsWith("D000", 24)) {
                JSONObject parseCmdExResult = new JSONObject(UDPDataParse.ParseData(1, controlAckData_hex));
                JSONObject parseCmdExResultDetail = parseCmdExResult.getJSONObject("Data");
                LOGGER.debug((Object)"\u4e0b\u53d1\u5199\u5165\u534f\u5546\u5bc6\u94a5\u8bf7\u6c42");
                JSONObject keyResult = new JSONObject(UDPDataParse.WriteSetSessionKey(MeterNo, Integer.parseInt(MeterNo.substring(3)), parseCmdExResultDetail.getString("SEUID") + "#" + parseCmdExResultDetail.getString("SESM2Key") + "#" + parseCmdExResultDetail.getString("SEtempSm2Key") + "#" + parseCmdExResultDetail.getString("RandStr")));
                if (keyResult.get("Result").equals("SUCCESS")) {
                    String realData = keyResult.getString("CMDHEXString");
                    JSONObject realObject = LaiDeTools.getData("1", parseCmdExResultDetail.getString("SEUID"), parseCmdExResultDetail.getString("SESM2Key"), parseCmdExResultDetail.getString("SEtempSm2Key"), realData);
                    LOGGER.debug((Object)("\u4e0b\u53d1\u5199\u5165\u534f\u5546\u5bc6\u94a5\u8bf7\u6c42:" + realObject + " \u5b8c\u6210"));
                    SignalDeliveryTools.myPostCommand("MeterControl", "Control", deviceId, realObject);
                } else {
                    LOGGER.error((Object)"\u4e0b\u53d1\u5199\u5165\u534f\u5546\u5bc6\u94a5\u8bf7\u6c42 \u89e3\u6790\u5931\u8d25");
                }
                parseCmdExResultDetail.put("type", (Object)"1");
                return parseCmdExResultDetail;
            }
            if (controlAckData_hex.startsWith("89", 18) & controlAckData_hex.startsWith("D001", 24)) {
                result.put("type", (Object)"2");
                return result;
            }
        }
        return null;
    }
}

