/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.kashi;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.af.plugins.RestTools;
import com.aote.sql.SqlServer;
import com.aote.webmeter.module.kashi.KaShiInfo;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class KaShiSettlementTools {
    private static Logger log = Logger.getLogger(KaShiSettlementTools.class);
    @Autowired
    private SqlServer sqlServer;

    public void getData() throws Exception {
        WebMeterInfo.setModuleName("KaShi");
        log.info((Object)"\u67e5\u8be2\u8c03\u4ef7\u8be6\u7ec6\u4fe1\u606f");
        JSONArray paramArray = this.sqlServer.query("KaShiGetChangePriceInfo", new JSONObject());
        ConcurrentHashMap<String, JSONArray> data = new ConcurrentHashMap<String, JSONArray>(paramArray.length());
        for (int i = 0; i < paramArray.length(); ++i) {
            JSONObject items = paramArray.getJSONObject(i);
            String meterNumber = items.getString("f_meternumber");
            if (!data.containsKey(meterNumber)) {
                data.put(meterNumber, new JSONArray().put((Object)items));
                continue;
            }
            ((JSONArray)data.get(meterNumber)).put((Object)items);
        }
        log.info((Object)"\u67e5\u8be2\u8c03\u4ef7\u8be6\u7ec6\u4fe1\u606f\u5b8c\u6210");
        if ("1231".equals(DateTools.getNow((String)"MMdd"))) {
            log.info((Object)"\u67e5\u8be2\u8de8\u5e74\u5f02\u5e38\u4fe1\u606f");
            JSONArray priceChangeMeterInfo = this.sqlServer.query("KaShiGetChangeUsersInfo", new JSONObject());
            for (int i = 0; i < priceChangeMeterInfo.length(); ++i) {
                JSONObject items = priceChangeMeterInfo.getJSONObject(i);
                items.put("id", (Object)CommonTools.getUUID());
                String meterNumber = items.getString("f_meternumber");
                if (data.containsKey(meterNumber)) continue;
                paramArray.put((Object)items);
                data.put(meterNumber, new JSONArray().put((Object)items));
            }
        }
        log.info((Object)"\u653e\u5165\u5185\u5b58\u6570\u636e\u5e93\u4e2d");
        KaShiInfo.setData(data);
    }

    public JSONArray settlement(JSONObject obj) {
        String meterNumber;
        ConcurrentHashMap data = KaShiInfo.getData();
        if (data.containsKey(meterNumber = obj.getString("steal_no"))) {
            JSONArray array = (JSONArray)data.remove(meterNumber);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject priceInfo = array.getJSONObject(i);
                JSONObject params = obj.getJSONObject(priceInfo.getString("begin_date"));
                params.put("steal_no", (Object)meterNumber);
                params.put("priceInfo", (Object)priceInfo);
                RestTools.post((String)"http://127.0.0.1:14135/webmeter/rs/logic/KaShiHistorySettlement", (JSONObject)params);
            }
        }
        JSONObject params = obj.getJSONObject(DateTools.getNow((String)"yyMMdd"));
        params.put("steal_no", (Object)meterNumber);
        return new JSONArray(RestTools.post((String)"http://127.0.0.1:14135/webmeter/rs/logic/KaShiHistorySettlement", (JSONObject)params));
    }

    public Boolean checkDataFromKey(String meterNumber) {
        ConcurrentHashMap data = KaShiInfo.getData();
        if (data.containsKey(meterNumber)) {
            log.debug((Object)(meterNumber + "\uff1a\u8bfb\u53d6\u5386\u53f2\u7528\u6c14\u91cf\u6570\u636e"));
            String ip = "http://127.0.0.1:18080/ws/rs/getDailyDatas";
            RestTools.post((String)ip, (String)data.get(meterNumber).toString());
            return true;
        }
        return false;
    }
}

