/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.cangnantcp;

import com.aote.webmeter.module.cangnantcp.HexUtils;
import java.util.Arrays;

public class CRCUtils {
    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static String getCrc(byte[] bytes) {
        int CRC = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            CRC ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC & 1) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                    continue;
                }
                CRC >>= 1;
            }
        }
        CRC = (CRC & 0xFF00) >> 8 | (CRC & 0xFF) << 8;
        return Integer.toHexString(CRC);
    }

    public static String getCrc2(byte[] bytes) {
        int crc = 65535;
        int polynomial = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            crc ^= bytes[i];
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) == 1) {
                    crc >>= 1;
                    crc ^= polynomial;
                    continue;
                }
                crc >>= 1;
            }
        }
        crc = (crc & 0xFF00) >> 8 | (crc & 0xFF) << 8;
        return Integer.toHexString(crc);
    }

    public static void main(String[] args) {
        byte[] data2 = new byte[]{23, 102, 0, -96, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 52, 17, 0, 0, 0, 0, 0, 0, 2, 0, 1, -122, -96, -125, 81, -121, 85, 100, 84, -127, 54, 59, -85, -2, 96};
        byte[] data3 = new byte[]{23, 83, 25, 3, 50, 48, 49, 53, 48, 55, 50, 51, 51, 48, 51, 0, 0, 0, 0, 0, 23, 9, 0, 0, 0, 0, 0, 0};
        byte[] data4 = new byte[]{23, 102, 0, -96, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 52, 17, 0, 0, 0, 0, 0, 0, 2, 0, 1, -122, -96, -125, 81, -121, 85, 100, 84, -127, 54, 59, -85, -2, 96};
        System.out.println(data4.length);
        System.out.println(CRCUtils.getCrc(data4));
        System.out.println(Arrays.toString(HexUtils.toBytes(CRCUtils.getCrc(data4))));
    }
}

