/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.CangNanYGSystem;

import com.af.plugins.JsonTools;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class Tool {
    private final Logger log = Logger.getLogger(Tool.class);
    private CNICCard cnicCard = null;

    public static String genTradeNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String s = sdf.format(new Date());
        for (int i = 0; i < 3; ++i) {
            Random random = new Random();
            s = s + random.nextInt(9);
        }
        return "CNMCSPKYNYN" + s;
    }

    public Tool() {
        try {
            this.cnicCard = (CNICCard)Native.loadLibrary((String)"D:\\TripleMACAndDES_DLL\\CNICCard", CNICCard.class);
        }
        catch (Throwable e) {
            this.log.error((Object)"\u52a0\u8f7d\u82cd\u5357\u7269\u8054\u7f51\u8868\u6a21\u5757\u65f6\uff0c\u52a8\u6001\u5e93\u52a0\u8f7d\u5931\u8d25\uff0c\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u8005\u5965\u67ab\u8f6f\u4ef6\u6280\u672f\u4eba\u5458\u6392\u67e5\u5904\u7406\u3002");
        }
    }

    public String randomStr() {
        Random r = new Random(1L);
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int ran1 = r.nextInt(10);
            ret.append(ran1);
        }
        return ret.toString();
    }

    public JSONObject decryptResponse(String data) {
        JSONObject response = null;
        try {
            response = JsonTools.convertToJson((String)data);
            JSONObject ret = new JSONObject();
            if (response.getInt("code") != 500) {
                String headerStr = response.getString("header");
                JSONObject header = JsonTools.convertToJson((String)StringEscapeUtils.unescapeJava((String)headerStr));
                this.log.info((Object)header.toString());
                return this.decrypt(header, response.getString("content"));
            }
            return null;
        }
        catch (Throwable e) {
            this.log.warn((Object)"\u82cd\u5357\u89e3\u5bc6\u54cd\u5e94\u51fa\u73b0\u672a\u77e5\u9519\u8bef");
            this.log.warn((Object)response.toString());
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject decrypt(JSONObject header, String cipherText) {
        try {
            String disperseKey = header.getString("DisperseKey");
            String macValue = header.getString("MacValue");
            if (this.TripleMAC(macValue, disperseKey) != null) {
                String temp = this.TripleDESDecrypt(cipherText, disperseKey);
                this.log.debug((Object)temp);
                if (temp != null) {
                    return JsonTools.convertToJson((String)temp);
                }
                this.log.warn((Object)"\u89e3\u5bc6\u5931\u8d25");
                return null;
            }
            this.log.warn((Object)"mac \u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u8fd4\u56denull");
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.warn((Object)"\u82cd\u5357\u52a8\u6001\u5e93\u89e3\u5bc6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
            return null;
        }
    }

    public String TripleMAC(String inputData, String randomStr) {
        if (inputData == null || randomStr == null) {
            this.log.warn((Object)"\u5206\u6563\u56e0\u5b50\u6216\u79d8\u94a5\u957f\u5ea6\u4e0d\u6b63\u786e");
            return null;
        }
        Memory pointer = new Memory(1024L);
        int s = this.cnicCard.TripleMAC(inputData, randomStr, (Pointer)pointer);
        if (s == 0) {
            return pointer.getString(0L);
        }
        if (s == -1) {
            this.log.warn((Object)"\u52a8\u6001\u5e93\u672a\u6ce8\u518c\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u82cd\u5357\u4eea\u8868\u5382\u8fdb\u884c\u6ce8\u518c\u3002");
            return null;
        }
        if (s == -2) {
            this.log.warn((Object)"\u5206\u6563\u56e0\u5b50\u6216\u79d8\u94a5\u957f\u5ea6\u4e0d\u6b63\u786e");
            return null;
        }
        this.log.warn((Object)"\u52a8\u6001\u5e93\u8ba1\u7b97MAC\u503c\u51fa\u73b0\u4e00\u4e2a\u9884\u671f\u4e4b\u5916\u7684\u5f02\u5e38");
        this.log.warn((Object)("\u52a0\u5bc6\u5185\u5bb9\uff1a" + inputData));
        this.log.warn((Object)("\u52a0\u5bc6\u56e0\u5b50\uff1a" + randomStr));
        this.log.warn((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + s));
        return null;
    }

    public String TripleDESEncrypt(String inputData, String randomStr) {
        if (inputData == null || randomStr == null) {
            this.log.warn((Object)"\u5206\u6563\u56e0\u5b50\u6216\u79d8\u94a5\u957f\u5ea6\u4e0d\u6b63\u786e");
            return null;
        }
        int s = -1;
        try {
            Memory pointer = new Memory(1024L);
            s = this.cnicCard.TripleDESEncrypt(inputData, randomStr, (Pointer)pointer);
            if (s == 0) {
                return pointer.getString(0L);
            }
            if (s == -1) {
                this.log.warn((Object)"\u52a8\u6001\u5e93\u672a\u6ce8\u518c\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u82cd\u5357\u4eea\u8868\u5382\u8fdb\u884c\u6ce8\u518c\u3002");
                return null;
            }
            if (s == -2) {
                this.log.warn((Object)"\u5206\u6563\u56e0\u5b50\u6216\u79d8\u94a5\u957f\u5ea6\u4e0d\u6b63\u786e");
                return null;
            }
            this.log.warn((Object)"\u52a8\u6001\u5e93\u52a0\u5bc6\u51fa\u73b0\u4e00\u4e2a\u9884\u671f\u4e4b\u5916\u7684\u5f02\u5e38");
            this.log.warn((Object)("\u52a0\u5bc6\u5185\u5bb9\uff1a" + inputData));
            this.log.warn((Object)("\u52a0\u5bc6\u56e0\u5b50\uff1a" + randomStr));
            this.log.warn((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + s));
            return null;
        }
        catch (Throwable e) {
            this.log.warn((Object)"\u52a8\u6001\u5e93\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38");
            this.log.warn((Object)("\u52a0\u5bc6\u5185\u5bb9\uff1a" + inputData));
            this.log.warn((Object)("\u52a0\u5bc6\u56e0\u5b50\uff1a" + randomStr));
            this.log.warn((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + s));
            e.printStackTrace();
            return null;
        }
    }

    public String TripleDESDecrypt(String inputData, String randomStr) {
        if (inputData == null || randomStr == null) {
            this.log.warn((Object)"\u5206\u6563\u56e0\u5b50\u6216\u79d8\u94a5\u957f\u5ea6\u4e0d\u6b63\u786e");
            return null;
        }
        int s = -2;
        try {
            Memory pointer = new Memory(1024L);
            s = this.cnicCard.TripleDESDecrypt(inputData, randomStr, (Pointer)pointer);
            if (s == 0) {
                return pointer.getString(0L);
            }
            if (s == -1) {
                this.log.warn((Object)"\u52a8\u6001\u5e93\u672a\u6ce8\u518c\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u82cd\u5357\u4eea\u8868\u5382\u8fdb\u884c\u6ce8\u518c\u3002");
                return null;
            }
            if (s == -2) {
                this.log.warn((Object)"\u5206\u6563\u56e0\u5b50\u6216\u79d8\u94a5\u957f\u5ea6\u4e0d\u6b63\u786e");
                return null;
            }
            this.log.warn((Object)"\u52a8\u6001\u5e93\u52a0\u5bc6\u51fa\u73b0\u4e00\u4e2a\u9884\u671f\u4e4b\u5916\u7684\u5f02\u5e38");
            this.log.warn((Object)("\u52a0\u5bc6\u5185\u5bb9\uff1a" + inputData));
            this.log.warn((Object)("\u52a0\u5bc6\u56e0\u5b50\uff1a" + randomStr));
            this.log.warn((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + s));
            return null;
        }
        catch (Throwable e) {
            this.log.warn((Object)"\u52a8\u6001\u5e93\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38");
            this.log.warn((Object)("\u52a0\u5bc6\u5185\u5bb9\uff1a" + inputData));
            this.log.warn((Object)("\u52a0\u5bc6\u56e0\u5b50\uff1a" + randomStr));
            this.log.warn((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + s));
            e.printStackTrace();
            return null;
        }
    }

    static {
        System.setProperty("jna.encoding", "GBK");
    }

    static interface CNICCard
    extends Library {
        public int TripleMAC(String var1, String var2, Pointer var3);

        public int TripleDESEncrypt(String var1, String var2, Pointer var3);

        public int TripleDESDecrypt(String var1, String var2, Pointer var3);
    }
}

