package com.aote.webmeter.module.wenxi;

import com.af.plugins.CommonTools;
import com.aote.webmeter.module.xinlisystem.XinLiSystemTools;
import com.aote.webmeter.tools.Util;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class WenXiSpecialCharge {
    static Logger log = Logger.getLogger(WenXiSpecialCharge.class);

    // 计算开始时间方法
    public static JSONObject computeDate(int stairmonths) {
        JSONObject info = XinLiSystemTools.countDate(new Date());
        Calendar cal = Calendar.getInstance();
        JSONObject result = new JSONObject();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        //如果是采暖季
        if ("4".equals(info.getString("months"))) {
            result.put("startDate", info.getString("startDate"));
            cal.add(Calendar.YEAR, 1);
            if (info.has("endDate")) {
                result.put("endDate", info.getString("endDate"));
            } else {
                result.put("endDate", cal.get(Calendar.YEAR) + info.getString("date"));
            }
            log.debug("采暖季阶梯气价时间：" + result);
        } else {
            if (stairmonths == 1) {
                cal.set(Calendar.DATE, 16);
                result.put("startDate",format.format(cal.getTime()));
                cal.add(Calendar.MONTH, 1);
                result.put("endDate",format.format(cal.getTime()));
                log.debug("阶梯气价时间："+result);
            } else if(stairmonths == 6) {
                result.put("startDate",cal.get(Calendar.YEAR) + "0316");
                result.put("endDate",cal.get(Calendar.YEAR) + "0916");
                log.debug("阶梯气价时间："+result);
            } else {
                result.put("startDate", info.getString("startDate"));
                result.put("endDate",cal.get(Calendar.YEAR)+info.getString("date"));
                log.debug("阶梯气价时间："+result);
            }
        }
        return result;
    }

    /**
     * 传入参数:(每档气价,每档限购气量,阶梯月数), 时间段内的累计气量, 本次购气量
     *
     * @return:每档购气量,每档金额
     */
    public JSONObject compute(JSONObject stairInfo, BigDecimal sumAmount, BigDecimal gas) {

        // 计算阶梯气价的中间结果(每档购气量和每档金额)
        BigDecimal stair1num = new BigDecimal("0");
        BigDecimal stair2num = new BigDecimal("0");
        BigDecimal stair3num = new BigDecimal("0");
        BigDecimal stair4num = new BigDecimal("0");
        BigDecimal stair1fee = new BigDecimal("0");
        BigDecimal stair2fee = new BigDecimal("0");
        BigDecimal stair3fee = new BigDecimal("0");
        BigDecimal stair4fee = new BigDecimal("0");
        // 总金额
        BigDecimal chargenum = new BigDecimal("0");
        // 阶梯周期
        int stairMonths = stairInfo.getInt("f_stairmonths");

        JSONObject info = XinLiSystemTools.countDate(new Date());
        BigDecimal stair1amount;
        BigDecimal stair2amount;
        BigDecimal stair3amount;
        //如果是采暖季
        if ("4".equals(info.getString("months"))) {
            stair1amount = Util.convertBigDecimal("f_stair1heatamount");
            stair2amount = Util.convertBigDecimal("f_stair2heatamount");
            stair3amount = Util.convertBigDecimal("f_stair2heatamount");
        } else {
            stair1amount = CommonTools.mul(Util.convertBigDecimal("f_stair1amount"), stairMonths);
            stair2amount = CommonTools.mul(Util.convertBigDecimal("f_stair2amount"), stairMonths);
            stair3amount = CommonTools.mul(Util.convertBigDecimal("f_stair3amount"), stairMonths);
        }

        //四舍五入
        RoundingMode mode = RoundingMode.HALF_UP;

        BigDecimal stair1price = Util.convertBigDecimal("f_stair1price").setScale(2, mode);
        BigDecimal stair2price = Util.convertBigDecimal("f_stair2price").setScale(2, mode);
        BigDecimal stair3price = Util.convertBigDecimal("f_stair3price").setScale(2, mode);
        BigDecimal stair4price = Util.convertBigDecimal("f_stair4price").setScale(2, mode);

        // 针对设置阶梯气价的用户运算
        if (!"未设".equals(stairInfo.getString("f_stairtype"))) {
            // 累计购气量
            BigDecimal allAmount = sumAmount.add(gas);
            // 当前购气量在第一阶梯
            if (sumAmount.compareTo(stair1amount) < 0) {
                if (allAmount.compareTo(stair1amount) < 0) {
                    stair1num = gas;
                    stair1fee = gas.multiply(stair1price);
                    chargenum = gas.multiply(stair1price);
                } else if (allAmount.compareTo(stair1amount) >= 0 && allAmount.compareTo(stair2amount) < 0) {
                    stair1num = stair1amount.subtract(sumAmount);
                    stair1fee = (stair1amount.subtract(sumAmount)).multiply(stair1price);
                    stair2num = allAmount.subtract(stair1amount);
                    stair2fee = (allAmount.subtract(stair1amount)).multiply(stair2price);
                    chargenum = stair1fee.add(stair2fee);
                } else if (allAmount.compareTo(stair2amount) >= 0 && allAmount.compareTo(stair3amount) < 0) {
                    stair1num = stair1amount.subtract(sumAmount);
                    stair1fee = (stair1amount.subtract(sumAmount)).multiply(stair1price);
                    stair2num = stair2amount.subtract(stair1amount);
                    stair2fee = (stair2amount.subtract(stair1amount)).multiply(stair2price);
                    stair3num = allAmount.subtract(stair2amount);
                    stair3fee = (allAmount.subtract(stair2amount)).multiply(stair3price);
                    chargenum = stair1fee.add(stair2fee).add(stair3fee);
                } else if (allAmount.compareTo(stair3amount) >= 0) {
                    stair1num = stair1amount.subtract(sumAmount);
                    stair1fee = (stair1amount.subtract(sumAmount)).multiply(stair1price);
                    stair2num = stair2amount.subtract(stair1amount);
                    stair2fee = (stair2amount.subtract(stair1amount)).multiply(stair2price);
                    stair3num = stair3amount.subtract(stair2amount);
                    stair3fee = (stair3amount.subtract(stair2amount)).multiply(stair3price);
                    stair4num = allAmount.subtract(stair3amount);
                    stair4fee = (allAmount.subtract(stair3amount)).multiply(stair4price);
                    chargenum = stair1fee.add(stair2fee).add(stair3fee).add(stair4fee);
                }
                // 当前已购气量在阶梯二内
            } else if (sumAmount.compareTo(stair1amount) >= 0 && sumAmount.compareTo(stair2amount) < 0) {
                if (allAmount.compareTo(stair2amount) < 0) {
                    stair2num = gas;
                    stair2fee = gas.multiply(stair2price);
                    chargenum = stair2fee;
                } else if (allAmount.compareTo(stair2amount) >= 0 && allAmount.compareTo(stair3amount) < 0) {
                    stair2num = stair2amount.subtract(sumAmount);
                    stair2fee = (stair2amount.subtract(sumAmount)).multiply(stair2price);
                    stair3num = allAmount.subtract(stair2amount);
                    stair3fee = (allAmount.subtract(stair2amount)).multiply(stair3price);
                    chargenum = stair2fee.add(stair3fee);
                } else {
                    stair2num = stair2amount.subtract(sumAmount);
                    stair2fee = (stair2amount.subtract(sumAmount)).multiply(stair2price);
                    stair3num = stair3amount.subtract(stair2amount);
                    stair3fee = (stair3amount.subtract(stair2amount)).multiply(stair3price);
                    stair4num = allAmount.subtract(stair3amount);
                    stair4fee = (allAmount.subtract(stair3amount)).multiply(stair4price);
                    chargenum = stair2fee.add(stair3fee).add(stair4fee);
                }
                // 当前已购气量在阶梯三内
            } else if (sumAmount.compareTo(stair2amount) >= 0 && sumAmount.compareTo(stair3amount) < 0) {
                if (allAmount.compareTo(stair3amount) < 0) {
                    stair3num = gas;
                    stair3fee = gas.multiply(stair3price);
                    chargenum = stair3fee;
                } else {
                    stair3num = stair3amount.subtract(sumAmount);
                    stair3fee = (stair3amount.subtract(sumAmount)).multiply(stair3price);
                    stair4num = allAmount.subtract(stair3amount);
                    stair4fee = (allAmount.subtract(stair3amount)).multiply(stair4price);
                    chargenum = stair3fee.add(stair4fee);
                }
                // 当前已购气量超过阶梯三
            } else if (sumAmount.compareTo(stair3amount) >= 0) {
                stair4num = gas;
                stair4fee = gas.multiply(stair4price);
                chargenum = stair4fee;
            }
            // 该用户未设置阶梯气价
        } else {
            chargenum = gas.multiply(stair1price);
            stair1num = new BigDecimal("0");
            stair2num = new BigDecimal("0");
            stair3num = new BigDecimal("0");
            stair4num = new BigDecimal("0");
            stair1fee = new BigDecimal("0");
            stair2fee = new BigDecimal("0");
            stair3fee = new BigDecimal("0");
            stair4fee = new BigDecimal("0");
        }
        JSONObject jo = new JSONObject();
        jo.put("stair1num", stair1num);
        jo.put("stair1fee", stair1fee);
        jo.put("stair2num", stair2num);
        jo.put("stair2fee", stair2fee);
        jo.put("stair3num", stair3num);
        jo.put("stair3fee", stair3fee);
        jo.put("stair4num", stair4num);
        jo.put("stair4fee", stair4fee);

        jo.put("chargenum", chargenum);
        return jo;
    }
}
