package com.aote.webmeter.module.lanbaoshinb;

import comneg.LbsCdNbCoderDecoder;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Arrays;

public class Tool {

    private static String[] excpetion = new String[]{
            null,
            null,
            null,
            null,
            "余量为零",
            "远程关阀",
            "超小流量",
            "超大流量",
            "防磁",
            "阀门直通",
            "外部掉电",
            "采样1",
            "采样0",
            "电池电量低",
            "内部存储",
            "阀门"
    };

    public static String CommandCoder(String json) {
        return LbsCdNbCoderDecoder.CommandCoder(json);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(reportDecoder("AB55000000001923201272075C2800000000A1000000460000004600000000FFFFFFBA000000000000000000000000300400B413000003EE0000ABAB00343630313133313030393134353839383632343538303434373037353030A1"));
        System.out.println(getAlarmInfo(0));
    }

    public static String reportDecoder(String hex) throws Exception {
        return LbsCdNbCoderDecoder.ReportDecoder(hex);
    }

    public static String getRecharge(String meterNumber,String money) {
        JSONObject data = new JSONObject();
        data.put("ack", "Success");
        data.put("remain", money);
        JSONObject command = new JSONObject();
        command.put("meterNo", meterNumber);
        command.put("cmd", "5");
        command.put("data", data.toString());
        System.out.println(command.toString());
        return LbsCdNbCoderDecoder.CommandCoder(command.toString());
    }

    public static JSONObject getAlarmInfo(Integer number) {
        JSONObject result = new JSONObject();
        byte[] binaryStr = String2binaryString(number);
        System.out.println(Arrays.toString(binaryStr));
        //数据content
        JSONObject content = new JSONObject();
        //异常array
        JSONArray exceptionArray = getExcpetion(binaryStr);
        content.put("f_valve_exception", binaryStr[0]);
        content.put("f_LowLithiumBattery", binaryStr[2]);
        if (binaryStr[3] == 1 || binaryStr[4] == 1) {
            content.put("f_timesException", 1);
        } else {
            content.put("f_timesException", 0);
        }
        content.put("f_leakageFlag", binaryStr[6]);
        content.put("f_magneticInterference", binaryStr[7]);
        if (binaryStr[8] == 1 || binaryStr[9] == 1) {
            content.put("f_overCurrentProtection", 1);
        } else {
            content.put("f_overCurrentProtection", 0);
        }
        content.put("f_networkShutValve", binaryStr[10]);
        result.put("content", content);
        result.put("datas", exceptionArray);
        return result;
    }

    private static JSONArray getExcpetion(byte[] binaryStr) {
        JSONArray exceptionArray = new JSONArray();
        for (int i = 0; i < binaryStr.length; i++) {
            if (binaryStr[i] == 1) {
                String exceptionStr = excpetion[i];
                if (exceptionStr != null) {
                    exceptionArray.put(exceptionStr);
                }
            }
        }
        return exceptionArray;
    }

    public static Integer binaryToDecimal(String binary) {
        return Integer.parseInt(binary, 2);
    }

    private static byte[] String2binaryString(int num) {
        StringBuilder bString = new StringBuilder();
        String nums = Integer.toBinaryString(num);
        if (nums.length() != 16) {
            for (int i = 0; i < 16 - nums.length(); i++) {
                bString.append("0");
            }
        }
        for (int i = 0; i < nums.length(); i++) {
            bString.append(nums.charAt(i));
        }
        //补足0
        byte[] result = new byte[bString.length()];
        for (int i = 0; i < bString.length(); ++i) {
            result[i] = charToByte(bString.charAt(i));
        }
        return result;
    }

    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }
}
