package com.aote.webmeter.module.laidenb.parsedata;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/***
 *
 *
 * @author Administrator
 *
 */
public class UDPDataParse {

	private static Logger logger = Logger.getLogger(UDPDataParse.class);
	public static byte[] CMDMeterNO = new byte[7];
	private static int isEncry = 0;

	public static void main(String args[]) {
		//// System.out.println("DataParseClass");
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteGetSettleDay(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String AESEncryptTest(int isEncty, String CMDHEX) {
		isEncry = isEncty;
		try {

			logger.debug(
					"Start Encrypt Data-----------------------------------------------------------------------------------------------");
			String DataToEncryptLength = CMDHEX.substring(20, 24);
			int dataLength = Integer.parseInt(DataToEncryptLength, 16);
			logger.debug("DATALENGTH:" + dataLength);
			String DataToEncrypt = CMDHEX.substring(24, 24 + (dataLength * 2));
			logger.debug("DATATOENCRYPT:" + DataToEncrypt);
			String DataEncrypted = "";

			int dataGroupInt = dataLength / 16;
			int dataGroupLeft = dataLength % 16;

			for (int i = 0; i < dataGroupInt; i++) {
				String DataToEncrypted = DataToEncrypt.substring((0 + (i * 32)), (0 + (i * 32)) + 32);
				if (isEncty == 1) {
					DataEncrypted += EncryptData(DataToEncrypted);
				} else {
					DataEncrypted += DataToEncrypted;
				}

			}
			if (dataGroupLeft == 0) {
				DataToEncrypt = "80000000000000000000000000000000";
				if (isEncry == 1) {
					DataToEncrypt = EncryptData(DataToEncrypt);
				}
				DataEncrypted += DataToEncrypt; //
			} else {
				DataToEncrypt = DataToEncrypt.substring((dataGroupInt * 32)) + "80";
				String pattern = "00000000000000000000000000000000";
				DataToEncrypt = DataToEncrypt + pattern.substring(0, pattern.length() - DataToEncrypt.length());
				// ////System.out.println("DATAAFTERPADDING:" + DataToEncrypt);
				if (isEncry == 1) {
					DataToEncrypt = EncryptData(DataToEncrypt);
				}
				DataEncrypted += DataToEncrypt; //
			}

			int dataLengthTOback = (dataGroupInt + 1) * 16;
			byte[] lenHexLenth = new byte[2];
			System.arraycopy(Util.intToByteArray(dataLengthTOback), 2, lenHexLenth, 0, 2);

			String LenHexString = Util.bytesToHexString(lenHexLenth);
			// String LenHexString = ByteToHEXString((byte) dataLengthTOback);

			String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, 20) + LenHexString + DataEncrypted);

			// System.out.println("DATATENCRYPTED:" + DataEncrypted);
			//// System.out.println(CSCODE);
			CMDHEX = CMDHEX.substring(0, 20) + LenHexString + DataEncrypted + CSCODE
					+ CMDHEX.substring(CMDHEX.length() - 2);
			return CMDHEX.toUpperCase();
		} catch (Exception e) {
			// TODO: handle exception
			return e.toString().toUpperCase();
		}

	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteGetCheckMeterDay(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteGetBuyMoney(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 * * @param CodeNumber
	 *
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteGetKeyVersion(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 * *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteGetCodeNumber(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetSettleDay(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetCheckMeterDay(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetNewKey(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON       fileName filePath framebytes versionCode
	 * @return
	 * @throws IOException
	 */
	public static String WriteMCUUpdateData(String CodeNumber, int SerialNo, String jSON) throws IOException {
		JSONObject jsonCMD = new JSONObject();
		try {

			JSONObject updateData = JSONObject.fromObject(jSON);

			String versionCode = updateData.getString("versionCode");
			String resversionCode = updateData.getString("resversionCode");
			int frameIndex = updateData.getInt("frameIndex");
			int frameLength = updateData.getInt("frameLength");
			int totalFrameCount = updateData.getInt("totalFrameCount");
			String frameData = updateData.getString("frameData");

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = (byte) (6 + frameLength);
			int bytelenth = 6 + frameLength;
			byte errCode = 0x00;
			if (!versionCode.equals(resversionCode)) {
				DataLength = 0x06;
				bytelenth = 6;
				errCode = (byte) 0x80;
			}
			if (frameIndex > totalFrameCount) {
				DataLength = 0x06;
				bytelenth = 6;
				errCode = (byte) 0x02;
			}

			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[14 + bytelenth];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(bytelenth); // byte[] newDataLenth =
																	// Util.intToByteArray(DataLength); //CMDALL[10] =
																	// DataLength; \n System.arraycopy(newDataLenth, 2,
																	// CMDALL, 10, 2);
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[15] = errCode;

			byte[] Datalength = Util.intToByteArray(frameIndex); // byte[] newDataLenth =
																	// Util.intToByteArray(DataLength); //CMDALL[10] =
																	// DataLength; \n System.arraycopy(newDataLenth, 2,
																	// CMDALL, 10, 2);
			System.arraycopy(Datalength, 2, CMDALL, 16, 2);
			if (DataLength != 0x03) {
				System.arraycopy(Util.toByteArray(frameData), 0, CMDALL, 18, frameLength);
			}
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteResponseMCUUpdateFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON       fileName filePath framebytes versionCode
	 * @return
	 */
	public static String WriteRequestMCUUpdate(String CodeNumber, int SerialNo, String jSON) {
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = 17;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			JSONObject updateData = JSONObject.fromObject(jSON);
			byte[] CMDALL = new byte[31];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;

			byte[] newDataLenth = Util.intToByteArray(DataLength);
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			int frameBytes = updateData.getInt("frameLength");

			JSONObject mcuReturnDataJSON = JSONObject.fromObject(jSON);
			byte versionCodeBytetmp[] = Util.hexToByteArray(mcuReturnDataJSON.getString("versionCode"));
			System.arraycopy(versionCodeBytetmp, 0, CMDALL, 15, 4);
			String startAddress = mcuReturnDataJSON.getString("startAddress");
			System.arraycopy(Util.toByteArray(startAddress), 0, CMDALL, 19, 4);
			int totalFrameCount = mcuReturnDataJSON.getInt("totalFrameCount");
			System.arraycopy(Util.intToByteArray(totalFrameCount), 2, CMDALL, 23, 2);
			System.arraycopy(Util.intToByteArray(frameBytes), 2, CMDALL, 25, 2);
			int crc_codeInt = mcuReturnDataJSON.getInt("reg_crc_16");
			String crc_code = Integer.toHexString(crc_codeInt).toUpperCase();
			System.arraycopy(Util.toByteArray(crc_code), 0, CMDALL, 27, 2);
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteRequestMCUUpdateFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetCodeNumber(String CodeNumber, int SerialNo, String jSON) {
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			String NewMeterNo = json.getString("NewMeterNo");
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x15;
			byte DataLength = (byte) 10;
			byte[] CMDALL = new byte[24];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// byte[] newDataLenth = Util.intToByteArray(DataLength); //CMDALL[10] =
			// DataLength; \n System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDMeterNO = Util.str2Bcd(NewMeterNo);
			System.arraycopy(CMDMeterNO, 0, CMDALL, 15, 7);
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			String CMDHEX = Util.bytesToHexString(CMDALL);
			//// System.out.println(CMDHEX);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetMeterNoFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
			//// System.out.println(CSCODE);
			CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			// if (Constant.isEencrypt) {
			// CMDHEX = PackageEncryptCMDBody(CMDHEX);
			// }

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();

		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetOutFactory(String CodeNumber, int SerialNo, String jSON) {
		return null;
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetAccumulatedGas(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;

		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			Double AccumulatedGasTmp = Double.parseDouble(json.get("AccumulatedGas").toString());
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x16;
			byte DataLength = 0x08;// 17
			byte[] CMDALL = new byte[22];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// byte[] newDataLenth = Util.intToByteArray(DataLength); //CMDALL[10] =
			// DataLength; \n System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);

			CMDALL[14] = SerialNO;
			int AccumulatedGasInt = (int) Math.floor(AccumulatedGasTmp);
			int AccumilatedGasDouble = (int) ((AccumulatedGasTmp - AccumulatedGasInt) * 100 + 0.5);

			byte[] AccumulatedGasInts = Util.intToByteArray(AccumulatedGasInt);

			byte AccumilatedGasDoubleInCmd = (byte) AccumilatedGasDouble;
			System.arraycopy(AccumulatedGasInts, 0, CMDALL, 15, 4);
			CMDALL[19] = AccumilatedGasDoubleInCmd;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			String CMDHEX = Util.bytesToHexString(CMDALL);
			//// System.out.println(CMDHEX);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteAccumulatedGasFlag + CMDHEX.substring(28, CMDHEX.length());
			String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
			//// System.out.println(CSCODE);
			CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			// if (Constant.isEencrypt) {
			// CMDHEX = PackageEncryptCMDBody(CMDHEX);
			// }
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON       ControlType 0--open 1--close 2--cancel
	 *
	 */
	public static String WriteValveControl(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			int ControlType = Integer.parseInt(json.get("ControlType").toString());
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = 0x04;// 17
			byte[] CMDALL = new byte[18];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[15] = (byte) 0x99;
			switch (ControlType) {
			case 0:
				CMDALL[15] = (byte) 0x55;
				//// System.out.println("ControlType 0x55");
				break;
			case 1:
				CMDALL[15] = (byte) 0x99;
				//// System.out.println("ControlType 0x99");
				break;
			case 2:
				CMDALL[15] = (byte) 0x00;
				//// System.out.println("ControlType 0x00");
				break;
			default:
				break;
			}

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			String CMDHEX = Util.bytesToHexString(CMDALL);
			//// System.out.println(CMDHEX);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteValveControlFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return {"CodeNumber":"11223344556677","SerialNo":1,"CMDHEXString":"68301122334455667704109F27DC37D23767EE21F356A1E680F4B8DC16"}
	 */
	public static String WriteChargeMoney(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = 0x08;
			JSONObject json = JSONObject.fromObject(jSON);
			double money = Double.parseDouble(json.get("ChargeMoney").toString());
			int chargetime = json.getInt("ChargeTime");
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[21];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			int MoneyInt = (int) money;
			byte[] MoneyInts = Util.intToByteArray(MoneyInt);
			int MoneyDouble = (int) (money * 100 - MoneyInt * 100);
			byte MoneyDoubleInCmd = (byte) MoneyDouble;
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[15] = (byte) chargetime;
			System.arraycopy(MoneyInts, 1, CMDALL, 16, 3);
			CMDALL[19] = MoneyDoubleInCmd;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteChargeMoneyFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("1111" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jsondata   {'TestMoney':1,'TestPrice':2}
	 * @return
	 */
	public static String WriteTestData(String CodeNumber, int SerialNo, String jsondata) {
		JSONObject jsonCMD = new JSONObject();
		try {
			byte CMDFlag1 = (byte) 0xAA;
			byte CMDFlag2 = (byte) 0x03;
			byte SerialNO = 0x01;
			byte ControlCode = 0x04;
			byte DataLength = 0x09;
			JSONObject json = JSONObject.fromObject(jsondata);
			double money = Double.parseDouble(json.get("TestMoney").toString());
			double price = Double.parseDouble(json.getString("TestPrice").toString());
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[23];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[12] = CMDFlag1;
			CMDALL[13] = CMDFlag2;
			CMDALL[14] = SerialNO;
			int MoneyInt = (int) money;
			byte[] MoneyInts = Util.intToByteArray(MoneyInt);
			int MoneyDouble = (int) (money * 100 - MoneyInt * 100);
			byte MoneyDoubleInCmd = (byte) MoneyDouble;
			System.arraycopy(MoneyInts, 1, CMDALL, 15, 3);
			CMDALL[18] = MoneyDoubleInCmd;
			int PriceInt = (int) price;
			byte PriceInts = (byte) PriceInt;
			int PriceDouble = (int) (price * 100 - PriceInt * 100);
			byte PriceDoubleInCmd = (byte) PriceDouble;
			CMDALL[19] = PriceInts;
			CMDALL[20] = PriceDoubleInCmd;
			String CMDHEX = Util.bytesToHexString(CMDALL);
			// String CSCode = Util.makeChecksum1(CMDHEX);
			// byte csCode[] = Util.hexStringToByte(CSCode);

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			CMDHEX = Util.bytesToHexString(CMDALL);
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jsondata
	 * @return
	 */
	public static String WriteGetPrice(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WritePriceFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetParam(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetMeterParamFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/****
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetRecords(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetRecordsFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/****
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON       bindData 0 成功 1 失敗
	 * @return
	 */
	public static String WriteConfirBindResult(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			JSONObject adata = JSONObject.fromObject(JSON);
			int bindResult = adata.getInt("bindResult");
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x04;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[18];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;

			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// byte[] newDataLenth = Util.intToByteArray(DataLength); //CMDALL[10] =
			// DataLength; \n System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[15] = (byte) bindResult;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteBindCardInfoFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGet24HoursRecords(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject jsdata = JSONObject.fromObject(JSON);
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x07;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[21];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			String startDate = jsdata.getString("startDate");
			byte[] startDateBCD = Util.StrToBCDBytes(startDate);
			System.arraycopy(startDateBCD, 0, CMDALL, 15, 3);

			int readDays = jsdata.getInt("readDays");
			CMDALL[18] = (byte) readDays;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGet24HoursRecordsFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetModuleInfo(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetModuleInfoFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);

			System.out.println("22" + CMDHEX.toString());
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("11" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetReportTimeOne(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetReportTimeOneFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetReportIPOne(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetReportIPOneFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX)
			;
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 * 发起协商密钥请求
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetSEKey(String CodeNumber, int SerialNo, String JSON) {
		JSONObject jsonCMD = new JSONObject();

		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x09;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;

			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteRequestSessionKeyFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
			CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/****
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetReportTimeTwo(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetReportTimeTwoFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetReportIPTwo(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetReportIPTwoFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetReportTimeThree(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetReportTimeThreeFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param JSON
	 * @return
	 */
	public static String WriteGetReportIPThree(int Encrytype, String CodeNumber, int SerialNo, String JSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x01;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetReportIPThreeFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jsondata
	 * @return
	 */
	public static String WriteDisConnect(int Encrytype, String CodeNumber, int SerialNo, String jsondata) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.DisConnectFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 */
	public static String WriteTime(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = 0x0A;
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CheckTime = Util.str2Bcd(json.get("CheckTime").toString());
			byte[] CMDALL = new byte[24];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			System.arraycopy(CheckTime, 0, CMDALL, 15, 7);
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;

			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteTimeFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);

			/** */
			// CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteTimeFlag +
			// CMDHEX.substring(28, CMDHEX.length());
			// ////System.out.println(CMDHEX);
			// String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4)
			// );
			// ////System.out.println(CSCODE);
			// CMDHEX = CMDHEX.substring(0,CMDHEX.length() - 4)+ CSCODE
			// + CMDHEX.substring(CMDHEX.length() - 2);
			// ////System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetPrice(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			int effectDateCount = json.getInt("priceDateCount");
			int priceDetailCount = json.getInt("priceDetailCount");
			// int pirceTypeTmp = json.getInt("priceType");
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = (byte) (8 + (2 * effectDateCount) + (24 * priceDetailCount) + 3);

			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[14 + 8 + 3 + (2 * effectDateCount) + (24 * priceDetailCount)];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n \
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			// "priceType":1,"isChangePrice":1,"priceEffectDate":"18122101","priceDateCount":4,"pirceDate":[{"Month":"1","Day":2,"PriceType":"0"},{"Month":"6","Day":15,"PriceType":"1"},{"Month":"7","Day":26,"PriceType":"0"},{"Month":"9","Day":19,"PriceType":"1"}],"PriceDetail":[{"PriceOne":1.1,"GasOne":11,"PriceTwo":1.2,"GasTwo":12,"PriceThree":1.3,"NewPriceOne":1.01,"NewGasOne":101,"NewPriceTwo":1.02,"NewGasTwo":102,"NewPriceThree":1.03},{"PriceOne":2.1,"GasOne":21,"PriceTwo":2.2,"GasTwo":22,"PriceThree":2.3,"NewPriceOne":2.01,"NewGasOne":201,"NewPriceTwo":2.02,"NewGasTwo":202,"NewPriceThree":2.03}]}
			CMDALL[15] = (byte) json.getInt("priceType");
			CMDALL[16] = (byte) json.getInt("isChangePrice");

			CMDALL[17] = (byte) Integer.parseInt(json.getString("priceEffectDate").substring(0, 2));
			CMDALL[18] = (byte) Integer.parseInt(json.getString("priceEffectDate").substring(2, 4));
			CMDALL[19] = (byte) Integer.parseInt(json.getString("priceEffectDate").substring(4, 6));
			CMDALL[20] = (byte) Integer.parseInt(json.getString("priceEffectDate").substring(7));

			CMDALL[21] = (byte) effectDateCount;
			String DateHex = "";
			if (effectDateCount != 0) {
				JSONArray datejson = json.getJSONArray("priceDate");

				for (int i = 0; i < effectDateCount; i++) {
					DateHex += Util.Int2Hex(datejson.getJSONObject(i).getInt("Month")).substring(1)
							+ Util.Int2Hex(datejson.getJSONObject(i).getInt("PriceType")).substring(1)
							+ Util.Int2Hex(datejson.getJSONObject(i).getInt("Day"));
				}
			}
			CMDALL[22 + (effectDateCount * 2)] = (byte) priceDetailCount;
			JSONArray pricejson = json.getJSONArray("PriceDetail");
			for (int i = 0; i < priceDetailCount; i++) {

				// [{"PriceOne":1.1,"GasOne":11,"PriceTwo":1.2,"GasTwo":12,"PriceThree":1.3,"NewPriceOne":1.01,"NewGasOne":101,"NewPriceTwo":1.02,"NewGasTwo":102,"NewPriceThree":1.03},{"PriceOne":2.1,"GasOne":21,"PriceTwo":2.2,"GasTwo":22,"PriceThree":2.3,"NewPriceOne":2.01,"NewGasOne":201,"NewPriceTwo":2.02,"NewGasTwo":202,"NewPriceThree":2.03}]}

				double priceOne = pricejson.getJSONObject(i).getDouble("PriceOne");
				int priceOneInt = (int) Math.floor(priceOne);
				int priceOneDouble = (int) (priceOne * 100 - priceOneInt * 100);
				CMDALL[22 + (effectDateCount * 2) + 1 + 24 * i] = (byte) priceOneInt;
				CMDALL[22 + (effectDateCount * 2) + 2 + 24 * i] = (byte) priceOneDouble;
				int GasOne = pricejson.getJSONObject(i).getInt("GasOne");
				byte[] GasOneTmp = Util.intToByteArray(GasOne);
				System.arraycopy(GasOneTmp, 1, CMDALL, 22 + (effectDateCount * 2) + 3 + 24 * i, 3);

				double priceTwo = pricejson.getJSONObject(i).getDouble("PriceTwo");
				int priceTwoInt = (int) Math.floor(priceTwo);
				int priceTwoDouble = (int) (priceTwo * 100 - priceTwoInt * 100 + 0.05);
				CMDALL[22 + (effectDateCount * 2) + 6 + 24 * i] = (byte) priceTwoInt;
				CMDALL[22 + (effectDateCount * 2) + 7 + 24 * i] = (byte) priceTwoDouble;

				int GasTwo = pricejson.getJSONObject(i).getInt("GasTwo");
				byte[] GasTwoTmp = Util.intToByteArray(GasTwo);
				System.arraycopy(GasTwoTmp, 1, CMDALL, 22 + (effectDateCount * 2) + 8 + 24 * i, 3);

				double priceThree = pricejson.getJSONObject(i).getDouble("PriceThree");
				int priceThreeInt = (int) Math.floor(priceThree);
				int priceThreeDouble = (int) (priceThree * 100 - priceThreeInt * 100 + 0.05);
				CMDALL[22 + (effectDateCount * 2) + 11 + 24 * i] = (byte) priceThreeInt;
				CMDALL[22 + (effectDateCount * 2) + 12 + 24 * i] = (byte) priceThreeDouble;

				double NewpriceOne = pricejson.getJSONObject(i).getDouble("NewPriceOne");
				int NewpriceOneInt = (int) Math.floor(NewpriceOne);
				int NewpriceOneDouble = (int) (NewpriceOne * 100 - NewpriceOneInt * 100 + 0.05);
				CMDALL[22 + (effectDateCount * 2) + 13 + 24 * i] = (byte) NewpriceOneInt;
				CMDALL[22 + (effectDateCount * 2) + 14 + 24 * i] = (byte) NewpriceOneDouble;

				int NewGasOne = pricejson.getJSONObject(i).getInt("NewGasOne");
				byte[] NewGasOneTmp = Util.intToByteArray(NewGasOne);
				System.arraycopy(NewGasOneTmp, 1, CMDALL, 22 + (effectDateCount * 2) + 15 + 24 * i, 3);

				double NewpriceTwo = pricejson.getJSONObject(i).getDouble("NewPriceTwo");
				int NewpriceTwoInt = (int) Math.floor(NewpriceTwo);
				int NewpriceTwoDouble = (int) (NewpriceTwo * 100 - NewpriceTwoInt * 100 + 0.05);
				CMDALL[22 + (effectDateCount * 2) + 18 + 24 * i] = (byte) NewpriceTwoInt;
				CMDALL[22 + (effectDateCount * 2) + 19 + 24 * i] = (byte) NewpriceTwoDouble;

				int NewGasTwo = pricejson.getJSONObject(i).getInt("NewGasTwo");
				byte[] NewGasTwoTmp = Util.intToByteArray(NewGasTwo);
				System.arraycopy(NewGasTwoTmp, 1, CMDALL, 22 + (effectDateCount * 2) + 20 + 24 * i, 3);

				double NewpriceThree = pricejson.getJSONObject(i).getDouble("NewPriceThree");

				int NewpriceThreeInt = (int) Math.floor(NewpriceThree);
				int NewpriceThreeDouble = (int) (NewpriceThree * 100 - NewpriceThreeInt * 100 + 0.05);
				CMDALL[22 + (effectDateCount * 2) + 23 + 24 * i] = (byte) NewpriceThreeInt;
				CMDALL[22 + (effectDateCount * 2) + 24 + 24 * i] = (byte) NewpriceThreeDouble;

			}
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetPriceFlag + CMDHEX.substring(28, CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetPriceFlag + CMDHEX.substring(28, 44) + DateHex
					+ CMDHEX.substring(44 + DateHex.length(), CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetParam(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[41];
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = (byte) 27;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[15] = (byte) json.getInt("deathMeterFlag");
			CMDALL[16] = (byte) json.getInt("deathMeterOne");
			CMDALL[17] = (byte) json.getInt("deathMeterTwo");
			CMDALL[18] = (byte) json.getInt("limitBuyFlag");

			byte LimintBuyMoneyTmp[] = new byte[4];
			LimintBuyMoneyTmp = Util.intToByteArray(json.getInt("limitBuyMoney"));
			System.arraycopy(LimintBuyMoneyTmp, 1, CMDALL, 19, 3);

			CMDALL[22] = (byte) 0xa5;
			CMDALL[23] = (byte) json.getInt("isForceSrape");
			CMDALL[24] = (byte) json.getInt("isOverFlow");

			byte overFlowParamTmp[] = new byte[4];
			overFlowParamTmp = Util.intToByteArray(json.getInt("overFlowParam"));
			System.arraycopy(overFlowParamTmp, 2, CMDALL, 25, 2);

			CMDALL[31] = (byte) json.getInt("forceSafeCheckYear");

			CMDALL[34] = (byte) json.getInt("forceScrapYear");

			CMDALL[37] = (byte) json.getInt("alarmValueOne");
			CMDALL[38] = (byte) json.getInt("alarmValueTwo");

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetParamFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteSetReportTimeOne(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[19];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 5;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			int reportType = json.getInt("reportType");
			int reportTime = json.getInt("reportTime");
			int reportSpace = json.getInt("reportSpace");
			CMDALL[15] = (byte) reportType;
			String binaryH = "110";
			if (reportType == 1) {
				binaryH = "110";
			} else if (reportType == 0) {
				binaryH = "100";
			}

			String binaryL = String.format("%08d", (Integer.parseInt(Integer.toBinaryString(reportTime))));
			// reportTimeString= String.format("%08d",
			// (Integer.parseInt(reportTimeString)));
			binaryL = binaryL.substring(3);
			String reportTimeStr = binaryH + binaryL;
			//// System.out.println("reportTimeBinaryData:" + reportTimeStr);
			CMDALL[15] = (byte) Util.convertToDecimal(reportTimeStr);
			CMDALL[16] = (byte) reportSpace;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetReportTimeOneFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteSetReportTimeTwo(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[19];
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x04;
			byte DataLength = (byte) 5;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			int reportType = json.getInt("reportType");
			int reportTime = json.getInt("reportTime");
			int reportSpace = json.getInt("reportSpace");
			CMDALL[15] = (byte) reportType;
			String binaryH = "110";
			if (reportType == 1) {
				binaryH = "110";
			} else if (reportType == 0) {
				binaryH = "100";
			}

			String binaryL = String.format("%08d", (Integer.parseInt(Integer.toBinaryString(reportTime))));
			// reportTimeString= String.format("%08d",
			// (Integer.parseInt(reportTimeString)));
			binaryL = binaryL.substring(3);
			String reportTimeStr = binaryH + binaryL;
			//// System.out.println("reportTimeBinaryData:" + reportTimeStr);
			CMDALL[15] = (byte) Util.convertToDecimal(reportTimeStr);
			CMDALL[16] = (byte) reportSpace;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetReportTimeTwoFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteSetReportTimeThree(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[19];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 5;

			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			int reportType = json.getInt("reportType");
			int reportTime = json.getInt("reportTime");
			int reportSpace = json.getInt("reportSpace");
			CMDALL[15] = (byte) reportType;
			String binaryH = "110";
			if (reportType == 1) {
				binaryH = "110";
			} else if (reportType == 0) {
				binaryH = "100";
			}

			String binaryL = String.format("%08d", (Integer.parseInt(Integer.toBinaryString(reportTime))));
			// reportTimeString= String.format("%08d",
			// (Integer.parseInt(reportTimeString)));
			binaryL = binaryL.substring(3);
			String reportTimeStr = binaryH + binaryL;
			//// System.out.println("reportTimeBinaryData:" + reportTimeStr);
			CMDALL[15] = (byte) Util.convertToDecimal(reportTimeStr);
			CMDALL[16] = (byte) reportSpace;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetReportTimeThreeFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteSetReportIPOne(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[23];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 9;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			//// System.out.println(json.getString("reportIP"));
			String[] repotyIpStr = json.getString("reportIP").split("\\.");
			int reportPort = json.getInt("reportPort");
			CMDALL[15] = (byte) (Integer.parseInt(repotyIpStr[0]));
			CMDALL[16] = (byte) (Integer.parseInt(repotyIpStr[1]));
			CMDALL[17] = (byte) (Integer.parseInt(repotyIpStr[2]));
			CMDALL[18] = (byte) (Integer.parseInt(repotyIpStr[3]));
			byte reportIpbyte[] = new byte[4];
			reportIpbyte = Util.intToByteArray(reportPort);
			System.arraycopy(reportIpbyte, 2, CMDALL, 19, 2);
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetReportIPOneFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteSetReportIPTwo(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[23];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 9;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			String[] repotyIpStr = json.getString("reportIP").split("\\.");
			int reportPort = json.getInt("reportPort");
			CMDALL[15] = (byte) (Integer.parseInt(repotyIpStr[0]));
			CMDALL[16] = (byte) (Integer.parseInt(repotyIpStr[1]));
			CMDALL[17] = (byte) (Integer.parseInt(repotyIpStr[2]));
			CMDALL[18] = (byte) (Integer.parseInt(repotyIpStr[3]));
			byte reportIpbyte[] = new byte[4];
			reportIpbyte = Util.intToByteArray(reportPort);
			System.arraycopy(reportIpbyte, 2, CMDALL, 19, 2);
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetReportIPTwoFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	// jSON {"PulseDay":1}; 0--昨天 1--前天 2--大前天。。。
	public static String WriteGetMeterPulseInfo(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[18];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 4;
			byte ControlCode = 0x01;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[15] = (byte) json.getInt("PulseDay");
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetMeterPulseInfoFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteSetReportIPThree(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[23];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 9;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			String[] repotyIpStr = json.getString("reportIP").split("\\.");
			int reportPort = json.getInt("reportPort");
			CMDALL[15] = (byte) (Integer.parseInt(repotyIpStr[0]));
			CMDALL[16] = (byte) (Integer.parseInt(repotyIpStr[1]));
			CMDALL[17] = (byte) (Integer.parseInt(repotyIpStr[2]));
			CMDALL[18] = (byte) (Integer.parseInt(repotyIpStr[3]));
			byte reportIpbyte[] = new byte[4];
			reportIpbyte = Util.intToByteArray(reportPort);
			System.arraycopy(reportIpbyte, 2, CMDALL, 19, 2);
			CMDALL[CMDALL.length - 1] = CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetReportIPThreeFlag
					+ CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetReSetMeter(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {

			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[17];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 3;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetResetMeterFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetRepairMeter(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			CMDMeterNO = Util.str2Bcd(CodeNumber);

			byte[] CMDALL = new byte[17];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 3;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetRepairMeterFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	/***
	 *
	 *
	 * @param CodeNumber
	 * @param SerialNo
	 * @param jSON
	 * @return
	 */
	public static String WriteSetSafeCheck(int Encrytype, String CodeNumber, int SerialNo, String jSON) {
		isEncry = Encrytype;
		JSONObject jsonCMD = new JSONObject();
		try {
			JSONObject json = JSONObject.fromObject(jSON);
			CMDMeterNO = Util.str2Bcd(CodeNumber);

			String safeCheckJobNumber = json.getString("safeCheckJobNumber");
			byte safeCheckJobNumberTmp[] = new byte[6];
			safeCheckJobNumberTmp = Util.str2Bcd(safeCheckJobNumber);
			byte[] CMDALL = new byte[20];
			byte SerialNO = (byte) SerialNo;
			byte DataLength = (byte) 6;
			byte ControlCode = 0x04;
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength);
			// CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			System.arraycopy(safeCheckJobNumberTmp, 0, CMDALL, 15, 3);
			CMDALL[CMDALL.length - 1] = CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			// ////System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);

			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetSafeCheckFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX);
			if (Constant.isEencrypt) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}
			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}
	//

	/***
	 *
	 *
	 * @param CMDHEX
	 * @return
	 */
	public static String PackageEncryptCMDBody(String CMDHEX) {
		try {

			logger.debug(
					"Start Encrypt Data-----------------------------------------------------------------------------------------------");
			String DataToEncryptLength = CMDHEX.substring(20, 24);
			int dataLength = Integer.parseInt(DataToEncryptLength, 16);
			logger.debug("DATALENGTH:" + dataLength);
			String DataToEncrypt = CMDHEX.substring(24, 24 + (dataLength * 2));
			logger.debug("DATATOENCRYPT:" + DataToEncrypt);
			String DataEncrypted = "";

			int dataGroupInt = dataLength / 16;
			int dataGroupLeft = dataLength % 16;

			for (int i = 0; i < dataGroupInt; i++) {
				String DataToEncrypted = DataToEncrypt.substring((0 + (i * 32)), (0 + (i * 32)) + 32);
				if (isEncry == 1) {
					DataEncrypted += EncryptData(DataToEncrypted);
				} else {
					DataEncrypted += DataToEncrypted;
				}

			}
			if (dataGroupLeft == 0) {
				DataToEncrypt = "80000000000000000000000000000000";
				if (isEncry == 1) {
					DataToEncrypt = EncryptData(DataToEncrypt);
				}
				DataEncrypted += DataToEncrypt; //
			} else {
				DataToEncrypt = DataToEncrypt.substring((dataGroupInt * 32)) + "80";
				String pattern = "00000000000000000000000000000000";
				DataToEncrypt = DataToEncrypt + pattern.substring(0, pattern.length() - DataToEncrypt.length());
				// ////System.out.println("DATAAFTERPADDING:" + DataToEncrypt);
				if (isEncry == 1) {
					DataToEncrypt = EncryptData(DataToEncrypt);
				}
				DataEncrypted += DataToEncrypt; //
			}

			int dataLengthTOback = (dataGroupInt + 1) * 16;
			byte[] lenHexLenth = new byte[2];
			System.arraycopy(Util.intToByteArray(dataLengthTOback), 2, lenHexLenth, 0, 2);

			String LenHexString = Util.bytesToHexString(lenHexLenth);
			// String LenHexString = ByteToHEXString((byte) dataLengthTOback);

			String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, 20) + LenHexString + DataEncrypted);

			// System.out.println("DATATENCRYPTED:" + DataEncrypted);
			//// System.out.println(CSCODE);
			CMDHEX = CMDHEX.substring(0, 20) + LenHexString + DataEncrypted + CSCODE
					+ CMDHEX.substring(CMDHEX.length() - 2);
			return CMDHEX.toUpperCase();
		} catch (Exception e) {
			// TODO: handle exception
			return e.toString().toUpperCase();
		}
	}

	private static String ByteToHEXString(byte bytedata) {
		String LenHexString = "";
		String hex = Integer.toHexString(bytedata & 0xFF);
		if (hex.length() == 1) {
			hex = '0' + hex;
		}

		LenHexString = LenHexString + hex;
		return LenHexString;
	}

	/***
	 *
	 *
	 * @param dataToEncrypt
	 * @return
	 */
	private static String EncryptData(String dataToEncrypt) {
		try {

			byte KeyToEn[] = Util.toByteArray(Constant.Keys);
			SecretKey secretKey = AESUtil.strKey2SecretKey(KeyToEn);

			byte DataToEN[] = Util.toByteArray(dataToEncrypt);

			byte[] encryptAESbytes;
			encryptAESbytes = AESUtil.encryptAES(DataToEN, secretKey);
			dataToEncrypt = Util.bytesToHexString(encryptAESbytes);
			// ////System.out.println("DATAAFTERENCRYPT:" + dataToEncrypt.toUpperCase());
			return dataToEncrypt;
		} catch (InvalidKeyException e) {

			e.printStackTrace();
			return "EncryptData ERR";
		} catch (NoSuchPaddingException e) {

			e.printStackTrace();
			return "EncryptData ERR";
		} catch (NoSuchAlgorithmException e) {

			e.printStackTrace();
			return "EncryptData ERR";
		} catch (BadPaddingException e) {

			e.printStackTrace();
			return "EncryptData ERR";
		} catch (IllegalBlockSizeException e) {

			e.printStackTrace();
			return "EncryptData ERR";
		}
	}

	/***
	 *
	 *
	 * @param CMDHEX
	 * @return
	 */
	public static String DencryptData(String dataToDencrypt) {
		try {

			byte KeyToEn[] = Util.toByteArray(Constant.Keys);
			SecretKey secretKey = AESUtil.strKey2SecretKey(KeyToEn);

			byte DataToDEN[] = Util.toByteArray(dataToDencrypt);
			byte[] decryptAESStr1;
			decryptAESStr1 = AESUtil.decryptAES(DataToDEN, secretKey);
			dataToDencrypt = Util.bytesToHexString(decryptAESStr1);
			return dataToDencrypt;
		} catch (InvalidKeyException e) {
			e.printStackTrace();
			return "DencryptData ERR";
		} catch (NoSuchPaddingException e) {
			e.printStackTrace();
			return "DencryptData ERR";
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
			return "DencryptData ERR";
		} catch (BadPaddingException e) {
			e.printStackTrace();
			return "DencryptData ERR";
		} catch (IllegalBlockSizeException e) {
			e.printStackTrace();
			return "DencryptData ERR";
		}

	}

	// byte[] decryptAESStr1 = AESUtil.decryptAES(encryptAESbytes, secretKey);
	// String decryptAESStr = Util.bytesToHexString(decryptAESStr1);
	// ////System.out.println(decryptAESStr);

	/***
	 *
	 *
	 * @param Hexstring
	 * @return {"CodeNumber":"20190008880003","SerialNo":1,"Data":{"Result":"SUCCESS","ChargeMoney":10,"ChargeTimes":23}}
	 */
	public static String ParseData(int Encrytype, String Hexstring) {
		System.out.println("isEncry:" + isEncry + "---Encrytype:" + Encrytype);

		isEncry = Encrytype;
		System.out.println("isEncry:" + isEncry + "---Encrytype:" + Encrytype);
		JSONObject jsonToReturn = new JSONObject();
		String JSONData = "";
		try {
			if (Hexstring.length() <= 34 && (Hexstring.length() % 2 != 0)) {

				JSONData = "{'Result':' LENGTH ERR'}";
				jsonToReturn.put("Data", JSONData);
				return jsonToReturn.toString();
			}
			byte[] ReceivedCMD = Util.toByteArray(Hexstring);
			if (ReceivedCMD.length <= 17) {

				JSONData = "{'Result':'LENGTH ERR'}";
				jsonToReturn.put("Data", JSONData);
				return jsonToReturn.toString();
			}
			if (ReceivedCMD[0] != 0x68 || ReceivedCMD[1] != 0x30 || ReceivedCMD[ReceivedCMD.length - 1] != 0x16) {

				JSONData = "{'Result':'CMD HEAD TAIL ERR'}";
				jsonToReturn.put("Data", JSONData);
				return jsonToReturn.toString();
			}

			System.arraycopy(ReceivedCMD, 2, CMDMeterNO, 0, 7);
			String CodeNumber = Util.bcd2Str(CMDMeterNO);
			String DataToEencryptLength = Hexstring.substring(20, 24);
			System.out.println("DataToEencryptLength:"+DataToEencryptLength);
			int dataLength = Integer.parseInt(DataToEencryptLength, 16);
			System.out.println("dataLength:"+dataLength);
			if (dataLength > 1024) {
				System.out.println("4");
				JSONData = "{'Result':'ERR'}";
				jsonToReturn.put("Data", JSONData);
				return jsonToReturn.toString();
			}
			String DataToDencrypt = Hexstring.substring(24, 24 + dataLength * 2);
			String DataDencrypted = "";
			if (Encrytype == 1) {
				System.out.println("执行AES解密");
				int dataGroupInt = dataLength / 16;
				for (int i = 0; i < dataGroupInt; i++) {
					String DataToDencryptSplit = DataToDencrypt.substring(0 + (32 * i), 0 + (32 * i) + 32);
					DataToDencryptSplit = DencryptData(DataToDencryptSplit);
					if (DataToDencryptSplit == "DencryptData ERR") {
						JSONData = "{'Result':'Decrypt ERR'}";
						jsonToReturn.put("Data", JSONData);
						return jsonToReturn.toString();
					}
					DataDencrypted += DataToDencryptSplit;
				}
			} else {
				System.out.println("不执行AES解密");
				DataDencrypted = DataToDencrypt;
			}
			byte[] NewReceivedCMD = Util.toByteArray(DataDencrypted);
			System.arraycopy(NewReceivedCMD, 0, ReceivedCMD, 12, NewReceivedCMD.length);
			System.arraycopy(ReceivedCMD, 2, CMDMeterNO, 0, 7);
			CodeNumber = Util.bcd2Str(CMDMeterNO);
			byte CMDFLAG[] = new byte[] { ReceivedCMD[12], ReceivedCMD[13] };
			String ControlToPrint = Util.byteToHexString(ReceivedCMD[9]).toUpperCase();
			String CMDFLAGString = Util.bytesToHexString(CMDFLAG).toUpperCase();
			if (ControlToPrint.equals("C1") || ControlToPrint.equals("C4")) {
				CMDFLAGString = "A999";
			}
			int CMDSerialNo = ReceivedCMD[14];
			// ////System.out.println("CMDSerialNo is :" + CMDSerialNo);
			switch (ReceivedCMD[9] + CMDFLAGString) {
			case (byte) 0x81 + Constant.ReportDataFlag:
				//// System.out.println("Start Parse Meter Report Data");
				JSONData = ParseMeterReportDataWithSE(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WritePriceFlag:
				//// System.out.println("Start Parse Price Reply Data");
				JSONData = ParseMeterReplyPriceData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteChargeMoneyFlag:
				//// System.out.println("Start Parse Meter Charge Reply Data");
				JSONData = ParseMeterReplyChargeData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteTimeFlag:
				//// System.out.println("Start Parse Meter WriteTime Reply Data");
				JSONData = ParseMeterReplyWriteTimeData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteValveControlFlag:
				//// System.out.println("Start Parse Meter WriteValveControl Reply Data");
				JSONData = ParseMeterReplyWriteValveControlData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetPriceFlag:
				//// System.out.println("Start Parse Meter WriteSetPrice Reply Data");
				JSONData = ParseMeterReplyWriteSetPriceData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetMeterParamFlag:
				//// System.out.println("Start Parse Meter WriteGetParam Reply Data");
				JSONData = ParseMeterReplyWriteGetParamData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetParamFlag:
				//// System.out.println("Start Parse Meter WriteSetParam Reply Data");
				JSONData = ParseMeterReplyWriteSetParamData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetRecordsFlag:
				//// System.out.println("Start Parse Meter WriteGetRecords Reply Data");
				JSONData = ParseMeterReplyWriteGetRecordsData(ReceivedCMD);
				break;

			case (byte) 0x81 + Constant.WriteGet24HoursRecordsFlag:
				//// System.out.println("Start Parse Meter WriteGet24HoursRecords Reply Data");
				JSONData = ParseMeterReplyWriteGet24HoursRecordsData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetModuleInfoFlag:
				//// System.out.println("Start Parse Meter WriteGetModuleInfo Reply Data");
				JSONData = ParseMeterReplyWriteGetModuleInfoData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetReportTimeOneFlag:
				//// System.out.println("Start Parse Meter WriteGetReportTimeOne Reply Data");
				JSONData = ParseMeterReplyWriteGetReportTimeOneData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetReportIPOneFlag:
				//// System.out.println("Start Parse Meter WriteGetReportIPOne Reply Data");
				JSONData = ParseMeterReplyWriteGetReportIPOneData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetReportTimeTwoFlag:
				//// System.out.println("Start Parse Meter WriteGetReportTimeTwo Reply Data");
				JSONData = ParseMeterReplyWriteGetReportTimeTwosData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetReportIPTwoFlag:
				//// System.out.println("Start Parse Meter WriteGetReportIPTwo Reply Data");
				JSONData = ParseMeterReplyWriteGetReportIPTwoData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetReportTimeThreeFlag:
				//// System.out.println("Start Parse Meter WriteGetReportTimeThree Reply Data");
				JSONData = ParseMeterReplyWriteGetReportTimeThreeData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetReportIPThreeFlag:
				//// System.out.println("Start Parse Meter WriteGetReportIPThree Reply Data");
				JSONData = ParseMeterReplyWriteGetReportIPThreeData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetResetMeterFlag:
				//// System.out.println("Start Parse Meter WriteSetResetMeter Reply Data");
				JSONData = ParseMeterReplyWriteSetResetMeterData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetRepairMeterFlag:
				//// System.out.println("Start Parse Meter WriteSetRepairMeter Reply Data");
				JSONData = ParseMeterReplyWriteSetRepairMeterData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetSafeCheckFlag:
				//// System.out.println("Start Parse Meter WriteSetSafeCheckFlag Reply Data");
				JSONData = ParseMeterReplyWriteSetSafeCheckFlagData(ReceivedCMD);
				break;

			case (byte) 0x84 + Constant.WriteSetReportTimeOneFlag:
				//// System.out.println("Start Parse Meter WriteSetReportTimeOne Reply Data");
				JSONData = ParseMeterReplyWriteSetReportTimeOneData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetReportIPOneFlag:
				//// System.out.println("Start Parse Meter WriteSetReportIPOne Reply Data");
				JSONData = ParseMeterReplyWriteSetReportIPOneData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetReportTimeTwoFlag:
				//// System.out.println("Start Parse Meter WriteSetReportTimeTwo Reply Data");
				JSONData = ParseMeterReplyWriteSetReportTimeTwoData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetReportIPTwoFlag:
				//// System.out.println("Start Parse Meter WriteSetReportIPTwo Reply Data");
				JSONData = ParseMeterReplyWriteSetReportIPTwoData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetReportTimeThreeFlag:
				//// System.out.println("Start Parse Meter WriteSetReportTimeThree Reply Data");
				JSONData = ParseMeterReplyWriteSetReportTimeThreeData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteSetReportIPThreeFlag:
				//// System.out.println("Start Parse Meter WriteSetReportIPThree Reply Data");
				JSONData = ParseMeterReplyWriteSetReportIPThreeData(ReceivedCMD);
				break;

			case (byte) 0x96 + Constant.WriteAccumulatedGasFlag:
				//// System.out.println("Start Parse Meter WriteSetAccumulatedGas Reply Data");
				JSONData = ParseMeterReplyWriteSetAccumulatedGasData(ReceivedCMD);
				break;
			case (byte) 0x95 + Constant.WriteSetMeterNoFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");
				JSONData = ParseMeterReplyWriteSetMeterNoData(ReceivedCMD);
				break;
			case (byte) 0xC1 + Constant.WriteErrFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");
				JSONData = ParseMeterReplyErrData(ReceivedCMD);
				break;
			case (byte) 0xC4 + Constant.WriteErrFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");
				JSONData = ParseMeterReplyErrData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteRequestMCUUpdateFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReplyWriteRequestMCUUpdateata(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteResponseMCUUpdateFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterResponesMCUUpdateData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteReportEndMCUUpdateFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseWriteReportEndMCUUpdateData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteBindCardInfoFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReplyBindCardInfoDataWithSE(ReceivedCMD);
				break;
			case (byte) 0x89 + Constant.WriteRequestSessionKeyFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReplyRequestSessionKeyData(ReceivedCMD);
				break;
			case (byte) 0x89 + Constant.WriteGetRandStrFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReplyGetRandStrData(ReceivedCMD);
				break;
			case (byte) 0x89 + Constant.WriteSetSessionKeyFlag:
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReplySetSessionKeyData(ReceivedCMD);
				break;
			case (byte) 0x84 + Constant.WriteChargeApduFlag: // 解析充值
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReplyChargeData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteRequestExAuth: // 解析充值
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterRequestExAuthData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteSetUpdateCardKey: // 解析充值
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterRequestUpdateCardKeyData(ReceivedCMD);
				break;
			case (byte) 0x81 + Constant.WriteGetMeterPulseInfoFlag: // 解析脉冲
				//// System.out.println("Start Parse Meter WriteSetMeterNo Reply Data");

				JSONData = ParseMeterReportPulseInfoData(ReceivedCMD);
				break;
			default:
				JSONObject jsonDefaultData = new JSONObject();
				jsonDefaultData.put("Type", "ErrData");
				jsonDefaultData.put("Result", "Err");
				JSONData = jsonDefaultData.toString();
				break;
			}
			jsonToReturn.put("Result", JSONObject.fromObject(JSONData).getString("Result"));
			jsonToReturn.put("CodeNumber", CodeNumber);
			jsonToReturn.put("SerialNo", CMDSerialNo);
			jsonToReturn.put("Data", JSONData);

			// {"CodeNumber":"11223344556677"."SerialNo":1,Data:"{"calcuGas":0,"remainMoney":0.5,"price":1,"buytimes":0,"meterState":"0800","batteryState":"6.0","meterTemperature":22.04,"CSQ":18,"signalPower":-850,"SNR":84,"ECL":0,"CellID":151867156,"PCI":369,"EARFCN":3736,"repFlag":"00001000","cmcState":"0000","meterTime":"20190422114421"}"}
			//// System.out.println("Parse End And Return ----------------" +
			// jsonToReturn.toString());
			logger.info(jsonToReturn.toString());
			// System.out.println(jsonToReturn.toString());
			return jsonToReturn.toString();

		} catch (Exception e) {
			// TODO: handle exception
			jsonToReturn.put("Result", "ERR");
			jsonToReturn.put("Detail", e.toString());

			return jsonToReturn.toString();
		}
	}
	// 表端主动发起的请求解析出随机数，seuid

	private static String ParseMeterReportPulseInfoData(byte[] receivedCMD) {
		// TODO Auto-generated method stub

		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReportPulseInfo");
		jsonData.put("Result", "SUCCESS");

		int FinalFlag = receivedCMD[15];
		byte[] pulseDate = new byte[3];
		System.arraycopy(receivedCMD, 16, pulseDate, 0, 3);
		String pulseDateString = Util.bcd2Str(pulseDate);
		// 倒数找到0x80
		JSONArray allPulseData = new JSONArray();
		jsonData.put("FinalFlag", FinalFlag);
		jsonData.put("pulseDate", pulseDateString);
		int endindex = SearchEndFlag(receivedCMD);
		if (endindex == 18) {
			// 说明没有脉冲数据
			jsonData.put("pulseData", "0");
		} else {
			// 截取出具体脉冲数据长度
			byte[] pulseDataBytes = new byte[endindex - 19];
			System.arraycopy(receivedCMD, 19, pulseDataBytes, 0, pulseDataBytes.length);
			String hourStart = ""; // 小时起始
			String minuteStart = ""; // 分钟起始

			String  pulseCount ="";
			for (int i = 0; i < pulseDataBytes.length; i++) {




				if (pulseDataBytes[i] >= 0x80 || (pulseDataBytes[i] & 0xff)>=0x80 ) {
					//若时间 脉冲数据不为空 则存储
					if(hourStart != ""   &&  pulseCount != "" &&! hourStart .equals("")   && ! pulseCount .equals("")  ) {
						JSONObject pulsedata=new JSONObject();
						pulsedata.put("StartTime", hourStart+":"+minuteStart);
						pulsedata.put("PulseData", pulseCount);
						allPulseData.add(pulsedata);
						pulseCount="";
					}
					// 表明为小时起点
					hourStart = Util.byteToHexString((byte) (pulseDataBytes[i] - (byte) 0x80));
					minuteStart = Util.byteToHexString(pulseDataBytes[i + 1]);
					i = i + 2;
				}
				pulseCount+=pulseDataBytes[i]+"|";
				if(i==pulseDataBytes.length-1 ) {

					JSONObject pulsedata=new JSONObject();
					pulsedata.put("StartTime", hourStart+":"+minuteStart);
					pulsedata.put("PulseData", pulseCount);
					allPulseData.add(pulsedata);
					pulseCount="";
				}
//				if(pulseDataBytes.length==3 ) {
//
//					JSONObject pulsedata=new JSONObject();
//					pulsedata.put("StartTime", hourStart+":"+minuteStart);
//					pulsedata.put("PulseData", pulseCount);
//					allPulseData.add(pulsedata);
//					pulseCount="";
//				}
//
			}




			jsonData.put("pulseData", allPulseData.toString());

		}

		return jsonData.toString();
	}

	public static int SearchEndFlag(byte[] receivedCMD) {
		// TODO Auto-generated method stub
		int endindex = receivedCMD.length - 1;
		for (int i = endindex; i < receivedCMD.length; i--) {
			if (receivedCMD[i] == (byte) 0x80) {
				endindex = i;
				break;
			}
		}
		return endindex;
	}

	private static String ParseMeterRequestUpdateCardKeyData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterRequestUpdateCardKey");
		jsonData.put("Result", "SUCCESS");

		// SEID
		byte[] seuidtemp = new byte[8];
		System.arraycopy(receivedCMD, 15, seuidtemp, 0, 8);
		String SEUID = Util.bytesToHexString(seuidtemp);
		// KeyType
		int keyType = receivedCMD[23];

		byte[] randstrtemp = new byte[8];
		System.arraycopy(receivedCMD, 24, randstrtemp, 0, 8);
		String RandStr = Util.bytesToHexString(randstrtemp);

		jsonData.put("SEUID", SEUID);
		jsonData.put("KeyType", keyType);
		jsonData.put("RandStr", RandStr);

		// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	private static String ParseMeterRequestExAuthData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterRequestExAuth");
		jsonData.put("Result", "SUCCESS");

		// SEID
		byte[] seuidtemp = new byte[8];
		System.arraycopy(receivedCMD, 15, seuidtemp, 0, 8);
		String SEUID = Util.bytesToHexString(seuidtemp);
		// KeyType
		int keyType = receivedCMD[23];

		byte[] randstrtemp = new byte[8];
		System.arraycopy(receivedCMD, 24, randstrtemp, 0, 8);
		String RandStr = Util.bytesToHexString(randstrtemp);

		jsonData.put("SEUID", SEUID);
		jsonData.put("KeyType", keyType);
		jsonData.put("RandStr", RandStr);

		// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	private static String ParseMeterReplyGetRandStrData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyGetRandStr");
		jsonData.put("Result", "SUCCESS");

		// SEID
		byte[] seuidtemp = new byte[8];
		System.arraycopy(receivedCMD, 15, seuidtemp, 0, 8);
		String SEUID = Util.bytesToHexString(seuidtemp);
		// SESM2
		jsonData.put("RandStr", SEUID);

		// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	// 解析表返回的 协商密钥结果 0x00为成功
	private static String ParseMeterReplySetSessionKeyData(byte[] receivedCMD) {
		// TODO Auto-generated method stub

		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplySetSessionKey");
		if (receivedCMD[15] == 0x00) {
			jsonData.put("Result", "SUCCESS");
		} else {

			jsonData.put("Result", "FAIL");
		}
		return jsonData.toString();

	}

	// 解密表回复的 密钥等参数
	private static String ParseMeterReplyRequestSessionKeyData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyRequestSessionKey");
		jsonData.put("Result", "SUCCESS");

		// SEID
		byte[] seuidtemp = new byte[8];
		System.arraycopy(receivedCMD, 15, seuidtemp, 0, 8);
		String SEUID = Util.bytesToHexString(seuidtemp);
		// SESM2
		byte[] SESM2KeyTemp = new byte[64];
		System.arraycopy(receivedCMD, 23, SESM2KeyTemp, 0, 64);
		String SESM2Key = Util.bytesToHexString(SESM2KeyTemp);
		// SETempSM2
		byte[] setempSm2Keytemp = new byte[64];
		System.arraycopy(receivedCMD, 87, setempSm2Keytemp, 0, 64);
		String SEtempSm2Key = Util.bytesToHexString(setempSm2Keytemp);
		// SERand
		byte[] randstrtemp = new byte[8];
		System.arraycopy(receivedCMD, 151, randstrtemp, 0, 8);
		String RandStr = Util.bytesToHexString(randstrtemp);

		jsonData.put("SEUID", SEUID);
		jsonData.put("SESM2Key", SESM2Key);
		jsonData.put("SEtempSm2Key", SEtempSm2Key);
		jsonData.put("RandStr", RandStr);

		// System.out.println(jsonData.toString());
		return jsonData.toString();

	}

	private static String ParseMeterReplyWriteRequestMCUUpdateata(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "WriteReportEndMCUUpdate");
		jsonData.put("Result", "SUCCESS");
		byte updateState = receivedCMD[15];
		String updateStateStr = Util.byteToHexString(updateState);
		jsonData.put("ErrCodeNo", updateStateStr);

		// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	// private static void ToEncrptJar(byte[] receivedCMD) {
	// System.out.println("test");
	// }
	private static String ParseWriteReportEndMCUUpdateData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "WriteReportEndMCUUpdate");
		jsonData.put("Result", "SUCCESS");
		byte[] versionCode = new byte[4];
		System.arraycopy(receivedCMD, 15, versionCode, 0, 4);
		String meterState = Util.bytesToHexString(versionCode);
		jsonData.put("versionCode", meterState);
		byte updateState = receivedCMD[19];
		String updateStateStr = Util.byteToHexString(updateState);
		jsonData.put("updateState", updateStateStr);

		// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	private static String ParseMeterReplyBindCardInfoData(byte[] ReceivedCMD) {

		String reportDataVersionCode = Util.byteToHexString(ReceivedCMD[15]);

		byte[] newRepFlag = new byte[2];
		System.arraycopy(ReceivedCMD, 16, newRepFlag, 0, 2);
		String newRepFlagString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(newRepFlag).toUpperCase(), 16));
		// System.out.println("newRepFlag-----------" + newRepFlagString);
		String pattern = "0000000000000000";
		newRepFlagString = pattern.substring(0, pattern.length() - newRepFlagString.length()) + newRepFlagString;

		char RepFlagbyte[] = newRepFlagString.toCharArray();
		JSONObject RepFlagObj = new JSONObject();

		RepFlagObj.put("reportByDeathMeterTwo", RepFlagbyte[4]);
		RepFlagObj.put("reportByDeathMeterOne", RepFlagbyte[5]);
		RepFlagObj.put("reportByMagneticPro", RepFlagbyte[7]);
		RepFlagObj.put("reportByReset", RepFlagbyte[8]);
		RepFlagObj.put("reportByLowPower", RepFlagbyte[10]);

		RepFlagObj.put("reportByLostPower", RepFlagbyte[11]);
		RepFlagObj.put("reportByKey2", RepFlagbyte[12]);
		RepFlagObj.put("reportByKey1", RepFlagbyte[13]);

		RepFlagObj.put("reportByTime", RepFlagbyte[15]);

		byte[] cmc = new byte[2];
		System.arraycopy(ReceivedCMD, 18, cmc, 0, 2);
		String cmcString = Util.bytesToHexString(cmc);

		byte[] mcuVersionCode = new byte[4];
		System.arraycopy(ReceivedCMD, 20, mcuVersionCode, 0, 4);
		String mcuVersionCodeString = Util.bcd2Str(mcuVersionCode);

		// 表类型 2019-09-24更新 两字节
		byte[] meterType = new byte[2];
		System.arraycopy(ReceivedCMD, 24, meterType, 0, 2);
		String meterTypeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterType).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterTypeString = pattern.substring(0, pattern.length() - meterTypeString.length()) + meterTypeString;
		System.out.println(meterTypeString);
		String meterTypeOne = meterTypeString.substring(0, 4);
		String meterTypeTwo = meterTypeString.substring(4, 8);
		String meterTypeThree = meterTypeString.substring(8, 12);
		String meterTypeFour = meterTypeString.substring(12);
		String meterTypeFinal = Integer.valueOf(meterTypeOne, 2) + "" + Integer.valueOf(meterTypeTwo, 2)
				+ Integer.valueOf(meterTypeThree, 2) + Integer.valueOf(meterTypeFour, 2);
		byte[] calcuGastem = new byte[4];
		System.arraycopy(ReceivedCMD, 26, calcuGastem, 0, 4);
		int calcuGasInt = Util.byteArrayToInt(calcuGastem);
		int calcuGasDouble = ReceivedCMD[30];
		// ////System.out.println("calcuGas:" + calcuGasInt + "." + calcuGasDouble);
		double calcuGas = calcuGasInt + (double) calcuGasDouble / 100;

		byte[] remainMoneytem = new byte[4];
		System.arraycopy(ReceivedCMD, 31, remainMoneytem, 1, 3);
		int remainMoneyInt = Util.byteArrayToInt(remainMoneytem);
		int remainMoneyDouble = ReceivedCMD[34];
		// ////System.out.println("remainMoney:" + remainMoneyInt + "." +
		// remainMoneyDouble);
		double remainMoney = remainMoneyInt + (double) remainMoneyDouble / 100;

		int priceInt = ReceivedCMD[35];
		int priceDouble = ReceivedCMD[36];
		// ////System.out.println("price:" + priceInt + "." + priceDouble);
		double price = priceInt + (double) priceDouble / 100;

		byte[] buytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, 37, buytimestem, 2, 2);
		int buytimesint = Util.byteArrayToInt(buytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int buytimes = buytimesint;

		byte[] cardbuytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, 39, cardbuytimestem, 2, 2);
		int cardbuytimesint = Util.byteArrayToInt(cardbuytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int cardbuytimes = cardbuytimesint;

		byte[] meterStatetem = new byte[2];
		System.arraycopy(ReceivedCMD, 41, meterStatetem, 0, 2);
		String meterStateString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterStatetem).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterStateString = pattern.substring(0, pattern.length() - meterStateString.length()) + meterStateString;
		// meterStateString = String.format("%016d",
		// (Integer.parseInt(meterStateString)));
		char meterStatebyte[] = meterStateString.toCharArray();
		JSONObject meterStateObj = new JSONObject();
		meterStateObj.put("DethMeterOneFlag", meterStatebyte[15]);
		meterStateObj.put("DethMeterTwoFlag", meterStatebyte[14]);
		meterStateObj.put("MagneticFlag", meterStatebyte[13]);
		meterStateObj.put("ForceSafeCheckFlag", meterStatebyte[12]);
		meterStateObj.put("ForceSraptFlag", meterStatebyte[11]);
		meterStateObj.put("ValveState", meterStatebyte[10]);
		meterStateObj.put("OverFlowFlag", meterStatebyte[9]);
		meterStateObj.put("OutBatteryLowPowerFlag", meterStatebyte[8]);
		meterStateObj.put("OutBatteryLosePowerFlag", meterStatebyte[7]);
		meterStateObj.put("InnerBatteryLowPowerFlag", meterStatebyte[6]);
		meterStateObj.put("TimeErrFlag", meterStatebyte[5]);

		meterStateObj.put("LackOfGasFlag", meterStatebyte[4]);
		meterStateObj.put("AlarmAndCloseValve", meterStatebyte[3]);
		meterStateObj.put("ForceSafeCheckAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("ForceScraptAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("WireCloseValveState", meterStatebyte[1]);

		String batteryState = "";
		byte batteryStatetem = ReceivedCMD[43];
		double batteryStateDouble = 0d;
		if (batteryStatetem < 100) {
			batteryStateDouble = batteryStatetem / 10;
			batteryState = batteryStateDouble + "";
		} else {
			int v = batteryStatetem & 0xFF;
			batteryState = Integer.toHexString(v).toUpperCase();
			if (batteryState.equals("80")) {
				// ////System.out.println("batteryState:" + batteryStatetem + "-Normal");
			} else if (batteryState == "90") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LowPower");
			} else if (batteryState == "A0") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LostPower");
			}
		}

		// int tempint = ReceivedCMD[30];
		int tempdouble = ReceivedCMD[45];
		byte tempbytes[] = new byte[] { ReceivedCMD[44] };
		String tempintString = Util.bytesToHexString(tempbytes);
		int tempint = (short) (Integer.valueOf(tempintString, 16) & 0xff);
		if (tempint < 0) {
			tempint = tempint + 1;
		}
		// ////System.out.println("meterTem:" + tempint + "." + tempdouble);
		double meterTemperature = tempint + (double) tempdouble / 100;

		int CSQ = ReceivedCMD[46];
		// ////System.out.println("CSQ:" + CSQ);

		byte[] signalPower = new byte[2];
		System.arraycopy(ReceivedCMD, 47, signalPower, 0, 2);

		String signalPowerString = Util.bytesToHexString(signalPower);
		int signalPowerInt = (short) (Integer.valueOf(signalPowerString, 16) & 0xffff);
		if (signalPowerInt < 0)
			signalPowerInt = signalPowerInt + 1;
		// ////System.out.println("signalPower:" + signalPowerInt);
		// SNR
		byte[] SNR = new byte[2];
		System.arraycopy(ReceivedCMD, 49, SNR, 0, 2);

		String SNRString = Util.bytesToHexString(SNR);
		int SNRshort = (short) (Integer.valueOf(SNRString, 16) & 0xffff);
		if (SNRshort < 0)
			SNRshort = SNRshort + 1;
		// ////System.out.println("SNR:" + SNRshort);
		// ECL
		int ECL = ReceivedCMD[49];
		// ////System.out.println("ECL:" + ECL);
		// Cell ID
		byte[] CellID = new byte[4];

		System.arraycopy(ReceivedCMD, 52, CellID, 0, 4);
		int CellIDint = Util.byteArrayToInt(CellID);
		// ////System.out.println("CellID:" + CellIDint);
		// PCI
		byte[] PCI = new byte[4];
		System.arraycopy(ReceivedCMD, 56, PCI, 2, 2);
		int PCIint = Util.byteArrayToInt(PCI);
		// ////System.out.println("PCI:" + PCIint);
		// EARFCN
		byte[] EARFCN = new byte[4];
		System.arraycopy(ReceivedCMD, 58, EARFCN, 0, 4);
		int EARFCNint = Util.byteArrayToInt(EARFCN);

		byte[] meterTime = new byte[7];
		System.arraycopy(ReceivedCMD, 62, meterTime, 0, 7);
		String meterTimeString = Util.bcd2Str(meterTime);

		String MeterOpenAccountState = Util.byteToHexString(ReceivedCMD[69]);
		byte[] userCardNo = new byte[5];
		System.arraycopy(ReceivedCMD, 70, userCardNo, 0, 5);
		String userCardNoString = Util.bcd2Str(userCardNo);

		String moduleType = "";
		int realLength = 0;
		byte[] moduleTypeTmp = new byte[25];
		System.arraycopy(ReceivedCMD, 75, moduleTypeTmp, 0, 25);
		for (int i = 0; i < moduleTypeTmp.length; i++) {
			if (moduleTypeTmp[i] != 0x00) {
				realLength++;
			}
		}
		byte[] moduleTypeTmp2 = new byte[realLength];
		System.arraycopy(moduleTypeTmp, 0, moduleTypeTmp2, 0, realLength);
		moduleType = Util.hexToAscii(Util.bytesToHexString(moduleTypeTmp2));

		realLength = 0;
		String moduleVersionType = "";
		byte[] moduleVersionTypeTmp = new byte[25];

		System.arraycopy(ReceivedCMD, 100, moduleVersionTypeTmp, 0, 25);

		for (int i = 0; i < moduleVersionTypeTmp.length; i++) {
			if (moduleVersionTypeTmp[i] != 0x00) {
				realLength++;
			}
		}
		byte[] moduleVersionTypeTmp2 = new byte[realLength];
		System.arraycopy(moduleVersionTypeTmp, 0, moduleVersionTypeTmp2, 0, realLength);
		moduleVersionType = Util.hexToAscii(Util.bytesToHexString(moduleVersionTypeTmp2));

		String moduleIMEI = "";
		byte[] moduleIMEITmp = new byte[15];
		System.arraycopy(ReceivedCMD, 125, moduleIMEITmp, 0, 15);
		moduleIMEI = Util.hexToAscii(Util.bytesToHexString(moduleIMEITmp));

		String cardIMSI = "";
		byte[] cardIMSITmp = new byte[15];
		System.arraycopy(ReceivedCMD, 140, cardIMSITmp, 0, 15);
		cardIMSI = Util.hexToAscii(Util.bytesToHexString(cardIMSITmp));

		String cardICCID = "";
		byte[] cardICCIDTmp = new byte[20];
		System.arraycopy(ReceivedCMD, 155, cardICCIDTmp, 0, 20);
		cardICCID = Util.hexToAscii(Util.bytesToHexString(cardICCIDTmp));

		// ////System.out.println("meterTime:" + meterTimeString);
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterBindCard");
		jsonData.put("Result", "SUCCESS");
		jsonData.put("MeterOpenAccountState", MeterOpenAccountState);
		jsonData.put("userCardNoString", userCardNoString);
		jsonData.put("moduleType", moduleType);
		jsonData.put("moduleVersionType", moduleVersionType);
		jsonData.put("moduleIMEI", moduleIMEI);
		jsonData.put("cardIMSI", cardIMSI);
		jsonData.put("cardICCID", cardICCID);
		jsonData.put("meterType", meterTypeFinal);
		jsonData.put("cardbuytimes", cardbuytimes);
		jsonData.put("reportDataVersionCode", reportDataVersionCode);
		jsonData.put("mcuVersionCodeString", mcuVersionCodeString);
		jsonData.put("cardbuytimes", cardbuytimes);
		jsonData.put("calcuGas", calcuGas);
		jsonData.put("remainMoney", remainMoney);
		jsonData.put("price", price);
		jsonData.put("buytimes", buytimes);
		jsonData.put("meterState", meterStateObj);
		jsonData.put("batteryState", batteryState);
		jsonData.put("meterTemperature", meterTemperature);
		jsonData.put("CSQ", CSQ);
		jsonData.put("signalPower", signalPowerInt);
		jsonData.put("SNR", SNRshort);
		jsonData.put("ECL", ECL);
		jsonData.put("CellID", CellIDint);
		jsonData.put("PCI", PCIint);
		jsonData.put("EARFCN", EARFCNint);
		jsonData.put("repFlag", RepFlagObj.toString());
		jsonData.put("cmcState", cmcString);
		jsonData.put("meterTime", meterTimeString);
		System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	private static String ParseMeterReplyBindCardInfoDataWithSE(byte[] ReceivedCMD) {

		JSONObject jsonData = new JSONObject();

		int startindex = 15;

		String reportDataVersionCode = Util.byteToHexString(ReceivedCMD[startindex]);
		String randStr = "";
		if (reportDataVersionCode == "01" || reportDataVersionCode.equals("01")) {
			byte[] randStrtmp = new byte[8];
			System.arraycopy(ReceivedCMD, startindex + 1, randStrtmp, 0, 8);
			randStr = Util.bytesToHexString(randStrtmp);
			jsonData.put("randStr", randStr);
			startindex = startindex + 8;
		}

		byte[] newRepFlag = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 1, newRepFlag, 0, 2);
		String newRepFlagString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(newRepFlag).toUpperCase(), 16));
		// System.out.println("newRepFlag-----------" + newRepFlagString);
		String pattern = "0000000000000000";
		newRepFlagString = pattern.substring(0, pattern.length() - newRepFlagString.length()) + newRepFlagString;

		char RepFlagbyte[] = newRepFlagString.toCharArray();
		JSONObject RepFlagObj = new JSONObject();

		RepFlagObj.put("reportByDeathMeterTwo", RepFlagbyte[4]);
		RepFlagObj.put("reportByDeathMeterOne", RepFlagbyte[5]);
		RepFlagObj.put("reportByMagneticPro", RepFlagbyte[7]);
		RepFlagObj.put("reportByReset", RepFlagbyte[8]);
		RepFlagObj.put("reportByLowPower", RepFlagbyte[10]);

		RepFlagObj.put("reportByLostPower", RepFlagbyte[11]);
		RepFlagObj.put("reportByKey2", RepFlagbyte[12]);
		RepFlagObj.put("reportByKey1", RepFlagbyte[13]);

		RepFlagObj.put("reportByTime", RepFlagbyte[15]);

		byte[] cmc = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 3, cmc, 0, 2);
		String cmcString = Util.bytesToHexString(cmc);

		byte[] mcuVersionCode = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 5, mcuVersionCode, 0, 4);
		String mcuVersionCodeString = Util.bcd2Str(mcuVersionCode);

		// 表类型 2019-09-24更新 两字节
		byte[] meterType = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 9, meterType, 0, 2);
		String meterTypeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterType).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterTypeString = pattern.substring(0, pattern.length() - meterTypeString.length()) + meterTypeString;
		System.out.println(meterTypeString);
		String meterTypeOne = meterTypeString.substring(0, 4);
		String meterTypeTwo = meterTypeString.substring(4, 8);
		String meterTypeThree = meterTypeString.substring(8, 12);
		String meterTypeFour = meterTypeString.substring(12);
		String meterTypeFinal = Integer.valueOf(meterTypeOne, 2) + "" + Integer.valueOf(meterTypeTwo, 2)
				+ Integer.valueOf(meterTypeThree, 2) + Integer.valueOf(meterTypeFour, 2);
		byte[] calcuGastem = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 11, calcuGastem, 0, 4);
		int calcuGasInt = Util.byteArrayToInt(calcuGastem);
		int calcuGasDouble = ReceivedCMD[startindex + 15];
		// ////System.out.println("calcuGas:" + calcuGasInt + "." + calcuGasDouble);
		double calcuGas = calcuGasInt + (double) calcuGasDouble / 100;

		byte[] remainMoneytem = new byte[3];
		System.arraycopy(ReceivedCMD, startindex + 16, remainMoneytem, 0, 3);

		String moneyIntString = Util.bytesToHexString(remainMoneytem);
		int moneyInt = (short) (Integer.valueOf(moneyIntString, 16) & 0xffffff);
		if (moneyInt < 0) {
			moneyInt = moneyInt + 1;
		}
		int remainMoneyDouble = ReceivedCMD[startindex + 19];
		double remainMoney = 0;
		if (moneyInt < 0) {

			remainMoney = moneyInt - (double) remainMoneyDouble / 100;
		} else {
			remainMoney = moneyInt + (double) remainMoneyDouble / 100;
		}

		int priceInt = ReceivedCMD[startindex + 20];
		int priceDouble = ReceivedCMD[startindex + 21];
		// ////System.out.println("price:" + priceInt + "." + priceDouble);
		double price = priceInt + (double) priceDouble / 100;

		byte[] buytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 22, buytimestem, 2, 2);
		int buytimesint = Util.byteArrayToInt(buytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int buytimes = buytimesint;

		byte[] cardbuytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 24, cardbuytimestem, 2, 2);
		int cardbuytimesint = Util.byteArrayToInt(cardbuytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int cardbuytimes = cardbuytimesint;

		byte[] meterStatetem = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 26, meterStatetem, 0, 2);
		String meterStateString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterStatetem).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterStateString = pattern.substring(0, pattern.length() - meterStateString.length()) + meterStateString;
		// meterStateString = String.format("%016d",
		// (Integer.parseInt(meterStateString)));
		char meterStatebyte[] = meterStateString.toCharArray();
		JSONObject meterStateObj = new JSONObject();
		meterStateObj.put("DethMeterOneFlag", meterStatebyte[15]);
		meterStateObj.put("DethMeterTwoFlag", meterStatebyte[14]);
		meterStateObj.put("MagneticFlag", meterStatebyte[13]);
		meterStateObj.put("ForceSafeCheckFlag", meterStatebyte[12]);
		meterStateObj.put("ForceSraptFlag", meterStatebyte[11]);
		meterStateObj.put("ValveState", meterStatebyte[10]);
		meterStateObj.put("OverFlowFlag", meterStatebyte[9]);
		meterStateObj.put("OutBatteryLowPowerFlag", meterStatebyte[8]);
		meterStateObj.put("OutBatteryLosePowerFlag", meterStatebyte[7]);
		meterStateObj.put("InnerBatteryLowPowerFlag", meterStatebyte[6]);
		meterStateObj.put("TimeErrFlag", meterStatebyte[5]);

		meterStateObj.put("LackOfGasFlag", meterStatebyte[4]);
		meterStateObj.put("AlarmAndCloseValve", meterStatebyte[3]);
		meterStateObj.put("ForceSafeCheckAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("ForceScraptAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("WireCloseValveState", meterStatebyte[1]);

		String batteryState = "";
		byte batteryStatetem = ReceivedCMD[startindex + 28];
		double batteryStateDouble = 0d;
		if (batteryStatetem < 100) {
			batteryStateDouble = batteryStatetem / 10;
			batteryState = batteryStateDouble + "";
		} else {
			int v = batteryStatetem & 0xFF;
			batteryState = Integer.toHexString(v).toUpperCase();
			if (batteryState.equals("80")) {
				// ////System.out.println("batteryState:" + batteryStatetem + "-Normal");
			} else if (batteryState == "90") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LowPower");
			} else if (batteryState == "A0") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LostPower");
			}
		}

		// int tempint = ReceivedCMD[30];
		int tempdouble = ReceivedCMD[startindex + 30];
		byte tempbytes[] = new byte[] { ReceivedCMD[startindex + 29] };
		String tempintString = Util.bytesToHexString(tempbytes);
		int tempint = (short) (Integer.valueOf(tempintString, 16) & 0xff);
		if (tempint < 0) {
			tempint = tempint + 1;
		}
		// ////System.out.println("meterTem:" + tempint + "." + tempdouble);
		double meterTemperature = tempint + (double) tempdouble / 100;

		int CSQ = ReceivedCMD[startindex + 31];
		// ////System.out.println("CSQ:" + CSQ);

		byte[] signalPower = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 32, signalPower, 0, 2);

		String signalPowerString = Util.bytesToHexString(signalPower);
		int signalPowerInt = (short) (Integer.valueOf(signalPowerString, 16) & 0xffff);
		if (signalPowerInt < 0)
			signalPowerInt = signalPowerInt + 1;
		// ////System.out.println("signalPower:" + signalPowerInt);
		// SNR
		byte[] SNR = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 34, SNR, 0, 2);

		String SNRString = Util.bytesToHexString(SNR);
		int SNRshort = (short) (Integer.valueOf(SNRString, 16) & 0xffff);
		if (SNRshort < 0)
			SNRshort = SNRshort + 1;
		// ////System.out.println("SNR:" + SNRshort);
		// ECL
		int ECL = ReceivedCMD[startindex + 34];
		// ////System.out.println("ECL:" + ECL);
		// Cell ID
		byte[] CellID = new byte[4];

		System.arraycopy(ReceivedCMD, startindex + 37, CellID, 0, 4);
		int CellIDint = Util.byteArrayToInt(CellID);
		// ////System.out.println("CellID:" + CellIDint);
		// PCI
		byte[] PCI = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 41, PCI, 2, 2);
		int PCIint = Util.byteArrayToInt(PCI);
		// ////System.out.println("PCI:" + PCIint);
		// EARFCN
		byte[] EARFCN = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 43, EARFCN, 0, 4);
		int EARFCNint = Util.byteArrayToInt(EARFCN);

		byte[] meterTime = new byte[7];
		System.arraycopy(ReceivedCMD, startindex + 47, meterTime, 0, 7);
		String meterTimeString = Util.bcd2Str(meterTime);

		String MeterOpenAccountState = Util.byteToHexString(ReceivedCMD[69]);
		byte[] userCardNo = new byte[5];
		System.arraycopy(ReceivedCMD, startindex + 55, userCardNo, 0, 5);
		String userCardNoString = Util.bcd2Str(userCardNo);

		String moduleType = "";
		int realLength = 0;
		byte[] moduleTypeTmp = new byte[25];
		System.arraycopy(ReceivedCMD, startindex + 60, moduleTypeTmp, 0, 25);
		for (int i = 0; i < moduleTypeTmp.length; i++) {
			if (moduleTypeTmp[i] != 0x00) {
				realLength++;
			}
		}
		byte[] moduleTypeTmp2 = new byte[realLength];
		System.arraycopy(moduleTypeTmp, 0, moduleTypeTmp2, 0, realLength);
		moduleType = Util.hexToAscii(Util.bytesToHexString(moduleTypeTmp2));

		realLength = 0;
		String moduleVersionType = "";
		byte[] moduleVersionTypeTmp = new byte[25];

		System.arraycopy(ReceivedCMD, startindex + 85, moduleVersionTypeTmp, 0, 25);

		for (int i = 0; i < moduleVersionTypeTmp.length; i++) {
			if (moduleVersionTypeTmp[i] != 0x00) {
				realLength++;
			}
		}
		byte[] moduleVersionTypeTmp2 = new byte[realLength];
		System.arraycopy(moduleVersionTypeTmp, 0, moduleVersionTypeTmp2, 0, realLength);
		moduleVersionType = Util.hexToAscii(Util.bytesToHexString(moduleVersionTypeTmp2));

		String moduleIMEI = "";
		byte[] moduleIMEITmp = new byte[15];
		System.arraycopy(ReceivedCMD, startindex + 115, moduleIMEITmp, 0, 15);
		moduleIMEI = Util.hexToAscii(Util.bytesToHexString(moduleIMEITmp));

		String cardIMSI = "";
		byte[] cardIMSITmp = new byte[15];
		System.arraycopy(ReceivedCMD, startindex + 125, cardIMSITmp, 0, 15);
		cardIMSI = Util.hexToAscii(Util.bytesToHexString(cardIMSITmp));

		String cardICCID = "";
		byte[] cardICCIDTmp = new byte[20];
		System.arraycopy(ReceivedCMD, startindex + 140, cardICCIDTmp, 0, 20);
		cardICCID = Util.hexToAscii(Util.bytesToHexString(cardICCIDTmp));

		// ////System.out.println("meterTime:" + meterTimeString);
		// JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterBindCard");
		jsonData.put("Result", "SUCCESS");
		jsonData.put("MeterOpenAccountState", MeterOpenAccountState);
		jsonData.put("userCardNoString", userCardNoString);
		jsonData.put("moduleType", moduleType);
		jsonData.put("moduleVersionType", moduleVersionType);
		jsonData.put("moduleIMEI", moduleIMEI);
		jsonData.put("cardIMSI", cardIMSI);
		jsonData.put("cardICCID", cardICCID);
		jsonData.put("meterType", meterTypeFinal);
		jsonData.put("cardbuytimes", cardbuytimes);
		jsonData.put("reportDataVersionCode", reportDataVersionCode);
		jsonData.put("mcuVersionCodeString", mcuVersionCodeString);
		jsonData.put("cardbuytimes", cardbuytimes);
		jsonData.put("calcuGas", calcuGas);
		jsonData.put("remainMoney", remainMoney);
		jsonData.put("price", price);
		jsonData.put("buytimes", buytimes);
		jsonData.put("meterState", meterStateObj);
		jsonData.put("batteryState", batteryState);
		jsonData.put("meterTemperature", meterTemperature);
		jsonData.put("CSQ", CSQ);
		jsonData.put("signalPower", signalPowerInt);
		jsonData.put("SNR", SNRshort);
		jsonData.put("ECL", ECL);
		jsonData.put("CellID", CellIDint);
		jsonData.put("PCI", PCIint);
		jsonData.put("EARFCN", EARFCNint);
		jsonData.put("repFlag", RepFlagObj.toString());
		jsonData.put("cmcState", cmcString);
		jsonData.put("meterTime", meterTimeString);
		System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	private static String ParseMeterResponesMCUUpdateData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "ResponesMCUUpdateData");
		jsonData.put("Result", "SUCCESS");
		byte[] versionCode = new byte[4];
		System.arraycopy(receivedCMD, 15, versionCode, 0, 4);
		String meterState = Util.bytesToHexString(versionCode);
		jsonData.put("versionCode", meterState);
		byte[] frameIndextmp = new byte[4];
		System.arraycopy(receivedCMD, 19, frameIndextmp, 2, 2);
		int frameIndex = Util.byteArrayToInt(frameIndextmp);
		jsonData.put("frameIndex", frameIndex);
		// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetMeterNoData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetMeterNo");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetAccumulatedGasData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetAccumulatedGasData");
		jsonData.put("Result", "SUCCESS");
		byte[] meterStatetem = new byte[2];
		System.arraycopy(receivedCMD, 15, meterStatetem, 0, 2);
		String meterState = Util.bytesToHexString(meterStatetem);
		jsonData.put("meterState", meterState);
		return jsonData.toString();
	}

	private static String ParseMeterReplyErrData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyErrData");
		jsonData.put("Result", "SUCCESS");
		byte[] meterStatetem = new byte[2];
		System.arraycopy(receivedCMD, 15, meterStatetem, 0, 2);
		String meterState = Util.bytesToHexString(meterStatetem);
		jsonData.put("meterState", meterState);
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetReportIPThreeData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetReportIPThree");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetReportTimeThreeData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetReportTimeThree");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetReportIPTwoData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetReportIPTwo");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetReportTimeTwoData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetReportTimeTwo");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetReportIPOneData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetReportIPOne");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetReportTimeOneData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetReportTimeOne");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetSafeCheckFlagData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetSafeCheck");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetRepairMeterData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetRepairMeter");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteSetResetMeterData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetResetMeter");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteGetReportIPThreeData(byte[] receivedCMD) {
		String reportIP = Integer.parseInt(Util.byteToHexString(receivedCMD[15]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[16]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[17]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[18]).toUpperCase(), 16);
		byte reportPortTmp[] = new byte[4];
		System.arraycopy(receivedCMD, 19, reportPortTmp, 2, 2);
		String reportPort = Util.byteArrayToInt(reportPortTmp) + "";
		JSONObject reportIPOne = new JSONObject();
		reportIPOne.put("Type", "MeterReplyWriteGetReportIPThree");
		reportIPOne.put("Result", "SUCCESS");
		reportIPOne.put("reportIP", reportIP);
		reportIPOne.put("reportPort", reportPort);
		return reportIPOne.toString();
	}

	private static String ParseMeterReplyWriteGetReportTimeThreeData(byte[] receivedCMD) {
		int reportType = 0; //
		byte reportTimeTmp[] = new byte[] { receivedCMD[15] };
		String reportTimeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(reportTimeTmp).toUpperCase(), 16));
		reportTimeString = String.format("%08d", (Integer.parseInt(reportTimeString)));
		//// System.out.println(reportTimeString);
		if (reportTimeString.substring(0, 3).equals("110")) {
			reportType = 1;
		} else if (reportTimeString.substring(0, 3).equals("100")) {
			reportType = 0;
		}
		int reportTime = Util.convertToDecimal(reportTimeString.substring(3));

		int reportSpace = receivedCMD[16];
		JSONObject reportTimeOne = new JSONObject();
		reportTimeOne.put("Type", "MeterReplyWriteGetReportTimThree");
		reportTimeOne.put("Result", "SUCCESS");
		reportTimeOne.put("reportType", reportType);
		reportTimeOne.put("reportTime", reportTime);
		reportTimeOne.put("reportSpace", reportSpace);
		return reportTimeOne.toString();
	}

	private static String ParseMeterReplyWriteGetReportIPTwoData(byte[] receivedCMD) {
		String reportIP = Integer.parseInt(Util.byteToHexString(receivedCMD[15]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[16]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[17]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[18]).toUpperCase(), 16);
		byte reportPortTmp[] = new byte[4];
		System.arraycopy(receivedCMD, 19, reportPortTmp, 2, 2);
		String reportPort = Util.byteArrayToInt(reportPortTmp) + "";
		JSONObject reportIPOne = new JSONObject();
		reportIPOne.put("Type", "MeterReplyWriteGetReportIPTwo");
		reportIPOne.put("Result", "SUCCESS");
		reportIPOne.put("reportIP", reportIP);
		reportIPOne.put("reportPort", reportPort);
		return reportIPOne.toString();
	}

	private static String ParseMeterReplyWriteGetReportTimeTwosData(byte[] receivedCMD) {
		int reportType = 0; //
		byte reportTimeTmp[] = new byte[] { receivedCMD[15] };
		String reportTimeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(reportTimeTmp).toUpperCase(), 16));
		reportTimeString = String.format("%08d", (Integer.parseInt(reportTimeString)));
		//// System.out.println(reportTimeString);
		if (reportTimeString.substring(0, 3).equals("110")) {
			reportType = 1;
		} else if (reportTimeString.substring(0, 3).equals("100")) {
			reportType = 0;
		}
		int reportTime = Util.convertToDecimal(reportTimeString.substring(3));

		int reportSpace = receivedCMD[16];
		JSONObject reportTimeOne = new JSONObject();
		reportTimeOne.put("Type", "MeterReplyWriteGetReportTimeTwo");
		reportTimeOne.put("Result", "SUCCESS");
		reportTimeOne.put("reportType", reportType);
		reportTimeOne.put("reportTime", reportTime);
		reportTimeOne.put("reportSpace", reportSpace);
		return reportTimeOne.toString();
	}

	private static String ParseMeterReplyWriteGetReportIPOneData(byte[] receivedCMD) {
		String reportIP = Integer.parseInt(Util.byteToHexString(receivedCMD[15]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[16]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[17]).toUpperCase(), 16) + "."
				+ Integer.parseInt(Util.byteToHexString(receivedCMD[18]).toUpperCase(), 16);
		byte reportPortTmp[] = new byte[4];
		System.arraycopy(receivedCMD, 19, reportPortTmp, 2, 2);
		String reportPort = Util.byteArrayToInt(reportPortTmp) + "";
		JSONObject reportIPOne = new JSONObject();
		reportIPOne.put("Type", "MeterReplyWriteGetReportIPOne");
		reportIPOne.put("Result", "SUCCESS");
		reportIPOne.put("reportIP", reportIP);
		reportIPOne.put("reportPort", reportPort);
		return reportIPOne.toString();
	}

	private static String ParseMeterReplyWriteGetReportTimeOneData(byte[] receivedCMD) {

		int reportType = 0; //

		byte reportTimeTmp[] = new byte[] { receivedCMD[15] };
		String reportTimeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(reportTimeTmp).toUpperCase(), 16));

		reportTimeString = String.format("%08d", (Integer.parseInt(reportTimeString)));
		//// System.out.println(reportTimeString);
		if (reportTimeString.substring(0, 3).equals("110")) {
			reportType = 1;
		} else if (reportTimeString.substring(0, 3).equals("100")) {
			reportType = 0;
		}
		int reportTime = Util.convertToDecimal(reportTimeString.substring(3));

		int reportSpace = receivedCMD[16];
		JSONObject reportTimeOne = new JSONObject();
		reportTimeOne.put("Type", "MeterReplyWriteGetReportTimeOne");
		reportTimeOne.put("Result", "SUCCESS");
		reportTimeOne.put("reportType", reportType);
		reportTimeOne.put("reportTime", reportTime);
		reportTimeOne.put("reportSpace", reportSpace);
		return reportTimeOne.toString();
	}

	public static String ParseMeterReplyWriteGetModuleInfoData(byte[] receivedCMD) {
		int realLength = 0;
		byte[] moduleTypeTmp = new byte[25];
		System.arraycopy(receivedCMD, 15, moduleTypeTmp, 0, 25);
		for (int i = 0; i < moduleTypeTmp.length; i++) {
			if (moduleTypeTmp[i] != 0x00) {
				realLength++;
			}
		}
		byte[] moduleTypeTmp2 = new byte[realLength];
		System.arraycopy(moduleTypeTmp, 0, moduleTypeTmp2, 0, realLength);
		String moduleType = Util.hexToAscii(Util.bytesToHexString(moduleTypeTmp2));

		realLength = 0;
		String moduleVersionType = "";
		byte[] moduleVersionTypeTmp = new byte[25];

		System.arraycopy(receivedCMD, 40, moduleVersionTypeTmp, 0, 25);

		for (int i = 0; i < moduleVersionTypeTmp.length; i++) {
			if (moduleVersionTypeTmp[i] != 0x00) {
				realLength++;
			}
		}
		byte[] moduleVersionTypeTmp2 = new byte[realLength];
		System.arraycopy(moduleVersionTypeTmp, 0, moduleVersionTypeTmp2, 0, realLength);
		moduleVersionType = Util.hexToAscii(Util.bytesToHexString(moduleVersionTypeTmp2));

		String moduleIMEI = "";
		byte[] moduleIMEITmp = new byte[15];
		System.arraycopy(receivedCMD, 65, moduleIMEITmp, 0, 15);
		moduleIMEI = Util.hexToAscii(Util.bytesToHexString(moduleIMEITmp));

		String cardIMSI = "";
		byte[] cardIMSITmp = new byte[15];
		System.arraycopy(receivedCMD, 80, cardIMSITmp, 0, 15);
		cardIMSI = Util.hexToAscii(Util.bytesToHexString(cardIMSITmp));

		String cardICCID = "";
		byte[] cardICCIDTmp = new byte[20];
		System.arraycopy(receivedCMD, 95, cardICCIDTmp, 0, 20);
		cardICCID = Util.hexToAscii(Util.bytesToHexString(cardICCIDTmp));

		JSONObject moduleInfos = new JSONObject();
		moduleInfos.put("Type", "MeterReplyWriteGetModuleInfo");
		moduleInfos.put("Result", "SUCCESS");
		moduleInfos.put("moduleType", moduleType);
		moduleInfos.put("moduleVersionType", moduleVersionType);
		moduleInfos.put("moduleIMEI", moduleIMEI);
		moduleInfos.put("cardIMSI", cardIMSI);
		moduleInfos.put("cardICCID", cardICCID);
		//// System.out.println(moduleInfos.toString());
		return moduleInfos.toString();
	}

	private static String ParseMeterReplyWriteGet24HoursRecordsData(byte[] receivedCMD) {
		byte recordsTimeTmp[] = new byte[3];
		System.arraycopy(receivedCMD, 15, recordsTimeTmp, 0, 3);
		String startDate = Util.bytesToHexString(recordsTimeTmp);
		int readDays = receivedCMD[18];
		byte useGasAmountOneTmp[] = new byte[4];
		JSONObject useGasAmountRecords = new JSONObject();
		// 17
		if (readDays > 0) {
			useGasAmountRecords.put("useGasAmount", 0);
		} else {
			for (int j = 0; j < readDays; j++) {
				for (int i = 0; i < 24; i++) {

					useGasAmountOneTmp = new byte[4];
					System.arraycopy(receivedCMD, 15 + (4 * i), useGasAmountOneTmp, 1, 3);
					int useGasAmountOneInt = Util.byteArrayToInt(useGasAmountOneTmp);
					int useGasAmountOneDouble = receivedCMD[15 + (4 * i) + 3];
					double useGasAmountOne = useGasAmountOneInt + (double) useGasAmountOneDouble / 100;
					useGasAmountRecords.put("day" + (j + 1) + "useGasAmount" + (i + 1), useGasAmountOne);
				}
			}
		}

		JSONObject hoursRecords = new JSONObject();
		hoursRecords.put("Type", "MeterReplyWriteGet24HoursRecords");
		hoursRecords.put("Result", "SUCCESS");
		hoursRecords.put("startDate", startDate);
		hoursRecords.put("readDays", readDays);
		hoursRecords.put("24hourUseGasData", useGasAmountRecords);

		return hoursRecords.toString();
	}

	private static String ParseMeterReplyWriteGetRecordsData(byte[] receivedCMD) {
		JSONObject recordsInfo = new JSONObject();
		JSONObject useGasAmountRecords = new JSONObject();
		byte useGasAmountOneTmp[] = new byte[4];
		for (int i = 0; i < 24; i++) {

			useGasAmountOneTmp = new byte[4];
			System.arraycopy(receivedCMD, 15 + (4 * i), useGasAmountOneTmp, 1, 3);
			int useGasAmountOneInt = Util.byteArrayToInt(useGasAmountOneTmp);
			int useGasAmountOneDouble = receivedCMD[15 + (4 * i) + 3];
			double useGasAmountOne = useGasAmountOneInt + (double) useGasAmountOneDouble / 100;
			useGasAmountRecords.put("useGasAmount" + (i + 1), useGasAmountOne);
		}
		String recordDate = String.format("%02d", (receivedCMD[96])) + String.format("%02d", (receivedCMD[97]));
		int safeCheckRecordsCount = receivedCMD[99];
		JSONObject safeCheckRecords = new JSONObject();
		for (int i = 0; i < safeCheckRecordsCount; i++) {

			byte jobNumberTmp[] = new byte[3];
			byte safeCheckTimeTmp[] = new byte[3];
			System.arraycopy(receivedCMD, 99 + (6 * i) + 1, jobNumberTmp, 0, 3);
			System.arraycopy(receivedCMD, 102 + (6 * i) + 1, safeCheckTimeTmp, 0, 3);

			String jobNumber = Util.bytesToHexString(jobNumberTmp);
			String safeCheckTime = String.format("%02d", (safeCheckTimeTmp[0]))
					+ String.format("%02d", (safeCheckTimeTmp[1])) + String.format("%02d", (safeCheckTimeTmp[2]));

			JSONObject safeCheckInfo = new JSONObject();
			safeCheckInfo.put("jobNumber", jobNumber);
			safeCheckInfo.put("safeCheckTime", safeCheckTime);

			safeCheckRecords.put("safeCheckRecords" + (i + 1), safeCheckInfo);
		}
		recordsInfo.put("Type", "MeterReplyWriteGetRecords");
		recordsInfo.put("Result", "SUCCESS");
		recordsInfo.put("useGasAmountRecords", useGasAmountRecords);
		recordsInfo.put("recordDate", recordDate);
		recordsInfo.put("safeCheckRecordsCount", safeCheckRecordsCount);
		recordsInfo.put("safeCheckRecords", safeCheckRecords);
		return recordsInfo.toString();
	}

	private static String ParseMeterReplyWriteSetParamData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteParam");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	public static String ParseMeterReplyWriteGetParamData(byte[] receivedCMD) {

		int isOverFlow = receivedCMD[15];

		byte overFlowParamTmp[] = new byte[2];
		System.arraycopy(receivedCMD, 16, overFlowParamTmp, 0, 2);
		int overFlowParam = Util.HexToInt(overFlowParamTmp, 2);

		byte ControlVersion[] = new byte[2];
		System.arraycopy(receivedCMD, 18, ControlVersion, 0, 2);
		String ControlVersionTmp = Util.bytesToHexString(ControlVersion);
		String ControlVersionStr = ControlVersionTmp.substring(0, 2);
		String CodeVersionStr = "V" + ControlVersionTmp.substring(2, 3) + "." + ControlVersionTmp.substring(3);

		byte[] remainMoneytem = new byte[3];
		System.arraycopy(receivedCMD, 20, remainMoneytem, 0, 3);
		String remainMoneyString = Util.bytesToHexString(remainMoneytem);

		int remainMoneyInt = (short) (Integer.valueOf(remainMoneyString, 16) & 0xffffff);
		int remainMoneyDouble = receivedCMD[23];
		double remainMoney = 0d;
		if (remainMoneyInt < 0) {
			remainMoneyInt = remainMoneyInt + 1;
			remainMoney = remainMoneyInt - (double) remainMoneyDouble / 100;
		} else {
			remainMoney = remainMoneyInt + (double) remainMoneyDouble / 100;
		}
		byte[] calcuGastem = new byte[4];
		System.arraycopy(receivedCMD, 24, calcuGastem, 1, 3);
		int calcuGasInt = Util.byteArrayToInt(calcuGastem);
		int calcuGasDouble = receivedCMD[27];
		// ////System.out.println("calcuGas:" + calcuGasInt + "." + calcuGasDouble);
		double calcuGas = calcuGasInt + (double) calcuGasDouble / 100;

		byte[] calcuMoneyTmp = new byte[4];
		System.arraycopy(receivedCMD, 28, calcuMoneyTmp, 1, 3);
		int calcuMoneyInt = Util.byteArrayToInt(calcuMoneyTmp);
		int calcuMoneyDouble = receivedCMD[31];
		// ////System.out.println("remainMoney:" + remainMoneyInt + "." +
		// remainMoneyDouble);
		double calcuMoney = calcuMoneyInt + (double) calcuMoneyDouble / 100;
		int buytimes = receivedCMD[32];

		int priceInt = receivedCMD[33];
		int priceDouble = receivedCMD[34];
		// ////System.out.println("price:" + priceInt + "." + priceDouble);
		double price = priceInt + (double) priceDouble / 100;

		// ！！！！！！！！！MeterTime

		byte[] meterTime = new byte[6];
		System.arraycopy(receivedCMD, 35, meterTime, 0, 6);
		String metertiemString = String.format("%02d", (meterTime[0])) + String.format("%02d", (meterTime[1]))
				+ String.format("%02d", (meterTime[2])) + String.format("%02d", (meterTime[3]))
				+ String.format("%02d", (meterTime[4])) + String.format("%02d", (meterTime[5]));

		int unUseGasDay = receivedCMD[41];
		byte unUserGasSecTmp[] = new byte[2];
		System.arraycopy(receivedCMD, 42, unUserGasSecTmp, 0, 2);
		int unUserGasSec = Util.HexToInt(unUserGasSecTmp, 2);

		int deathMeterFlag = receivedCMD[44];

		int deathMeterOne = receivedCMD[45];
		int deathMeterTwo = receivedCMD[46];

		//
		int limitBuyFlag = receivedCMD[47];
		//
		byte limitBuyMoneyTmp[] = new byte[4];
		System.arraycopy(receivedCMD, 48, limitBuyMoneyTmp, 1, 3);
		int limitBuyMoney = Util.byteArrayToInt(limitBuyMoneyTmp);

		byte UserCardNoTmp[] = new byte[5];
		System.arraycopy(receivedCMD, 51, UserCardNoTmp, 0, 5);
		String UserCardNo = Util.bytesToHexString(UserCardNoTmp);
		// 56 57 表状�?

		int isOpenAccount = receivedCMD[58];

		int FacortyCode = receivedCMD[59];
		//
		byte[] calcuStairGastem = new byte[4];
		System.arraycopy(receivedCMD, 60, calcuStairGastem, 1, 3);
		int calcuStairGasInt = Util.byteArrayToInt(calcuStairGastem);
		int calcuStairGasDouble = receivedCMD[63];
		double calcuStairGas = calcuStairGasInt + (double) calcuStairGasDouble / 100;
		//
		byte forceSafeCheckDaysTmp[] = new byte[2];
		System.arraycopy(receivedCMD, 64, forceSafeCheckDaysTmp, 0, 2);

		int forceSafeCheckDays = Util.HexToInt(forceSafeCheckDaysTmp, 2);
		byte forceScrapDaysTmp[] = new byte[2];
		System.arraycopy(receivedCMD, 66, forceScrapDaysTmp, 0, 2);
		//
		int forceScrapDays = Util.HexToInt(forceScrapDaysTmp, 2);

		int setForceSafeCheckYear = receivedCMD[68];
		int setForceScrapYear = receivedCMD[69];

		int setAlarmValueOne = receivedCMD[70];
		int setAlarmValueTwo = receivedCMD[71];

		byte tolalOverUseIntTmp[] = new byte[4];
		System.arraycopy(receivedCMD, 72, tolalOverUseIntTmp, 1, 3);
		int tolalOverUseInt = Util.byteArrayToInt(tolalOverUseIntTmp);
		int tolalOverUseDouble = receivedCMD[75];
		double tolalOverUse = tolalOverUseInt + (double) tolalOverUseDouble / 100;
		byte currOverUseIntTmp[] = new byte[4];
		System.arraycopy(receivedCMD, 76, currOverUseIntTmp, 1, 3);
		int currOverUseInt = Util.byteArrayToInt(currOverUseIntTmp);
		int currOverUseDouble = receivedCMD[79];
		double currOverUse = currOverUseInt + (double) currOverUseDouble / 100;

		byte handleOverUseDayTmp[] = new byte[3];
		System.arraycopy(receivedCMD, 80, handleOverUseDayTmp, 0, 3);
		String handleOverUseDay = String.format("%02d", (handleOverUseDayTmp[0]))
				+ String.format("%02d", (handleOverUseDayTmp[1])) + String.format("%02d", (handleOverUseDayTmp[2]));

		JSONObject paramJsonObject = new JSONObject();
		paramJsonObject.put("Type", "MeterReplyGetParam");
		paramJsonObject.put("Result", "SUCCESS");
		paramJsonObject.put("isOverFlow", isOverFlow);
		paramJsonObject.put("overFlowParam", overFlowParam);
		paramJsonObject.put("ControlVersionStr", ControlVersionStr);
		paramJsonObject.put("CodeVersionStr", CodeVersionStr);
		paramJsonObject.put("remainMoney", remainMoney);
		paramJsonObject.put("calcuGas", calcuGas);
		paramJsonObject.put("calcuMoney", calcuMoney);
		paramJsonObject.put("buytimes", buytimes);
		paramJsonObject.put("price", price);
		paramJsonObject.put("meterTimeString", metertiemString);
		paramJsonObject.put("unUseGasDay", unUseGasDay);
		paramJsonObject.put("unUserGasSec", unUserGasSec);
		paramJsonObject.put("deathMeterFlag", deathMeterFlag);
		paramJsonObject.put("deathMeterOne", deathMeterOne);
		paramJsonObject.put("deathMeterTwo", deathMeterTwo);
		paramJsonObject.put("limitBuyFlag", limitBuyFlag);
		paramJsonObject.put("limitBuyMoney", limitBuyMoney);
		paramJsonObject.put("UserCardNo", UserCardNo);
		paramJsonObject.put("isOpenAccount", isOpenAccount);

		paramJsonObject.put("FacortyCode", FacortyCode);
		paramJsonObject.put("calcuStairGas", calcuStairGas);
		paramJsonObject.put("forceSafeCheckDays", forceSafeCheckDays);
		paramJsonObject.put("forceScrapDays", forceScrapDays);
		paramJsonObject.put("setForceSafeCheckYear", setForceSafeCheckYear);
		paramJsonObject.put("setForceScrapYear", setForceScrapYear);
		paramJsonObject.put("setAlarmValueOne", setAlarmValueOne);
		paramJsonObject.put("setAlarmValueTwo", setAlarmValueTwo);
		paramJsonObject.put("tolalOverUse", tolalOverUse);
		paramJsonObject.put("currOverUse", currOverUse);
		paramJsonObject.put("handleOverUseDay", handleOverUseDay);
		//// System.out.println(paramJsonObject.toString());
		return paramJsonObject.toString();

	}

	private static String ParseMeterReplyWriteSetPriceData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteSetPrice");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	/***
	 *
	 *
	 * @param receivedCMD
	 * @return
	 */
	public static String ParseMeterReplyPriceData(byte[] receivedCMD) {
		//
		int priceType = receivedCMD[15];
		//
		int isChangePrice = receivedCMD[16];
		//
		byte[] priceEffectDate = new byte[4];
		System.arraycopy(receivedCMD, 17, priceEffectDate, 0, 4);
		String priceEffectDateHEX = String.format("%02d", (priceEffectDate[0]))
				+ String.format("%02d", (priceEffectDate[1])) + String.format("%02d", (priceEffectDate[2]))
				+ String.format("%02d", (priceEffectDate[3]));
		//
		int priceDateCount = receivedCMD[21];
		//
		JSONArray jsonDateArray = new JSONArray();
		for (int i = 0; i < priceDateCount; i++) {
			JSONObject dateJson = new JSONObject();
			byte[] priceDateTmp = new byte[2];
			System.arraycopy(receivedCMD, (22 + i * 2), priceDateTmp, 0, 2);
			String priceDateTmpHEX = Util.bcd2Str(priceDateTmp);
			// ////System.out.println("StairDate--"+ ( i+1) +"--is" +priceDateTmpHEX);
			dateJson.put("Month", priceDateTmpHEX.substring(0, 1));
			dateJson.put("Day", priceDateTmp[1]);
			dateJson.put("PriceType", priceDateTmpHEX.substring(1, 2));
			jsonDateArray.add(dateJson);
		}
		int priceDetailCount = receivedCMD[22 + (2 * priceDateCount)];
		JSONArray jsonPriceDetailArray = new JSONArray();
		for (int i = 0; i < priceDetailCount; i++) {
			JSONObject priceJson = new JSONObject();

			byte[] priceDetailTmp = new byte[24];
			System.arraycopy(receivedCMD, (23 + (2 * priceDateCount) + (i * 24)), priceDetailTmp, 0, 24);
			int PriceOneInt = priceDetailTmp[0];
			int PriceOneDouble = priceDetailTmp[1];
			Double priceOne = 0d;
			priceOne = PriceOneInt + (double) PriceOneDouble / 100;
			byte[] GasOneTmp = new byte[3];
			System.arraycopy(priceDetailTmp, 2, GasOneTmp, 0, 3);
			int GasOne = Util.HexToInt(GasOneTmp, 3);

			int PriceTwoInt = priceDetailTmp[5];
			int PriceTwoDouble = priceDetailTmp[6];
			Double priceTwo = 0d;
			priceTwo = PriceTwoInt + (double) PriceTwoDouble / 100;
			byte[] GasTwoTmp = new byte[3];
			System.arraycopy(priceDetailTmp, 7, GasTwoTmp, 0, 3);
			int GasTwo = Util.HexToInt(GasTwoTmp, 3);

			int PriceThreeInt = priceDetailTmp[10];
			int PriceThreeDouble = priceDetailTmp[11];
			Double priceThree = 0d;
			priceThree = PriceThreeInt + (double) PriceThreeDouble / 100;

			int NewPriceOneInt = priceDetailTmp[12];
			int NewPriceOneDouble = priceDetailTmp[13];
			Double NewPriceOne = 0d;
			NewPriceOne = NewPriceOneInt + (double) NewPriceOneDouble / 100;
			byte[] NewGasOneTmp = new byte[3];
			System.arraycopy(priceDetailTmp, 14, NewGasOneTmp, 0, 3);
			int NewGasOne = Util.HexToInt(NewGasOneTmp, 3);

			int NewPriceTwoInt = priceDetailTmp[17];
			int NewPriceTwoDouble = priceDetailTmp[18];
			Double NewPriceTwo = 0d;
			NewPriceTwo = NewPriceTwoInt + (double) NewPriceTwoDouble / 100;
			byte[] NewGasTwoTmp = new byte[3];
			System.arraycopy(priceDetailTmp, 19, NewGasTwoTmp, 0, 3);
			int NewGasTwo = Util.HexToInt(NewGasTwoTmp, 3);

			int NewPriceThreeInt = priceDetailTmp[22];
			int NewPriceThreeDouble = priceDetailTmp[23];
			Double NewPriceThree = 0d;
			NewPriceThree = NewPriceThreeInt + (double) NewPriceThreeDouble / 100;

			priceJson.put("PriceOne", priceOne);
			priceJson.put("GasOne", GasOne);
			priceJson.put("PriceTwo", priceTwo);
			priceJson.put("GasTwo", GasTwo);
			priceJson.put("PriceThree", priceThree);

			priceJson.put("NewPriceOne", NewPriceOne);
			priceJson.put("NewGasOne", NewGasOne);
			priceJson.put("NewPriceTwo", NewPriceTwo);
			priceJson.put("NewGasTwo", NewGasTwo);
			priceJson.put("NewPriceThree", NewPriceThree);
			// ////System.out.println(priceJson.toString());
			jsonPriceDetailArray.add(priceJson);
		}
		JSONObject jstest = new JSONObject();
		jstest.put("Type", "MeterReplyPriceDetail");
		jstest.put("Result", "SUCCESS");
		jstest.put("priceType", priceType);
		jstest.put("isChangePrice", isChangePrice);
		jstest.put("priceEffectDate", priceEffectDateHEX);
		jstest.put("priceDateCount", priceDateCount);
		jstest.put("priceDate", jsonDateArray);
		jstest.put("priceDetailCount", priceDetailCount);
		jstest.put("PriceDetail", jsonPriceDetailArray);
		//// System.out.println(jstest.toString());
		return jstest.toString();
	}

	private static String ParseMeterReplyWriteValveControlData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();

		byte[] meterStatetem = new byte[2];
		System.arraycopy(receivedCMD, 16, meterStatetem, 0, 2);
		String meterStateString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterStatetem).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		String pattern = "0000000000000000";
		meterStateString = pattern.substring(0, pattern.length() - meterStateString.length()) + meterStateString;
		// meterStateString = String.format("%016d",
		// (Integer.parseInt(meterStateString)));
		char meterStatebyte[] = meterStateString.toCharArray();
		JSONObject meterStateObj = new JSONObject();
		meterStateObj.put("DethMeterOneFlag", meterStatebyte[15]);
		meterStateObj.put("DethMeterTwoFlag", meterStatebyte[14]);
		meterStateObj.put("MagneticFlag", meterStatebyte[13]);
		meterStateObj.put("ForceSafeCheckFlag", meterStatebyte[12]);
		meterStateObj.put("ForceSraptFlag", meterStatebyte[11]);
		meterStateObj.put("ValveState", meterStatebyte[10]);
		meterStateObj.put("OverFlowFlag", meterStatebyte[9]);
		meterStateObj.put("OutBatteryLowPowerFlag", meterStatebyte[8]);
		meterStateObj.put("OutBatteryLosePowerFlag", meterStatebyte[7]);
		meterStateObj.put("InnerBatteryLowPowerFlag", meterStatebyte[6]);
		meterStateObj.put("TimeErrFlag", meterStatebyte[5]);

		meterStateObj.put("LackOfGasFlag", meterStatebyte[4]);
		meterStateObj.put("AlarmAndCloseValve", meterStatebyte[3]);
		meterStateObj.put("ForceSafeCheckAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("ForceScraptAdviseFlag", meterStatebyte[1]);
		meterStateObj.put("WireCloseValveState", meterStatebyte[0]);

		jsonData.put("Type", "MeterReplyWriteValveControl");
		jsonData.put("Result", "SUCCESS");
		jsonData.put("MeterState", meterStateObj);
		return jsonData.toString();
	}

	private static String ParseMeterReplyWriteTimeData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		jsonData.put("Type", "MeterReplyWriteTime");
		jsonData.put("Result", "SUCCESS");
		return jsonData.toString();
	}

	/***
	 *
	 *
	 * @param receivedCMD
	 * @return {""}
	 */
	private static String ParseMeterReplyChargeData(byte[] receivedCMD) {
		JSONObject jsonData = new JSONObject();
		byte[] ChargeMoneytmp = new byte[4];
		System.arraycopy(receivedCMD, 16, ChargeMoneytmp, 1, 3);
		int ChargeMoneyint = Util.byteArrayToInt(ChargeMoneytmp);
		int ChargeMoneydouble = receivedCMD[19];
		// ////System.out.println("remainMoney:" + remainMoneyInt + "." +
		// remainMoneyDouble);
		double ChargeMoney = ChargeMoneyint + (double) ChargeMoneydouble / 100;

//		byte[] ChargeMoneytmp = new byte[4];
//		System.arraycopy(receivedCMD, 16, ChargeMoneytmp, 1, 3);
//
//
//
//
//		byte[] remainMoneytem = new byte[3];
//		System.arraycopy(receivedCMD,16, remainMoneytem, 0, 3);
//
//
//		String moneyIntString = Util.bytesToHexString(remainMoneytem);
//		int moneyInt = (short) (Integer.valueOf(moneyIntString, 16) & 0xffffff);
//		if (moneyInt < 0) {
//			moneyInt = moneyInt + 1;
//		}
//		int ChargeMoneydouble = receivedCMD[19];
//		double ChargeMoney = moneyInt + (double) ChargeMoneydouble / 100;

		int ChargeResult = receivedCMD[15];
		jsonData.put("Type", "MeterReplyCharge");
		jsonData.put("Result", "SUCCESS");
		jsonData.put("RemainMoney", ChargeMoney);
		jsonData.put("ChargeResult", ChargeResult);
		//// System.out.println(jsonData.toString());
		return jsonData.toString();
	}

	/**
	 *
	 */
	private static String ParseMeterReportData(byte[] ReceivedCMD) {
		//
		String reportDataVersionCode = Util.byteToHexString(ReceivedCMD[15]);
		//
		byte[] newRepFlag = new byte[2];
		System.arraycopy(ReceivedCMD, 16, newRepFlag, 0, 2);
		String newRepFlagString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(newRepFlag).toUpperCase(), 16));
		// System.out.println("newRepFlag-----------" + newRepFlagString);
		String pattern = "0000000000000000";
		newRepFlagString = pattern.substring(0, pattern.length() - newRepFlagString.length()) + newRepFlagString;

		char RepFlagbyte[] = newRepFlagString.toCharArray();
		JSONObject RepFlagObj = new JSONObject();

		RepFlagObj.put("reportByDeathMeterTwo", RepFlagbyte[4]);
		RepFlagObj.put("reportByDeathMeterOne", RepFlagbyte[5]);
		RepFlagObj.put("reportByMagneticPro", RepFlagbyte[7]);
		RepFlagObj.put("reportByReset", RepFlagbyte[8]);
		RepFlagObj.put("reportByLowPower", RepFlagbyte[10]);

		RepFlagObj.put("reportByLostPower", RepFlagbyte[11]);
		RepFlagObj.put("reportByKey2", RepFlagbyte[12]);
		RepFlagObj.put("reportByKey1", RepFlagbyte[13]);

		RepFlagObj.put("reportByTime", RepFlagbyte[15]);

		byte[] cmc = new byte[2];
		System.arraycopy(ReceivedCMD, 18, cmc, 0, 2);
		String cmcString = Util.bytesToHexString(cmc);
		byte[] mcuVersionCode = new byte[4];
		System.arraycopy(ReceivedCMD, 20, mcuVersionCode, 0, 4);
		String mcuVersionCodeString = Util.bcd2Str(mcuVersionCode);

		// 表类型 2019-09-24更新 两字节
		byte[] meterType = new byte[2];
		System.arraycopy(ReceivedCMD, 24, meterType, 0, 2);
		String meterTypeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterType).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterTypeString = pattern.substring(0, pattern.length() - meterTypeString.length()) + meterTypeString;
		System.out.println(meterTypeString);
		String meterTypeOne = meterTypeString.substring(0, 4);
		String meterTypeTwo = meterTypeString.substring(4, 8);
		String meterTypeThree = meterTypeString.substring(8, 12);
		String meterTypeFour = meterTypeString.substring(12);
		String meterTypeFinal = Integer.valueOf(meterTypeOne, 2) + "" + Integer.valueOf(meterTypeTwo, 2)
				+ Integer.valueOf(meterTypeThree, 2) + Integer.valueOf(meterTypeFour, 2);
		System.out.println(meterTypeFinal);

		byte[] calcuGastem = new byte[4];
		System.arraycopy(ReceivedCMD, 26, calcuGastem, 0, 4);
		int calcuGasInt = Util.byteArrayToInt(calcuGastem);
		int calcuGasDouble = ReceivedCMD[30];
		// ////System.out.println("calcuGas:" + calcuGasInt + "." + calcuGasDouble);
		double calcuGas = calcuGasInt + (double) calcuGasDouble / 100;
		byte[] remainMoneytem = new byte[4];
		System.arraycopy(ReceivedCMD, 31, remainMoneytem, 1, 3);
		int remainMoneyInt = Util.byteArrayToInt(remainMoneytem);
		int remainMoneyDouble = ReceivedCMD[34];
		// ////System.out.println("remainMoney:" + remainMoneyInt + "." +
		// remainMoneyDouble);
		double remainMoney = remainMoneyInt + (double) remainMoneyDouble / 100;
		int priceInt = ReceivedCMD[35];
		int priceDouble = ReceivedCMD[36];
		// ////System.out.println("price:" + priceInt + "." + priceDouble);
		double price = priceInt + (double) priceDouble / 100;
		byte[] buytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, 37, buytimestem, 2, 2);
		int buytimesint = Util.byteArrayToInt(buytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int buytimes = buytimesint;
		byte[] cardbuytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, 39, cardbuytimestem, 2, 2);
		int cardbuytimesint = Util.byteArrayToInt(cardbuytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int cardbuytimes = cardbuytimesint;
		byte[] meterStatetem = new byte[2];
		System.arraycopy(ReceivedCMD, 41, meterStatetem, 0, 2);
		String meterStateString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterStatetem).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterStateString = pattern.substring(0, pattern.length() - meterStateString.length()) + meterStateString;
		// meterStateString = String.format("%016d",
		// (Integer.parseInt(meterStateString)));
		char meterStatebyte[] = meterStateString.toCharArray();
		JSONObject meterStateObj = new JSONObject();
		meterStateObj.put("DethMeterOneFlag", meterStatebyte[15]);
		meterStateObj.put("DethMeterTwoFlag", meterStatebyte[14]);
		meterStateObj.put("MagneticFlag", meterStatebyte[13]);
		meterStateObj.put("ForceSafeCheckFlag", meterStatebyte[12]);
		meterStateObj.put("ForceSraptFlag", meterStatebyte[11]);
		meterStateObj.put("ValveState", meterStatebyte[10]);
		meterStateObj.put("OverFlowFlag", meterStatebyte[9]);
		meterStateObj.put("OutBatteryLowPowerFlag", meterStatebyte[8]);
		meterStateObj.put("OutBatteryLosePowerFlag", meterStatebyte[7]);
		meterStateObj.put("InnerBatteryLowPowerFlag", meterStatebyte[6]);
		meterStateObj.put("TimeErrFlag", meterStatebyte[5]);

		meterStateObj.put("LackOfGasFlag", meterStatebyte[4]);
		meterStateObj.put("AlarmAndCloseValve", meterStatebyte[3]);
		meterStateObj.put("ForceSafeCheckAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("ForceScraptAdviseFlag", meterStatebyte[1]);
		meterStateObj.put("WireCloseValveState", meterStatebyte[0]);

		String batteryState = "";
		byte batteryStatetem = ReceivedCMD[43];
		double batteryStateDouble = 0d;
		if (batteryStatetem < 100) {
			batteryStateDouble = batteryStatetem / 10;
			batteryState = batteryStateDouble + "";
		} else {
			int v = batteryStatetem & 0xFF;
			batteryState = Integer.toHexString(v).toUpperCase();
			if (batteryState.equals("80")) {
				// ////System.out.println("batteryState:" + batteryStatetem + "-Normal");
			} else if (batteryState == "90") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LowPower");
			} else if (batteryState == "A0") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LostPower");
			}
		}

		// int tempint = ReceivedCMD[30];
		int tempdouble = ReceivedCMD[45];
		byte tempbytes[] = new byte[] { ReceivedCMD[44] };
		String tempintString = Util.bytesToHexString(tempbytes);
		int tempint = (short) (Integer.valueOf(tempintString, 16) & 0xff);
		if (tempint < 0) {
			tempint = tempint + 1;
		}
		// ////System.out.println("meterTem:" + tempint + "." + tempdouble);
		double meterTemperature = tempint + (double) tempdouble / 100;

		int CSQ = ReceivedCMD[46];
		// ////System.out.println("CSQ:" + CSQ);

		byte[] signalPower = new byte[2];
		System.arraycopy(ReceivedCMD, 47, signalPower, 0, 2);

		String signalPowerString = Util.bytesToHexString(signalPower);
		int signalPowerInt = (short) (Integer.valueOf(signalPowerString, 16) & 0xffff);
		if (signalPowerInt < 0)
			signalPowerInt = signalPowerInt + 1;
		// ////System.out.println("signalPower:" + signalPowerInt);
		// SNR
		byte[] SNR = new byte[2];
		System.arraycopy(ReceivedCMD, 49, SNR, 0, 2);

		String SNRString = Util.bytesToHexString(SNR);
		int SNRshort = (short) (Integer.valueOf(SNRString, 16) & 0xffff);
		if (SNRshort < 0)
			SNRshort = SNRshort + 1;
		// ////System.out.println("SNR:" + SNRshort);
		// ECL
		int ECL = ReceivedCMD[51];
		// ////System.out.println("ECL:" + ECL);
		// Cell ID
		byte[] CellID = new byte[4];

		System.arraycopy(ReceivedCMD, 52, CellID, 0, 4);
		int CellIDint = Util.byteArrayToInt(CellID);
		// ////System.out.println("CellID:" + CellIDint);
		// PCI
		byte[] PCI = new byte[4];
		System.arraycopy(ReceivedCMD, 56, PCI, 2, 2);
		int PCIint = Util.byteArrayToInt(PCI);
		// ////System.out.println("PCI:" + PCIint);
		// EARFCN
		byte[] EARFCN = new byte[4];
		System.arraycopy(ReceivedCMD, 58, EARFCN, 0, 4);
		int EARFCNint = Util.byteArrayToInt(EARFCN);

		// // ////System.out.println("CommutFlag:" + cmcString);
		byte[] meterTime = new byte[7];
		System.arraycopy(ReceivedCMD, 62, meterTime, 0, 7);
		String meterTimeString = Util.bcd2Str(meterTime);
		// ////System.out.println("meterTime:" + meterTimeString);
		JSONObject jsonData = new JSONObject();
		jsonData.put("reportDataVersionCode", reportDataVersionCode);
		jsonData.put("mcuVersionCodeString", mcuVersionCodeString);
		jsonData.put("cardbuytimes", cardbuytimes);
		jsonData.put("Result", "SUCCESS");
		jsonData.put("Type", "MeterReport");
		jsonData.put("meterType", meterTypeFinal);
		jsonData.put("calcuGas", calcuGas);
		jsonData.put("remainMoney", remainMoney);
		jsonData.put("price", price);
		jsonData.put("buytimes", buytimes);
		jsonData.put("meterState", meterStateObj);
		jsonData.put("batteryState", batteryState);
		jsonData.put("meterTemperature", meterTemperature);
		jsonData.put("CSQ", CSQ);
		jsonData.put("signalPower", signalPowerInt);
		jsonData.put("SNR", SNRshort);
		jsonData.put("ECL", ECL);
		jsonData.put("CellID", CellIDint);
		jsonData.put("PCI", PCIint);
		jsonData.put("EARFCN", EARFCNint);
		jsonData.put("repFlag", RepFlagObj);
		jsonData.put("cmcState", cmcString);
		jsonData.put("meterTime", meterTimeString);
		System.out.println(jsonData.toString());
		return jsonData.toString();

	}

	private static String ParseMeterReportDataWithSE(byte[] ReceivedCMD) {
		//

		JSONObject jsonData = new JSONObject();

		int startindex = 15;

		String reportDataVersionCode = Util.byteToHexString(ReceivedCMD[startindex]);
		String randStr = "";
		if (reportDataVersionCode == "01" || reportDataVersionCode.equals("01")) {
			byte[] randStrtmp = new byte[8];
			System.arraycopy(ReceivedCMD, startindex + 1, randStrtmp, 0, 8);
			randStr = Util.bytesToHexString(randStrtmp);
			jsonData.put("randStr", randStr);
			startindex = startindex + 8;
		}

		//
		byte[] newRepFlag = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 1, newRepFlag, 0, 2);
		String newRepFlagString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(newRepFlag).toUpperCase(), 16));
		// System.out.println("newRepFlag-----------" + newRepFlagString);
		String pattern = "0000000000000000";
		newRepFlagString = pattern.substring(0, pattern.length() - newRepFlagString.length()) + newRepFlagString;

		char RepFlagbyte[] = newRepFlagString.toCharArray();
		JSONObject RepFlagObj = new JSONObject();

		RepFlagObj.put("reportByDeathMeterTwo", RepFlagbyte[4]);
		RepFlagObj.put("reportByDeathMeterOne", RepFlagbyte[5]);
		RepFlagObj.put("reportByMagneticPro", RepFlagbyte[7]);
		RepFlagObj.put("reportByReset", RepFlagbyte[8]);
		RepFlagObj.put("reportByLowPower", RepFlagbyte[10]);

		RepFlagObj.put("reportByLostPower", RepFlagbyte[11]);
		RepFlagObj.put("reportByKey2", RepFlagbyte[12]);
		RepFlagObj.put("reportByKey1", RepFlagbyte[13]);

		RepFlagObj.put("reportByTime", RepFlagbyte[15]);

		byte[] cmc = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 3, cmc, 0, 2);
		String cmcString = Util.bytesToHexString(cmc);
		byte[] mcuVersionCode = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 5, mcuVersionCode, 0, 4);
		String mcuVersionCodeString = Util.bcd2Str(mcuVersionCode);

		// 表类型 2019-09-24更新 两字节
		byte[] meterType = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 9, meterType, 0, 2);
		String meterTypeString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterType).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterTypeString = pattern.substring(0, pattern.length() - meterTypeString.length()) + meterTypeString;
		System.out.println(meterTypeString);
		String meterTypeOne = meterTypeString.substring(0, 4);
		String meterTypeTwo = meterTypeString.substring(4, 8);
		String meterTypeThree = meterTypeString.substring(8, 12);
		String meterTypeFour = meterTypeString.substring(12);
		String meterTypeFinal = Integer.valueOf(meterTypeOne, 2) + "" + Integer.valueOf(meterTypeTwo, 2)
				+ Integer.valueOf(meterTypeThree, 2) + Integer.valueOf(meterTypeFour, 2);
		System.out.println(meterTypeFinal);

		byte[] calcuGastem = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 11, calcuGastem, 0, 4);
		int calcuGasInt = Util.byteArrayToInt(calcuGastem);
		int calcuGasDouble = ReceivedCMD[startindex + 15];
		// ////System.out.println("calcuGas:" + calcuGasInt + "." + calcuGasDouble);
		double calcuGas = calcuGasInt + (double) calcuGasDouble / 100;

		byte[] remainMoneytem = new byte[3];
		System.arraycopy(ReceivedCMD, startindex + 16, remainMoneytem, 0, 3);

		String moneyIntString = Util.bytesToHexString(remainMoneytem);
		int moneyInt = (short) (Integer.valueOf(moneyIntString, 16) & 0xffffff);
		if (moneyInt < 0) {
			moneyInt = moneyInt + 1;
		}
		int remainMoneyDouble = ReceivedCMD[startindex + 19];
		double remainMoney = 0;
		if (moneyInt < 0) {

			remainMoney = moneyInt - (double) remainMoneyDouble / 100;
		} else {
			remainMoney = moneyInt + (double) remainMoneyDouble / 100;
		}

		int priceInt = ReceivedCMD[startindex + 20];
		int priceDouble = ReceivedCMD[startindex + 21];
		// ////System.out.println("price:" + priceInt + "." + priceDouble);
		double price = priceInt + (double) priceDouble / 100;
		byte[] buytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 22, buytimestem, 2, 2);
		int buytimesint = Util.byteArrayToInt(buytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int buytimes = buytimesint;
		byte[] cardbuytimestem = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 24, cardbuytimestem, 2, 2);
		int cardbuytimesint = Util.byteArrayToInt(cardbuytimestem);
		// ////System.out.println("buytimes:" + buytimesint);
		int cardbuytimes = cardbuytimesint;
		byte[] meterStatetem = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 26, meterStatetem, 0, 2);
		String meterStateString = Integer
				.toBinaryString(Integer.parseInt(Util.bytesToHexString(meterStatetem).toUpperCase(), 16));
		// System.out.println("meterState-----------" + meterStateString);
		pattern = "0000000000000000";
		meterStateString = pattern.substring(0, pattern.length() - meterStateString.length()) + meterStateString;
		// meterStateString = String.format("%016d",
		// (Integer.parseInt(meterStateString)));
		char meterStatebyte[] = meterStateString.toCharArray();
		JSONObject meterStateObj = new JSONObject();
		meterStateObj.put("DethMeterOneFlag", meterStatebyte[15]);
		meterStateObj.put("DethMeterTwoFlag", meterStatebyte[14]);
		meterStateObj.put("MagneticFlag", meterStatebyte[13]);
		meterStateObj.put("ForceSafeCheckFlag", meterStatebyte[12]);
		meterStateObj.put("ForceSraptFlag", meterStatebyte[11]);
		meterStateObj.put("ValveState", meterStatebyte[10]);
		meterStateObj.put("OverFlowFlag", meterStatebyte[9]);
		meterStateObj.put("OutBatteryLowPowerFlag", meterStatebyte[8]);
		meterStateObj.put("OutBatteryLosePowerFlag", meterStatebyte[7]);
		meterStateObj.put("InnerBatteryLowPowerFlag", meterStatebyte[6]);
		meterStateObj.put("TimeErrFlag", meterStatebyte[5]);

		meterStateObj.put("LackOfGasFlag", meterStatebyte[4]);
		meterStateObj.put("AlarmAndCloseValve", meterStatebyte[3]);
		meterStateObj.put("ForceSafeCheckAdviseFlag", meterStatebyte[2]);
		meterStateObj.put("ForceScraptAdviseFlag", meterStatebyte[1]);
		meterStateObj.put("WireCloseValveState", meterStatebyte[0]);

		String batteryState = "";
		byte batteryStatetem = ReceivedCMD[startindex + 28];
		double batteryStateDouble = 0d;
		if (batteryStatetem < 100) {
			batteryStateDouble = batteryStatetem / 10;
			batteryState = batteryStateDouble + "";
		} else {
			int v = batteryStatetem & 0xFF;
			batteryState = Integer.toHexString(v).toUpperCase();
			if (batteryState.equals("80")) {
				// ////System.out.println("batteryState:" + batteryStatetem + "-Normal");
			} else if (batteryState == "90") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LowPower");
			} else if (batteryState == "A0") {
				// ////System.out.println("batteryState:" + batteryStatetem + "-LostPower");
			}
		}

		// int tempint = ReceivedCMD[30];
		int tempdouble = ReceivedCMD[startindex + 30];
		byte tempbytes[] = new byte[] { ReceivedCMD[startindex + 29] };
		String tempintString = Util.bytesToHexString(tempbytes);
		int tempint = (short) (Integer.valueOf(tempintString, 16) & 0xff);
		if (tempint < 0) {
			tempint = tempint + 1;
		}
		// ////System.out.println("meterTem:" + tempint + "." + tempdouble);
		double meterTemperature = tempint + (double) tempdouble / 100;

		int CSQ = ReceivedCMD[startindex + 31];
		// ////System.out.println("CSQ:" + CSQ);

		byte[] signalPower = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 32, signalPower, 0, 2);

		String signalPowerString = Util.bytesToHexString(signalPower);
		int signalPowerInt = (short) (Integer.valueOf(signalPowerString, 16) & 0xffff);
		if (signalPowerInt < 0)
			signalPowerInt = signalPowerInt + 1;
		// ////System.out.println("signalPower:" + signalPowerInt);
		// SNR
		byte[] SNR = new byte[2];
		System.arraycopy(ReceivedCMD, startindex + 34, SNR, 0, 2);

		String SNRString = Util.bytesToHexString(SNR);
		int SNRshort = (short) (Integer.valueOf(SNRString, 16) & 0xffff);
		if (SNRshort < 0)
			SNRshort = SNRshort + 1;
		// ////System.out.println("SNR:" + SNRshort);
		// ECL
		int ECL = ReceivedCMD[startindex + 36];
		// ////System.out.println("ECL:" + ECL);
		// Cell ID
		byte[] CellID = new byte[4];

		System.arraycopy(ReceivedCMD, startindex + 37, CellID, 0, 4);
		int CellIDint = Util.byteArrayToInt(CellID);
		// ////System.out.println("CellID:" + CellIDint);
		// PCI
		byte[] PCI = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 41, PCI, 2, 2);
		int PCIint = Util.byteArrayToInt(PCI);
		// ////System.out.println("PCI:" + PCIint);
		// EARFCN
		byte[] EARFCN = new byte[4];
		System.arraycopy(ReceivedCMD, startindex + 43, EARFCN, 0, 4);
		int EARFCNint = Util.byteArrayToInt(EARFCN);

		// // ////System.out.println("CommutFlag:" + cmcString);
		byte[] meterTime = new byte[7];
		System.arraycopy(ReceivedCMD, startindex + 47, meterTime, 0, 7);
		String meterTimeString = Util.bcd2Str(meterTime);
		// ////System.out.println("meterTime:" + meterTimeString);

		jsonData.put("reportDataVersionCode", reportDataVersionCode);
		jsonData.put("mcuVersionCodeString", mcuVersionCodeString);
		jsonData.put("cardbuytimes", cardbuytimes);
		jsonData.put("Result", "SUCCESS");
		jsonData.put("Type", "MeterReport");
		jsonData.put("meterType", meterTypeFinal);
		jsonData.put("calcuGas", calcuGas);
		jsonData.put("remainMoney", remainMoney);
		jsonData.put("price", price);
		jsonData.put("buytimes", buytimes);
		jsonData.put("meterState", meterStateObj);
		jsonData.put("batteryState", batteryState);
		jsonData.put("meterTemperature", meterTemperature);
		jsonData.put("CSQ", CSQ);
		jsonData.put("signalPower", signalPowerInt);
		jsonData.put("SNR", SNRshort);
		jsonData.put("ECL", ECL);
		jsonData.put("CellID", CellIDint);
		jsonData.put("PCI", PCIint);
		jsonData.put("EARFCN", EARFCNint);
		jsonData.put("repFlag", RepFlagObj);
		jsonData.put("cmcState", cmcString);
		jsonData.put("meterTime", meterTimeString);
		System.out.println(jsonData.toString());
		return jsonData.toString();

	}

	/**
	 *
	 * @param isEncrypt 是否明文 0 明文
	 * @param meterNo   表号
	 * @param SerialNo
	 * @param cmdParams
	 * @return
	 */
	public static String WriteSetSessionKey(String CodeNumber, int SerialNo, String cmdParams) {
		// TODO Auto-generated method stub
		// 传入参数为
		// 接写传入的参数
		System.out.println(cmdParams.split("#")[0]);
		System.out.println(cmdParams.split("#")[1]);

		System.out.println(cmdParams.split("#")[2]);
		System.out.println(cmdParams.split("#")[3]);
		String APDUCMD = GetSeesionKeyAPDU(cmdParams.split("#")[0], cmdParams.split("#")[1], cmdParams.split("#")[2],
				cmdParams.split("#")[3]);

		JSONObject jsonCMD = new JSONObject();

		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = (byte) 0x09;
			byte DataLength = (byte) 0x55;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[99];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			for (int i1 = 0; i1 < 4; i1++) {
				if (newDataLenth[i1] < 0)
					newDataLenth[i1] = (byte) (newDataLenth[i1] + 256);

			}
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			System.out.println(CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetSessionKeyFlag + CMDHEX.substring(28, CMDHEX.length());

			CMDHEX = CMDHEX.substring(0, 30) + APDUCMD.split(":")[0] + CMDHEX.substring(112, CMDHEX.length());
			String testa = CMDHEX.substring(0, 112);
			testa = CMDHEX.substring(194, CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 112) + APDUCMD.split(":")[1] + CMDHEX.substring(194, CMDHEX.length());

			//// System.out.println(CMDHEX)
			;
			if (1 == 2) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("WriteSetSessionKey:" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}

	}

	/**
	 *
	 * @param meterNo   表号
	 * @param SerialNo
	 * @param cmdParams {"EnSessionKey":"","DeSessionKey":""}
	 * @return
	 */
	public static String WriteSet_SessionKey(String CodeNumber, int SerialNo, String cmdParams) {
		// TODO Auto-generated method stub

		JSONObject paramsJson = JSONObject.fromObject(cmdParams);
		JSONObject jsonCMD = new JSONObject();

		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = (byte) 0x09;
			byte DataLength = (byte) 0x55;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[99];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			for (int i1 = 0; i1 < 4; i1++) {
				if (newDataLenth[i1] < 0)
					newDataLenth[i1] = (byte) (newDataLenth[i1] + 256);

			}
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			System.out.println(CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetSessionKeyFlag + CMDHEX.substring(28, CMDHEX.length());

			CMDHEX = CMDHEX.substring(0, 30) + paramsJson.getString("DE_APDU") + CMDHEX.substring(112, CMDHEX.length());
			String testa = CMDHEX.substring(0, 112);
			testa = CMDHEX.substring(194, CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 112) + paramsJson.getString("EN_APDU")
					+ CMDHEX.substring(194, CMDHEX.length());

			String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
			//// System.out.println(CSCODE);
			CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("WriteSetSessionKey:" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}

	}

	/**
	 *
	 * @param isEncrypt 是否明文 0 明文
	 * @param meterNo   表号
	 * @param SerialNo
	 * @param cmdParams
	 * @return
	 */
	public static String WriteSetChargeAPDU(String CodeNumber, int SerialNo, String cmdParams) {
		// TODO Auto-generated method stub
		// 传入参数为
		// 接写传入的参数
		System.out.println(cmdParams.split("#")[0]);
		System.out.println(cmdParams.split("#")[1]);

		System.out.println(cmdParams.split("#")[2]);
		System.out.println(cmdParams.split("#")[3]);

		// 5 money
		// 6 次数
		String APDUCMD = GetChargeAPDU(cmdParams.split("#")[0], cmdParams.split("#")[1], cmdParams.split("#")[2],
				cmdParams.split("#")[3], Double.parseDouble(cmdParams.split("#")[4]));

		JSONObject jsonCMD = new JSONObject();
		isEncry = 0;
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = (byte) 0x04;
			byte DataLength = (byte) 0x14;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[34];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n

			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			byte[] chartimes = Util.intToByteArray(Integer.parseInt(cmdParams.split("#")[5])); // CMDALL[10] =
																								// DataLength; \n

			System.arraycopy(chartimes, 2, CMDALL, 15, 2);

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			System.out.println(CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteChargeApduFlag + CMDHEX.substring(28, CMDHEX.length());

			CMDHEX = CMDHEX.substring(0, 34) + APDUCMD.split(":")[1]
					+ CMDHEX.substring(CMDHEX.length() - 4, CMDHEX.length());

			if (1 == 1) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("WriteSetChargeAPDU:" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}

	}

	/**
	 *
	 * @param encryType 是否明文 0 明文
	 * @param meterNo   表号
	 * @param SerialNo
	 * @param cmdParams
	 * @return
	 */
	public static String WriteSetEXAuthAPDU(int encryType, String CodeNumber, int SerialNo, String cmdParams) {
		// TODO Auto-generated method stub
		// 传入参数为
		isEncry = encryType;
		// 接写传入的参数
		System.out.println(cmdParams.split("#")[0]);
		System.out.println(cmdParams.split("#")[1]);

		System.out.println(cmdParams.split("#")[2]);

		String APDUCMD = GetExAuthAPDU(cmdParams.split("#")[0], cmdParams.split("#")[0], cmdParams.split("#")[2],
				cmdParams.split("#")[2]);

		JSONObject jsonCMD = new JSONObject();
		isEncry = 0;
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = (byte) 0x01;
			byte DataLength = (byte) 0x19;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[39];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n

			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			System.out.println(CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteRequestExAuth + CMDHEX.substring(28, CMDHEX.length());

			CMDHEX = CMDHEX.substring(0, 30) + "0" + cmdParams.split("#")[1] + APDUCMD
					+ CMDHEX.substring(CMDHEX.length() - 4, CMDHEX.length());

			if (1 == 1) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("WriteSetEXAuthAPDU:" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}

	}

	private static String GetExAuthAPDU(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr) {
		// TODO Auto-generated method stub
		String methodName = "exauth";
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr };
		// 执行
		System.out.println(args1[0] + args1[1] + args1[2] + args1[3] + args1[4]);
		String pyResult = ExecPython(args1);

		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);

		return pyResult;
	}

	/**
	 *
	 * @param isEncrypt  是否明文 0 明文
	 * @param meterNo    表号
	 * @param SerialNo
	 * @param JSONParams {"ChargeAPDU":"84320210080000300C40D5038E"}
	 * @return
	 */
	public static String WriteSetCharge_APDU(String CodeNumber, int SerialNo, String JSONParams) {
		// TODO Auto-generated method stub

		JSONObject jsonCMD = new JSONObject();
		isEncry = 0;
		try {
			JSONObject paramsJson = JSONObject.fromObject(JSONParams);
			byte SerialNO = (byte) SerialNo;
			byte ControlCode = (byte) 0x04;
			byte DataLength = (byte) 0x10;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[30];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n

			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			System.out.println(CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteChargeApduFlag + CMDHEX.substring(28, CMDHEX.length());

			CMDHEX = CMDHEX.substring(0, 30) + paramsJson.getString("ChargeAPDU")
					+ CMDHEX.substring(CMDHEX.length() - 4, CMDHEX.length());

			if (1 == 1) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("WriteSetChargeAPDU:" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}

	}

	public static String DataReNew(String Datat) {

		isEncry = 0;
		int dataLength = Datat.length() / 2;
		logger.debug("DATALENGTH:" + dataLength / 2);
		String DataToEncrypt = Datat;
		logger.debug("DATATOENCRYPT:" + DataToEncrypt);
		String DataEncrypted = "";

		int dataGroupInt = dataLength / 16;
		int dataGroupLeft = dataLength % 16;

		for (int i = 0; i < dataGroupInt; i++) {
			String DataToEncrypted = DataToEncrypt.substring((0 + (i * 32)), (0 + (i * 32)) + 32);
			if (isEncry == 1) {
				DataEncrypted += EncryptData(DataToEncrypted);
			} else {
				DataEncrypted += DataToEncrypted;
			}

		}
		if (dataGroupLeft == 0) {
			DataToEncrypt = "80000000000000000000000000000000";
			if (isEncry == 1) {
				DataToEncrypt = EncryptData(DataToEncrypt);
			}
			DataEncrypted += DataToEncrypt; //
		} else {
			DataToEncrypt = DataToEncrypt.substring((dataGroupInt * 32)) + "80";
			String pattern = "00000000000000000000000000000000";
			DataToEncrypt = DataToEncrypt + pattern.substring(0, pattern.length() - DataToEncrypt.length());
			// ////System.out.println("DATAAFTERPADDING:" + DataToEncrypt);
			if (isEncry == 1) {
				DataToEncrypt = EncryptData(DataToEncrypt);
			}
			DataEncrypted += DataToEncrypt; //
		}
		return DataEncrypted;
	}

	// 通过KMS加密数据
	public static String DecryptData_SE(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr, String Msg) {
		Ranstr = "0932AD470689B7B7";
		// 此处Msg为完成CMD
		// String RealMsgToDencry=Msg;
		String RealMsgToDencry = Msg.substring(24, Msg.length() - 4);
		System.out.println("待解密数据:" + RealMsgToDencry);
		String methodName = "SeesionKey_decrypt";
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr, RealMsgToDencry };
		// 执行
		String pyResult = ExecPython(args1);
		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);

		if (pyResult.contains("Err") || pyResult == "") {
			return null;
		}
		JSONObject kms_en = JSONObject.fromObject(pyResult.substring(11, pyResult.length()));
		System.out.println("解密后数据：" + kms_en.getJSONObject("obj").getString("msg"));
		Msg = Msg.substring(0, 24) + kms_en.getJSONObject("obj").getString("msg") + Msg.substring(Msg.length() - 4);
		return Msg;
	}

	// 通过KMS加密数据
	public static String DecryptData_SE_test(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr,
			String Msg) {
		Ranstr = "0932AD470689B7B7";
		// 此处Msg为完成CMD
		String RealMsgToDencry = Msg;
		// String RealMsgToDencry=Msg.substring(24,Msg.length()-4);
		System.out.println("待解密数据:" + RealMsgToDencry);
		String methodName = "SeesionKey_decrypt";
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr, RealMsgToDencry };
		// 执行
		String pyResult = ExecPython(args1);
		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);

		if (pyResult.contains("Err") || pyResult == "") {
			return null;
		}
		JSONObject kms_en = JSONObject.fromObject(pyResult.substring(11, pyResult.length()));
		System.out.println("解密后数据：" + kms_en.getJSONObject("obj").getString("msg"));
		Msg = Msg.substring(0, 24) + kms_en.getJSONObject("obj").getString("msg") + Msg.substring(Msg.length() - 4);
		return Msg;
	}
	// 通过KMS解密数据

	// TODO Auto-generated method stub
	public static String EncryptData_SE(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr, String Msg) {
		Ranstr = "0932AD470689B7B7";
		System.out.println("Msg:" + Msg);
		String RealMsgToEncry = Msg.substring(24, Msg.length() - 4);
		if ((RealMsgToEncry.length() % 16) != 0) {
			RealMsgToEncry = DataReNew(RealMsgToEncry);
		}
		System.out.println("待加密数据:" + RealMsgToEncry);

		String methodName = "SeesionKey_encrypt";
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr, RealMsgToEncry };
		// 执行
		String pyResult = ExecPython(args1);
		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);

		if (pyResult.contains("Err") || pyResult == "") {
			return null;
		}
		JSONObject kms_en = JSONObject.fromObject(pyResult.substring(11, pyResult.length()));
		System.out.println("加密后数据：" + kms_en.getJSONObject("obj").getString("msg"));
		// 组转
		Msg = Msg.substring(0, 24) + kms_en.getJSONObject("obj").getString("msg") + Msg.substring(Msg.length() - 4);

		// 加密后需要重新计算校验和！
		String CSCODE = Util.makeChecksum1(Msg.substring(0, Msg.length() - 4));
		//// System.out.println(CSCODE);
		Msg = Msg.substring(0, Msg.length() - 4) + CSCODE + Msg.substring(Msg.length() - 2);
		return Msg;

	}

	public static int ChecKSUMCode(String hexString) {
		String CSCode = Util.makeChecksum1(hexString.substring(0, hexString.length() - 4)).toUpperCase();
		String CSCodeReport = hexString.substring(hexString.length() - 4, hexString.length() - 2).toUpperCase();
		if (!CSCode.equals(CSCodeReport)) {

			return 1;
		} else {

			return 0;
		}
	}

	// TODO Auto-generated method stub
	public static String EncryptData_SE_test(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr,
			String Msg) {
		Ranstr = "0932AD470689B7B7";
		String RealMsgToEncry = Msg;
		if ((RealMsgToEncry.length() % 16) != 0) {
			RealMsgToEncry = DataReNew(RealMsgToEncry);
		}
		System.out.println("待加密数据:" + RealMsgToEncry);

		String methodName = "SeesionKey_encrypt";
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr, RealMsgToEncry };
		// 执行
		String pyResult = ExecPython(args1);
		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);

		if (pyResult.contains("Err") || pyResult == "") {
			return null;
		}
		JSONObject kms_en = JSONObject.fromObject(pyResult.substring(11, pyResult.length()));
		System.out.println("加密后数据：" + kms_en.getJSONObject("obj").getString("msg"));
		// 组转
		Msg = Msg.substring(0, 24) + kms_en.getJSONObject("obj").getString("msg") + Msg.substring(Msg.length() - 4);

		// 加密后需要重新计算校验和！
		String CSCODE = Util.makeChecksum1(Msg.substring(0, Msg.length() - 4));
		//// System.out.println(CSCODE);
		Msg = Msg.substring(0, Msg.length() - 4) + CSCODE + Msg.substring(Msg.length() - 2);
		return Msg;

	}

	public static String GetSeesionKeyAPDU(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr) {
		String methodName = "exportSm2";
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr };
		// 执行
		System.out.println(args1[0] + args1[1] + args1[2] + args1[3] + args1[4]);
		String pyResult = ExecPython(args1);

		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);
		System.out.println("指令1：" + pyResult.split(":")[1]);
		System.out.println("指令2：" + pyResult.split(":")[3]);
		return pyResult.split(":")[1] + ":" + pyResult.split(":")[3];

	}

	public static String GetChargeAPDU(String SEUID, String SESM2Key, String SEtempSm2Key, String Ranstr,
			double Money) {

		String methodName = "charge";
		String MoneyHexStr = flushLeft('0', 12, Integer.toHexString((int) (Money * 10000)));
		String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SESM2Key, SEtempSm2Key,
				Ranstr, MoneyHexStr };
		// 执行
		String pyResult = ExecPython(args1);
		System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + pyResult);

		return pyResult;

	}

	public static String ExecPython(String args[]) {
		String execResult = "";
		try {
			Process pr = Runtime.getRuntime().exec(args);
			BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
			String line;
			String result = "";
			while ((line = in.readLine()) != null) {
				result = line;
				// System.out.println("1:" + result);
			}
			execResult = result;
			in.close();
			pr.waitFor();

		} catch (Exception e) {

			execResult = "Err";
		}
		return execResult;

	}

	/*
	 * c 要填充的字符 length 填充后字符串的总长度 content 要格式化的字符串 格式化字符串，左对齐
	 */
	public static String flushLeft(char c, long length, String content) {
		String str = "";
		long cl = 0;
		String cs = "";
		if (content.length() > length) {
			str = content;
		} else {
			for (int i = 0; i < length - content.length(); i++) {
				cs = cs + c;
			}
		}
		str = cs + content;
		return str;
	}

	public static String WriteGetRandStrKey(int Encrytype, String CodeNumber, int SerialNo, String string) {
		// TODO Auto-generated method stub
		JSONObject jsonCMD = new JSONObject();
		isEncry = Encrytype;
		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = 0x09;
			byte DataLength = 0x03;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[17];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;
			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteGetRandStrFlag + CMDHEX.substring(28, CMDHEX.length());
			//// System.out.println(CMDHEX)
			;
			if (1 == 2) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			//// System.out.println(jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	public static String WriteGetUpdateCardKeyADPU(int EncryType, String CodeNumber, int SerialNo, String cmdParams) {
		// 传入参数为
		// 接写传入的参数
		isEncry = EncryType;
		System.out.println(cmdParams.split("#")[0]);
		System.out.println(cmdParams.split("#")[1]);

		System.out.println(cmdParams.split("#")[2]);

		// 根据2判断
		String APDUCMD = GetUpdateCardKeyAPDU(cmdParams.split("#")[0], cmdParams.split("#")[1],
				cmdParams.split("#")[2]);

		JSONObject jsonCMD = new JSONObject();

		try {

			byte SerialNO = (byte) SerialNo;
			byte ControlCode = (byte) 0x01;
			byte DataLength = (byte) 0x7F;
			CMDMeterNO = Util.str2Bcd(CodeNumber);
			byte[] CMDALL = new byte[141];
			CMDALL[0] = Constant.CMDHead;
			CMDALL[1] = Constant.CMDMeterType;
			System.arraycopy(CMDMeterNO, 0, CMDALL, 2, 7);
			CMDALL[9] = ControlCode;
			byte[] newDataLenth = Util.intToByteArray(DataLength); // CMDALL[10] = DataLength; \n
			for (int i1 = 0; i1 < 4; i1++) {
				if (newDataLenth[i1] < 0)
					newDataLenth[i1] = (byte) (newDataLenth[i1] + 256);

			}
			System.arraycopy(newDataLenth, 2, CMDALL, 10, 2);
			CMDALL[14] = SerialNO;

			CMDALL[CMDALL.length - 1] = Constant.CMDEndFlag;
			//// System.out.println(Arrays.toString(CMDALL));
			String CMDHEX = Util.bytesToHexString(CMDALL);
			System.out.println(CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 24) + Constant.WriteSetUpdateCardKey + CMDHEX.substring(28, CMDHEX.length());

			CMDHEX = CMDHEX.substring(0, 30) + "0" + cmdParams.split("#")[1] + APDUCMD.split("#")[0]
					+ CMDHEX.substring(114, CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 114) + APDUCMD.split("#")[1] + CMDHEX.substring(196, CMDHEX.length());
			CMDHEX = CMDHEX.substring(0, 196) + APDUCMD.split("#")[2] + CMDHEX.substring(278, CMDHEX.length());
			//// System.out.println(CMDHEX)
			;
			if (1 == 1) {
				CMDHEX = PackageEncryptCMDBody(CMDHEX);
			} else {
				String CSCODE = Util.makeChecksum1(CMDHEX.substring(0, CMDHEX.length() - 4));
				//// System.out.println(CSCODE);
				CMDHEX = CMDHEX.substring(0, CMDHEX.length() - 4) + CSCODE + CMDHEX.substring(CMDHEX.length() - 2);
			}

			jsonCMD.put("Result", "SUCCESS");
			jsonCMD.put("CodeNumber", CodeNumber);
			jsonCMD.put("SerialNo", SerialNo);
			jsonCMD.put("CMDHEXString", CMDHEX);
			System.out.println("WriteSetSessionKey:" + jsonCMD.toString());
			return jsonCMD.toString();
		} catch (Exception e) {
			jsonCMD.put("Result", "ERR");
			jsonCMD.put("Detail", e.toString());
			return jsonCMD.toString();
		}
	}

	private static String GetUpdateCardKeyAPDU(String SEUID, String KeyType, String RandStr) {
		// TODO Auto-generated method stub
		// 获取更新卡密钥的三条指令，
		String UpdateAPDU = "";
		String UpdateAPDUtemp = "";
		if (KeyType == "0" || KeyType.equals("0")) {

			String methodName = "UpdateKey2704_1";

			String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SEUID, SEUID, RandStr };
			// 执行
			UpdateAPDUtemp = ExecPython(args1);
			UpdateAPDU += UpdateAPDUtemp + "#";
			System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + UpdateAPDU);

			methodName = "UpdateKey2705_1";

			args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SEUID, SEUID, RandStr };
			// 执行
			UpdateAPDUtemp = ExecPython(args1);
			UpdateAPDU += UpdateAPDUtemp + "#";
			System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + UpdateAPDU);

			methodName = "UpdateKey2706_1";

			args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SEUID, SEUID, RandStr };
			// 执行
			UpdateAPDUtemp = ExecPython(args1);
			UpdateAPDU += UpdateAPDUtemp;
			System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + UpdateAPDU);
			// 修改为测试密钥
		} else {
			// 修改为正式密钥

			String methodName = "UpdateKey2704";

			String[] args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SEUID, SEUID, RandStr };
			// 执行
			UpdateAPDUtemp = ExecPython(args1);
			UpdateAPDU += UpdateAPDUtemp + "#";
			System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + UpdateAPDU);

			methodName = "UpdateKey2705";

			args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SEUID, SEUID, RandStr };
			// 执行
			UpdateAPDUtemp = ExecPython(args1);
			UpdateAPDU += UpdateAPDUtemp + "#";
			System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + UpdateAPDU);

			methodName = "UpdateKey2706";

			args1 = new String[] { "python", "C:\\py\\" + methodName + ".py", SEUID, SEUID, SEUID, RandStr };
			// 执行
			UpdateAPDUtemp = ExecPython(args1);
			UpdateAPDU += UpdateAPDUtemp;
			System.out.println("外部调用py脚本函数名为:" + methodName + "，脚本返回结果:" + UpdateAPDU);
		}

		return UpdateAPDU;
	}

}
