package com.aote.webmeter.module.JinKaIndustrySystem;

import com.af.plugins.ConvertTools;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JinKaSystemTools {

    public static Map<String, String> alarmType = new HashMap<>();

    static {
        alarmType.put("1001", "通讯异常");
        alarmType.put("1002", "燃气泄露");
        alarmType.put("1003", "干簧管坏");
        alarmType.put("1004", "存储器坏");
        alarmType.put("1005", "强磁干扰");
        alarmType.put("1006", "死表故障");
        alarmType.put("1007", "阀门漏气");
        alarmType.put("1009", "电池故障");
        alarmType.put("1010", "过流报警");
        alarmType.put("1011", "掉电 ");
        alarmType.put("2001", "强行关阀");
        alarmType.put("2002", "取消强关");
        alarmType.put("2003", "阀门异常");
        alarmType.put("2004", "直读异常");
        alarmType.put("3001", "欠费提醒");
        alarmType.put("3002", "充值提醒(一级)");
        alarmType.put("3003", "充值提醒(二级)");
        alarmType.put("3004", "单价为0");
        alarmType.put("4001", "低电量报警");
        alarmType.put("4002", "外部报警触发");
        alarmType.put("4003", "外部晶振停止");
        alarmType.put("4004", "压力超下限");
        alarmType.put("4005", "压力超上限");
        alarmType.put("4006", "温度超下限");
        alarmType.put("4007", "温度超上限");
        alarmType.put("4008", "流量超下限");
        alarmType.put("4009", "流量超上限");
        alarmType.put("5001", "时钟异常");
        alarmType.put("5002", "读数异常变小");
    }

    public static String getAlarmType(String key) {
        return alarmType.getOrDefault(key, key);
    }


    /**
     * 生成序列号
     * @return
     */
    public static String genSerialNo(){

        return UUID.randomUUID().toString().replace("-","");
    }


    public static String encodeMd5(String str){
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getCause()+e.getMessage());
        }
        byte[] result=md.digest(str.getBytes(StandardCharsets.UTF_8));

        StringBuilder sb=new StringBuilder();
        for (byte b : result) {
            String tmp = StringUtils.leftPad(String.format("%X", b), 2, '0');
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static String encodeString(String str) {
        String encodedStr = ConvertTools.base64Encode(str.getBytes(StandardCharsets.UTF_8));
        return encodedStr.trim();
    }

    public static String formatDate(String date){
        return date.substring(0, 4) + "-" + date.substring(4,6) + "-" + date.substring(6);
    }

}
