package com.aote.webmeter.exception;

import com.aote.webmeter.enums.IOTExceptionCodeEnum;
import com.aote.webmeter.enums.WebmeterExceptionCodeEnum;
import com.iotplatform.client.NorthApiException;

/**
 * 物联网表服务 通用异常类
 *
 * @author Mr.river
 */
public class WebmeterException extends RuntimeException {

    public WebmeterException(WebmeterExceptionCodeEnum webmeterExceptionCodeEnum) {
        super(
                getErrorMessage(
                        webmeterExceptionCodeEnum.getCode(),
                        webmeterExceptionCodeEnum.getName(),
                        webmeterExceptionCodeEnum.getMessage(),
                        ""
                )
        );
    }

    public WebmeterException(WebmeterExceptionCodeEnum webmeterExceptionCodeEnum, String remark) {
        super(
                getErrorMessage(
                        webmeterExceptionCodeEnum.getCode(),
                        webmeterExceptionCodeEnum.getName(),
                        webmeterExceptionCodeEnum.getMessage(),
                        remark
                )
        );
    }

    public WebmeterException(IOTExceptionCodeEnum iotExceptionCodeEnum) {
        super(
                getErrorMessage(
                        iotExceptionCodeEnum.getCode(),
                        iotExceptionCodeEnum.getName(),
                        iotExceptionCodeEnum.getMessage(),
                        ""
                )
        );
    }

    public WebmeterException(IOTExceptionCodeEnum iotExceptionCodeEnum, String remark) {
        super(
                getErrorMessage(
                        iotExceptionCodeEnum.getCode(),
                        iotExceptionCodeEnum.getName(),
                        iotExceptionCodeEnum.getMessage(),
                        remark
                )
        );
    }

    public WebmeterException(NorthApiException e) {
        super(
                getErrorMessage(
                        e.getError_code(),
                        e.getHttpStatusCode() + "请求异常",
                        e.getError_desc(),
                        e.getHttpMessage()
                )
        );
    }

    private static String getErrorMessage(String code, String name, String message, String remark) {
        return "{错误码：" + code + "    描述：" + name + "    说明：" + message + "    其他信息："+ remark +"}";
    }
}
