package com.aote.rs;


import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;

@Path("webmeter")
@Singleton
@Component
public class WebMeterInfoService {
    private static final Logger LOGGER = Logger.getLogger(WebMeterInfoService.class);

    /**
     * 重新加载物联网表模块参数（WebmeterInfo）
     *                                                                                                                    
     * @return 执行结果
     */
    @GET
    @Path("/reloadSetting")
    public String reload() {
        LOGGER.debug("重新加载物联网表模块参数");
        //获取物联网表配置文件并加载
        WebMeterInfo.load();
        return "ok";
    }
}
