-- 公共SQL：查询待同步的补费扣费记录
-- 必选参数
-- f_meter_brand：气表品牌名称，如宇迪NB物联网表，伦力NB物联网表等

SELECT t_cbgas.id,
       t_cbgas.f_times,
       t_cbgas.f_grossproceeds     f_preamount,
       t_cbgas.f_payfeetype,
       u.id                        f_user_id,
       u.f_userid                  f_userinfo_id,
       u.f_display_type,
       ui.f_usertype,
       u.f_meteramountnums,
       u.f_metergasnums,
       isnull(ui.f_stairmonths, 1) f_stairmonths,
       ui.f_stair1amount,
       ui.f_stair1price,
       ui.f_stair2amount,
       ui.f_stair2price,
       ui.f_stair3amount,
       ui.f_stair3price,
       u.f_meternumber
FROM t_cbgas
         LEFT JOIN t_userfiles u ON u.f_userid = t_cbgas.f_userid
         LEFT JOIN t_userinfo ui ON ui.f_userid = u.f_userinfoid
WHERE t_cbgas.f_payfeevalid = '有效'
  AND (t_cbgas.f_sendsuccess <> '成功' OR t_cbgas.f_sendsuccess IS NULL)
  AND u.f_aliasname = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND u.f_userstate = '正常'
ORDER BY t_cbgas.f_times
