SELECT t_pricechange.id,
       u.f_user_id,
       u.f_price_id,
       u.f_user_type,
       m.f_billing,
       s.id                        f_stairprice_id,
       s.f_version                 price_version,
       s.f_stair_start_date        start_date,
       s.f_perform_date            f_perform_date,
       isnull(s.f_stairmonths, 1)  f_stairmonths,
       t_pricechange.f_oldprice_id f_old_stairprice_id,
       u.f_meternumber,
       g.f_alias
FROM t_pricechange
         INNER JOIN t_userfiles u ON u.f_userinfo_id = t_pricechange.f_userinfo_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
         LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id and u.f_orgid = s.f_filialeid
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND (t_pricechange.F_SENDSUCCESS <> '成功' OR t_pricechange.F_SENDSUCCESS IS NULL)
  AND u.f_sendsuccess = '成功'
  AND m.f_calculation = '预付费'
  AND t_pricechange.f_userinfo_id is not null
  AND t_pricechange.id =
      (SELECT MAX(ID) FROM t_pricechange p where p.f_userinfo_id = t_pricechange.f_userinfo_id)
ORDER BY t_pricechange.id DESC
