SELECT ts.id                                                               data_id,
       u.f_user_id,
       u.f_userinfo_id,
       u.f_meternumber,
       u.f_total_fee,
       b.f_meter_brand,
       o.f_user_name,
       o.f_user_phone,
       s.id                                                                f_stairprice_id,
       isnull(s.f_stairmonths, 1)                                          f_stairmonths,
       u.f_show_way                                                        f_display_type,
       { entity.findDialect() == $SqlServer$: $substring(CONVERT(varchar(100), F_PERFORM_DATE, 10),0,6) as start_date$,$"SUBSTR"(TO_char(F_PERFORM_DATE,'mm-dd-yyyy'),0,5) as start_date$},
       s.f_stair_start_date                                                standard_start_date,
       ts.f_fillgas_fee                                                    f_collection,
       'changemeter'                                                       type
FROM t_fillgas ts
         LEFT JOIN t_userfiles u ON u.f_user_id = ts.f_user_id
         LEFT JOIN t_userinfo o ON o.f_userinfo_id = u.f_userinfo_id
         LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
         LEFT JOIN t_stairprice s ON s.f_price_id = u.f_price_id and u.f_orgid = s.f_orgid
WHERE (
        ts.f_sendsuccess <> '成功'
        OR ts.f_sendsuccess IS NULL
    )
  AND o.f_user_state = '正常'
  AND u.f_table_state = '正常'
  AND b.f_alias = '{f_meter_brand}'
  AND ts.f_fillgas_type = '换表补气'
  AND ts.f_fillgas_state = '有效'
  AND (isnull(ts.f_fillgas, 0) > 0 or
       isnull(ts.f_fillgas_fee, 0) > 0)
  AND s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  AND getdate() <= s.f_end_date
  AND u.f_sync_sendsuccess = '成功'
