SELECT t_fillgas.id,
       sp.id                                                            f_stairprice_id,
       t_fillgas.f_fillgas,
       t_fillgas.f_fillgas_fee,
       u.f_meternumber,
       u.f_total_fee,
       u.f_times,
       u.f_user_id,
       u.f_show_way                                                     f_display_type,
       sp.f_stairmonths,
       substring(CONVERT(varchar(100), F_PERFORM_DATE, 10), 0, 6) as start_date
FROM t_fillgas
         LEFT JOIN t_userfiles u ON u.f_user_id = t_fillgas.f_user_id
         LEFT JOIN t_stairprice sp ON sp.f_price_id = u.f_price_id and u.f_filialeids = sp.f_filialeids
         LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.ID
where t_fillgas.f_fillgas_state = '有效'
  AND t_fillgas.f_fillgas_type = '换表补气'
  AND (t_fillgas.F_SENDSUCCESS <> '成功' OR t_fillgas.F_SENDSUCCESS IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND sp.f_state = '有效'
  AND getdate() >= sp.f_perform_date
  and getdate() <= sp.f_end_date
