-- 公共SQL：积成-查询待开户的表具信息
-- 必选参数
-- f_meter_brand：气表品牌名称，如青岛积成等

SELECT tua.f_residential_area area_name,-- 不存在或者未填写
       t.f_user_name          customer_name,
       tua.f_address          address,
       t.f_createfile_date    create_date,
       t.f_user_phone         phone,
       tu.f_user_type         customer_type,
       tu.f_user_id           customer_code,
       tu.f_initial_base      start_val,
       tu.f_price_id          use_nature,
       m.f_metertype          meter_type_name, -- 不存在或者未填
       m.f_terminal_id        terminal_name, -- 对应的设备不存在
       m.f_iot_type           channel_type,
       m.f_diameter           caliber,
       m.f_meter_phone        meter_phone,
       m.f_meternumber        steal_no,
       m.f_valvemark          switch_op,
       m.f_telecomm_no        telecomm_sn,
       m.f_imei               imei,
       m.f_imsi               iccid,
       m.f_vender             vender,
       t.f_filialeids         filialeids,
       tu.f_balance_amount    balance,
       ts.id                  stairprice_id
FROM t_userfiles tu
         LEFT JOIN t_userinfo t ON tu.f_userinfo_id = t.f_userinfo_id
         LEFT JOIN t_user_address tua ON tu.f_useraddress_id = tua.id
         LEFT JOIN t_gasbrand tg ON tu.f_gasbrand_id = tg.id
         LEFT JOIN t_meterinfo m ON tu.f_meternumber = m.f_meternumber
         left join t_stairprice ts on ts.f_price_id = tu.f_price_id and tu.f_filialeids = ts.f_filialeids
WHERE tg.f_alias = '{f_meter_brand}'
  AND t.f_user_state = '正常'
  AND tu.f_table_state <> '停用'
  AND ts.f_state = '有效'
  AND m.f_meternumber is not null
  AND getdate() >= ts.f_perform_date
  AND getdate() <= ts.f_end_date
  AND (
        tu.f_sendsuccess <> '成功'
        OR tu.f_sendsuccess IS NULL
    )
