SELECT c.id                              sellid,
       u.f_user_id                       customer_code,
       abs(c.f_correct_money)            money,
       u.f_balance_amount                account_money,
       'CZ' + CONVERT(VARCHAR(20), c.id) cid,
       c.f_operator                      operator,
       c.f_correct_date                  charge_date,
       st.id                             stairprice_id,
       u.f_price_id                      price_id,
       u.f_userinfo_id                   f_userinfo_id,
       'correct'                         type,
       u.f_orgid
FROM t_correctrecord c
         LEFT JOIN t_userfiles u ON u.f_user_id = c.f_user_id
         LEFT JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
         LEFT JOIN T_SELLINGGAS se ON se.id = c.f_correct_id
         LEFT JOIN t_stairprice st ON st.f_price_id = u.f_price_id and u.f_filialeids = st.f_filialeids
WHERE (c.f_sendsuccess <> '成功' OR c.f_sendsuccess IS NULL)
  AND b.f_alias = '{f_meter_brand}'
  AND c.f_correct_state = '有效'
  AND c.f_correct_type = '物联网收费撤销'
  AND se.f_sendsuccess = '成功'
  AND se.f_charge_state = '冲正'
  AND st.f_state = '有效'
  AND getdate() >= st.f_perform_date
  AND getdate() <= st.f_end_date
