SELECT t_pricechange.id,
       u.f_user_id,
       u.f_price_id,
       s.id                        f_stairprice_id,
       isnull(s.f_stairmonths, 1)  f_stairmonths,
       t_pricechange.f_oldprice_id f_old_stairprice_id,
       u.f_meternumber
FROM t_pricechange
         INNER JOIN t_userfiles u ON u.f_userinfo_id = t_pricechange.f_userinfo_id
         LEFT JOIN t_gasbrand g ON u.F_GASBRAND_ID = g.ID
         LEFT JOIN t_stairprice s ON s.id = t_pricechange.f_newprice_id and u.f_orgid = s.f_orgid
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  and getdate() <= s.f_end_date
  AND s.f_sync_sendsuccess3 = '成功'
  AND (t_pricechange.F_SENDSUCCESS3 <> '成功' OR t_pricechange.F_SENDSUCCESS3 IS NULL)
  AND g.f_alias = '{f_meter_brand}'
  AND u.f_sendsuccess = '成功'
  AND t_pricechange.f_userinfo_id is not null
  AND t_pricechange.id =
      (SELECT MAX(ID) FROM t_pricechange p where p.f_userinfo_id = t_pricechange.f_userinfo_id)
ORDER BY t_pricechange.id DESC
