/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.DateTools;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.xq.JsonTools2;
import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.enums.RestCodeEnum;
import com.aote.webmeter.enums.TelecomApiEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.AuthenticationTools;
import com.aote.webmeter.tools.iot.NorthApiClientTools;
import com.iotplatform.client.NorthApiClient;
import com.iotplatform.client.NorthApiException;
import com.iotplatform.client.dto.CommandDTOV4;
import com.iotplatform.client.dto.DeviceCommandRespV4;
import com.iotplatform.client.dto.PostDeviceCommandInDTO2;
import com.iotplatform.client.dto.PostDeviceCommandOutDTO2;
import com.iotplatform.client.dto.QueryDeviceCommandInDTO2;
import com.iotplatform.client.dto.QueryDeviceCommandOutDTO2;
import com.iotplatform.client.invokeapi.SignalDelivery;
import com.iotplatform.utils.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignalDeliveryTools {
    private static final Logger LOGGER = Logger.getLogger(SignalDeliveryTools.class);
    private static final String ERROR_PARAMS_KEY = "error_code";

    public static JSONArray getCommandStatus(String deviceId) {
        QueryDeviceCommandOutDTO2 quid;
        SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
        QueryDeviceCommandInDTO2 acid = new QueryDeviceCommandInDTO2();
        acid.setDeviceId(deviceId);
        acid.setPageNo(Integer.valueOf(0));
        acid.setPageSize(Integer.valueOf(150));
        acid.setStartTime(DateTools.getDiffDate((String)"DATE", (String)"-2", (String)"yyyyMMdd'T'000000'Z'"));
        try {
            quid = sd.queryDeviceCommand(acid, AuthenticationTools.getAuthToken());
        }
        catch (NorthApiException e) {
            LOGGER.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
        JSONArray result = new JSONArray();
        for (DeviceCommandRespV4 command : quid.getData()) {
            JSONObject item = new JSONObject();
            item.put("commandId", (Object)command.getCommandId());
            item.put("status", (Object)command.getStatus());
            result.put((Object)item);
        }
        return result;
    }

    public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo, Integer expireTime) {
        PostDeviceCommandOutDTO2 pecos;
        SignalDelivery sd = new SignalDelivery();
        sd.setNorthApiClient(NorthApiClientTools.getNorthApiClient());
        PostDeviceCommandInDTO2 paid = new PostDeviceCommandInDTO2();
        paid.setDeviceId(deviceId);
        CommandDTOV4 aldo = new CommandDTOV4();
        aldo.setServiceId(serviceId);
        aldo.setMethod(method);
        try {
            aldo.setParas((Object)JsonUtil.convertObject2ObjectNode((Object)jo.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        paid.setCommand(aldo);
        if (expireTime != null) {
            paid.setExpireTime(expireTime);
        }
        paid.setCallbackUrl(WebMeterInfo.getString("telecomCallBackUrl"));
        long begin = System.currentTimeMillis();
        try {
            pecos = sd.postDeviceCommand(paid, WebMeterInfo.getString("telecomAPIKey"), AuthenticationTools.getAuthToken());
            long end = System.currentTimeMillis();
            LOGGER.warn((Object)("\u7535\u4fe1\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
        }
        catch (NorthApiException e) {
            LOGGER.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            long end = System.currentTimeMillis();
            LOGGER.warn((Object)("\u7535\u4fe1\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + (end - begin) + "ms"));
            return null;
        }
        JSONObject object = new JSONObject();
        object.put("commandId", (Object)pecos.getCommandId());
        object.put("appId", (Object)pecos.getAppId());
        object.put("deviceId", (Object)pecos.getDeviceId());
        object.put("callbackUrl", (Object)pecos.getCallbackUrl());
        object.put("status", (Object)pecos.getStatus());
        object.put("result", (Object)pecos.getResult());
        return object;
    }

    public static JSONObject postCommand(String serviceId, String method, String deviceId, JSONObject jo) {
        return SignalDeliveryTools.postCommand(serviceId, method, deviceId, jo, 0);
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo, Integer expireTime) throws IOException {
        String accessToken = AuthenticationTools.getAuthToken();
        String appId = WebMeterInfo.getString("telecomAPIKey");
        String callbackUrl = WebMeterInfo.getString("telecomCallBackUrl");
        Integer maxRetransmit = 3;
        HashMap<String, String> paramCommand = new HashMap<String, String>(3);
        paramCommand.put("serviceId", serviceId);
        paramCommand.put("method", method);
        paramCommand.put("paras", (String)jo);
        if (expireTime == null) {
            expireTime = 0;
        }
        JSONObject paramCreateDeviceCommand = new JSONObject();
        paramCreateDeviceCommand.put("deviceId", (Object)deviceId);
        paramCreateDeviceCommand.put("command", paramCommand);
        paramCreateDeviceCommand.put("callbackUrl", (Object)callbackUrl);
        paramCreateDeviceCommand.put("expireTime", (Object)expireTime);
        paramCreateDeviceCommand.put("maxRetransmit", (Object)maxRetransmit);
        JSONObject header = new JSONObject();
        header.put("app_key", (Object)appId);
        header.put("Authorization", (Object)("Bearer " + accessToken));
        header.put("Content-Type", (Object)"application/json");
        String responseBody = HttpConnectionPoolUtil.request((String)TelecomApiEnum.SEND_INSTRUCT_URL.getValue(), (String)paramCreateDeviceCommand.toString(), (String)header.toString(), (HttpEntityEnclosingRequestBase)new HttpPost(), (CloseableHttpClient)AuthenticationTools.getHttpClient());
        Map result = JsonTools2.jsonToMap((JSONObject)new JSONObject(responseBody));
        if (result.get(ERROR_PARAMS_KEY) != null) {
            throw new RuntimeException(responseBody);
        }
        return new JSONObject().put("commandId", result.get("commandId"));
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo) throws IOException {
        return SignalDeliveryTools.myPostCommand(serviceId, method, deviceId, jo, 0);
    }

    public static JSONObject postCommand(String method, String deviceId, String base64String) {
        return SignalDeliveryTools.postCommand(method, deviceId, base64String, 0);
    }

    public static JSONObject myPostCommand(String method, String deviceId, String base64String) throws IOException {
        return SignalDeliveryTools.myPostCommand(method, deviceId, base64String, 0);
    }

    public static JSONObject postCommand(String method, String deviceId, String base64String, Integer expireTime) {
        JSONObject object = new JSONObject();
        object.put("rawData", (Object)base64String);
        return SignalDeliveryTools.postCommand("RawData", method, deviceId, object, expireTime);
    }

    public static JSONObject myPostCommand(String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", (Object)base64String);
        return SignalDeliveryTools.myPostCommand("RawData", method, deviceId, object, expireTime);
    }

    public static JSONObject subscribe(NotifyTypeEnum notifyTypeEnum, String callBackUrl) {
        String accessToken = AuthenticationTools.getAuthToken();
        NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
        header.put("Authorization", "Bearer " + accessToken);
        JSONObject bodyParams = new JSONObject();
        bodyParams.put("notifyType", (Object)notifyTypeEnum.getValue());
        bodyParams.put("callbackUrl", (Object)callBackUrl);
        try {
            return (JSONObject)northApiClient.invokeAPI(TelecomApiEnum.SUBSCRIPTIONS_URL.getValue(), RestCodeEnum.POST.getValue(), null, bodyParams.toString(), header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
        }
        catch (NorthApiException e) {
            LOGGER.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }

    public static JSONObject deleteAllSubscribe() {
        String accessToken = AuthenticationTools.getAuthToken();
        NorthApiClient northApiClient = NorthApiClientTools.getNorthApiClient();
        HashMap<String, String> header = new HashMap<String, String>(16);
        header.put("app_key", WebMeterInfo.getString("telecomAPIKey"));
        header.put("Authorization", "Bearer " + accessToken);
        try {
            return (JSONObject)northApiClient.invokeAPI(TelecomApiEnum.SUBSCRIPTIONS_URL.getValue(), RestCodeEnum.DELETE.getValue(), null, null, header, null, null, ContentType.APPLICATION_JSON, null, JSONObject.class);
        }
        catch (NorthApiException e) {
            LOGGER.error((Object)"IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a", (Throwable)e);
            return null;
        }
    }
}

