/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.yinlingsystem;

import com.af.plugins.ConvertTools;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class YinLingSystemTools {
    public static Map<String, String> alarmType = new HashMap<String, String>();

    public static String getAlarmType(String key) {
        return alarmType.getOrDefault(key, key);
    }

    public static String genSerialNo() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String encodeMd5(String str) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getCause() + e.getMessage());
        }
        byte[] result = md.digest(str.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : result) {
            String tmp = StringUtils.leftPad((String)String.format("%X", b), (int)2, (char)'0');
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static String encodeString(String str) {
        String encodedStr = ConvertTools.base64Encode((byte[])str.getBytes(StandardCharsets.UTF_8));
        return encodedStr.trim();
    }

    public static String formatDate(String date) {
        return date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6);
    }

    public static String getUploadType(String str) {
        String uploadType;
        switch (str) {
            case "02": {
                uploadType = "\u624b\u52a8\u4e0a\u62a5";
                break;
            }
            case "01": {
                uploadType = "\u81ea\u52a8\u4e0a\u62a5";
                break;
            }
            case "07": {
                uploadType = "\u5f00\u6237\u4e0a\u62a5";
                break;
            }
            case "06": {
                uploadType = "\u547d\u4ee4\u4e0a\u62a5";
                break;
            }
            case "05": {
                uploadType = "\u62a5\u8b66\u4e0a\u62a5";
                break;
            }
            case "03": {
                uploadType = "\u4e0a\u7535\u4e0a\u62a5";
                break;
            }
            case "04": {
                uploadType = "\u6389\u7535\u4e0a\u62a5";
                break;
            }
            case "08": {
                uploadType = "\u8d2d\u6c14\u4e0a\u62a5";
                break;
            }
            case "09": {
                uploadType = "\u65ad\u7f51\u7eed\u4f20";
                break;
            }
            default: {
                uploadType = "\u5176\u4ed6\u4e0a\u62a5(" + str + ")";
            }
        }
        return uploadType;
    }

    static {
        alarmType.put("1001", "\u901a\u8baf\u5f02\u5e38");
        alarmType.put("1002", "\u71c3\u6c14\u6cc4\u9732");
        alarmType.put("1003", "\u5e72\u7c27\u7ba1\u574f");
        alarmType.put("1004", "\u5b58\u50a8\u5668\u574f");
        alarmType.put("1005", "\u5f3a\u78c1\u5e72\u6270");
        alarmType.put("1006", "\u6b7b\u8868\u6545\u969c");
        alarmType.put("1007", "\u9600\u95e8\u6f0f\u6c14");
        alarmType.put("1009", "\u7535\u6c60\u6545\u969c");
        alarmType.put("1010", "\u8fc7\u6d41\u62a5\u8b66");
        alarmType.put("1011", "\u6389\u7535 ");
        alarmType.put("2001", "\u5f3a\u884c\u5173\u9600");
        alarmType.put("2002", "\u53d6\u6d88\u5f3a\u5173");
        alarmType.put("2003", "\u9600\u95e8\u5f02\u5e38");
        alarmType.put("2004", "\u76f4\u8bfb\u5f02\u5e38");
        alarmType.put("3001", "\u6b20\u8d39\u63d0\u9192");
        alarmType.put("3002", "\u5145\u503c\u63d0\u9192(\u4e00\u7ea7)");
        alarmType.put("3003", "\u5145\u503c\u63d0\u9192(\u4e8c\u7ea7)");
        alarmType.put("3004", "\u5355\u4ef7\u4e3a0");
        alarmType.put("4001", "\u4f4e\u7535\u91cf\u62a5\u8b66");
        alarmType.put("4002", "\u5916\u90e8\u62a5\u8b66\u89e6\u53d1");
        alarmType.put("4003", "\u5916\u90e8\u6676\u632f\u505c\u6b62");
        alarmType.put("4004", "\u538b\u529b\u8d85\u4e0b\u9650");
        alarmType.put("4005", "\u538b\u529b\u8d85\u4e0a\u9650");
        alarmType.put("4006", "\u6e29\u5ea6\u8d85\u4e0b\u9650");
        alarmType.put("4007", "\u6e29\u5ea6\u8d85\u4e0a\u9650");
        alarmType.put("4008", "\u6d41\u91cf\u8d85\u4e0b\u9650");
        alarmType.put("4009", "\u6d41\u91cf\u8d85\u4e0a\u9650");
        alarmType.put("5001", "\u65f6\u949f\u5f02\u5e38");
        alarmType.put("5002", "\u8bfb\u6570\u5f02\u5e38\u53d8\u5c0f");
    }
}

