/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.module.cangnantcp;

import com.aote.util.other.RestTools;
import com.aote.webmeter.module.cangnantcp.CRCUtils;
import com.aote.webmeter.module.cangnantcp.HexUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class CangNanCommandHelper {
    private static final Logger log = Logger.getLogger(CangNanCommandHelper.class);
    private static final String COMPANY_CODE = "3219";
    private static final byte ADDR_CODE = 23;
    private static final byte REG_MSG = 83;
    private static final byte HEART_BEAT_MSG = -93;
    private static final byte RECAHRGE_RESPONSE_MSG_1 = 102;
    private static final byte RECAHRGE_RESPONSE_MSG_2 = -96;
    private static final byte PRICE_ADJUSTMENT_RESPONSE_MSG_1 = 102;
    private static final byte PRICE_ADJUSTMENT_RESPONSE_MSG_2 = -88;
    private static final byte CLOSE_VALVE_RESPONSE_MSG_1 = 102;
    private static final byte CLOSE_VALVE_RESPONSE_MSG_2 = -89;
    private static final byte READ_METER_RESPONSE_MSG_1 = 3;
    private static final byte READ_METER_RESPONSE_MSG_2 = -96;

    public static int decodeMsgType(String hexStr) {
        try {
            byte[] data = HexUtils.toBytes(hexStr);
            if (data[0] == 23 && data[1] == 83) {
                return 11;
            }
            if (data[0] == 23 && data[1] == -93) {
                return 12;
            }
            if (data[0] == 23 && data[1] == 102 && data[3] == -96) {
                return 21;
            }
            if (data[0] == 23 && data[1] == 102 && data[3] == -89) {
                return 31;
            }
            if (data[0] == 23 && data[1] == 3 && data[2] == -96) {
                return 41;
            }
            if (data[0] == 23 && data[1] == 102 && data[3] == -88) {
                return 51;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -999;
        }
        return -1;
    }

    public static String createRechargeCommand(String meterId, String cardId, BigDecimal gasValue, BigDecimal times) {
        log.debug((Object)"\u5f00\u59cb\u6784\u5efa\u3010\u5145\u503c\u3011\u6307\u4ee4......");
        byte[] command = new byte[48];
        byte[] data = new byte[46];
        data[0] = 23;
        data[1] = 102;
        data[2] = 0;
        data[3] = -96;
        data[4] = 41;
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10);
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        byte[] timesArr = CangNanCommandHelper.shortToByte2(times.shortValue());
        System.arraycopy(timesArr, 0, data, 28, 2);
        byte[] gasAmountArr = CangNanCommandHelper.intToByte4(gasValue.multiply(new BigDecimal("100")).intValue());
        System.arraycopy(gasAmountArr, 0, data, 30, 4);
        System.out.println(HexUtils.encodeHexStr(data));
        byte[] macSalt = new byte[]{44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 34, 8);
        byte[] calculateValue = new byte[29];
        System.arraycopy(data, 5, calculateValue, 0, 29);
        String macStr = CangNanCommandHelper.calculateMac(HexUtils.encodeHexStr(calculateValue));
        byte[] mac = HexUtils.str2Bcd(macStr);
        System.arraycopy(mac, 0, data, 42, 4);
        byte[] crc = HexUtils.toBytes(CRCUtils.getCrc(data));
        System.arraycopy(data, 0, command, 0, 46);
        System.arraycopy(crc, 0, command, 46, 2);
        log.debug((Object)("\u6700\u7ec8\u751f\u6210\u3010\u5145\u503c\u3011\u6307\u4ee4\uff1a" + HexUtils.encodeHexStr(command)));
        return HexUtils.encodeHexStr(command);
    }

    public static String createPriceAdjustCommand(String meterId, String cardId, BigDecimal stair1Price, BigDecimal stair1Amount, BigDecimal stair2Price, BigDecimal stair2Amount, BigDecimal stair3Price, BigDecimal stair3Amount, String cycleStartTime, String stairPriceCycleTime, int priceVersion) {
        log.debug((Object)"\u5f00\u59cb\u6784\u5efa\u3010\u8c03\u4ef7\u3011\u6307\u4ee4......");
        byte[] command = new byte[85];
        byte[] data = new byte[83];
        data[0] = 23;
        data[1] = 102;
        data[2] = 0;
        data[3] = -88;
        data[4] = 78;
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10);
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        return null;
    }

    public static String createValveCommand(String meterId, String cardId, BigDecimal valveCommand) {
        byte[] byArray;
        log.debug((Object)"\u5f00\u59cb\u6784\u5efa\u3010\u9600\u63a7\u3011\u6307\u4ee4......");
        byte[] command = new byte[43];
        byte[] data = new byte[41];
        data[0] = 23;
        data[1] = 102;
        data[2] = 0;
        data[3] = -89;
        data[4] = 36;
        meterId = String.format("%020d", Long.parseLong(meterId));
        byte[] dtuId = HexUtils.str2Bcd(meterId);
        System.arraycopy(dtuId, 0, data, 5, 10);
        cardId = String.format("%012d", Long.parseLong(cardId));
        byte[] cId = HexUtils.str2Bcd(cardId);
        System.arraycopy(cId, 0, data, 15, 6);
        byte[] companyCode = HexUtils.str2Bcd(COMPANY_CODE);
        System.arraycopy(companyCode, 0, data, 21, 2);
        if (valveCommand.shortValue() == 1) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        byte[] valveCmd = byArray;
        System.arraycopy(valveCmd, 0, data, 28, 1);
        byte[] macSalt = new byte[]{44, 27, 56, 74, 42, 68, 42, 34};
        System.arraycopy(macSalt, 0, data, 29, 8);
        byte[] calculateValue = new byte[24];
        System.arraycopy(data, 5, calculateValue, 0, 24);
        String macStr = CangNanCommandHelper.calculateMac(HexUtils.encodeHexStr(calculateValue));
        byte[] mac = HexUtils.str2Bcd(macStr);
        System.arraycopy(mac, 0, data, 37, 4);
        byte[] crc = HexUtils.toBytes(CRCUtils.getCrc(data));
        System.arraycopy(data, 0, command, 0, 41);
        System.arraycopy(crc, 0, command, 41, 2);
        log.debug((Object)("\u6700\u7ec8\u751f\u6210\u3010\u9600\u63a7\u3011\u6307\u4ee4\uff1a" + HexUtils.encodeHexStr(command)));
        return HexUtils.encodeHexStr(command);
    }

    public static String createMeterReadCommand() {
        byte[] command = new byte[]{23, 3, 2, 80, 0, 80, 70, -87};
        return HexUtils.encodeHexStr(command);
    }

    public static JSONObject decodeMsg(String msg) {
        int msgType = CangNanCommandHelper.decodeMsgType(msg);
        JSONObject obj = new JSONObject();
        if (msgType == 11 || msgType == 12) {
            String meterId = HexUtils.asciiHexStr2Str(msg.substring(8, 30));
            obj.put("meterId", (Object)meterId);
        }
        return obj;
    }

    public static JSONObject decodeAckMsg(String msg) {
        log.debug((Object)"\u5f00\u59cb\u89e3\u6790\u3010\u8868\u7aef\u54cd\u5e94\u3011\u6307\u4ee4......");
        int msgType = CangNanCommandHelper.decodeMsgType(msg);
        JSONObject obj = new JSONObject();
        if (msgType == 21 || msgType == 31) {
            String meterId = msg.substring(25, 36);
            String cardId = msg.substring(38, 48);
            int responseCode = Integer.parseInt(msg.substring(48, 50), 16);
            int surplusGas = Integer.parseInt(msg.substring(64, 72), 16);
            int meterTimes = Integer.parseInt(msg.substring(72, 76), 16);
            obj.put("meterId", (Object)meterId);
            obj.put("cardId", (Object)cardId);
            obj.put("responseCode", responseCode);
            obj.put("surplusGas", surplusGas);
            obj.put("meterTimes", meterTimes);
        } else if (msgType == 41) {
            CangNanCommandHelper.processMeterReadingData(msg);
            System.out.println();
        }
        log.debug((Object)("\u89e3\u6790\u7ed3\u679c: " + obj.toString()));
        return obj;
    }

    private static JSONObject processMeterReadingData(String msg) {
        msg = msg.substring(6);
        String sumLeftVolStr = msg.substring(0, 16);
        String sumUsedVolStr = msg.substring(16, 32);
        String sumBuyedVolStr = msg.substring(100, 116);
        String stateStr = msg.substring(116, 120);
        String alarmStr = msg.substring(120, 124);
        String meterTimeStr = msg.substring(124, 136);
        String cardIdStr = msg.substring(152, 168);
        String sumBuyedCountStr = msg.substring(168, 172);
        String sumUsedVolStr2 = msg.substring(172, 188);
        String lastBuyedVolStr = msg.substring(188, 196);
        String lastBuyedTimeStr = msg.substring(196, 208);
        String valveStateStr = msg.substring(252, 254);
        String overdraftState = CangNanCommandHelper.byteToBitString(new Byte(stateStr.substring(2))).substring(6, 7);
        String valveState = CangNanCommandHelper.byteToBitString(new Byte(stateStr.substring(2))).substring(7, 7);
        return null;
    }

    public static String byteToBitString(byte b) {
        return "" + (byte)(b >> 7 & 1) + (byte)(b >> 6 & 1) + (byte)(b >> 5 & 1) + (byte)(b >> 4 & 1) + (byte)(b >> 3 & 1) + (byte)(b >> 2 & 1) + (byte)(b >> 1 & 1) + (byte)(b >> 0 & 1);
    }

    private static String calculateMac(String value) {
        return RestTools.post((String)"", (String)value).substring(1, 9);
    }

    private static byte[] shortToByte2(int s) {
        byte[] targets = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return targets;
    }

    private static byte[] intToByte4(int i) {
        byte[] targets = new byte[4];
        targets[3] = (byte)(i & 0xFF);
        targets[2] = (byte)(i >> 8 & 0xFF);
        targets[1] = (byte)(i >> 16 & 0xFF);
        targets[0] = (byte)(i >> 24 & 0xFF);
        return targets;
    }

    private static byte[] intToByte2(int i) {
        byte[] targets = new byte[2];
        targets[1] = (byte)(i & 0xFF);
        targets[0] = (byte)(i >> 8 & 0xFF);
        return targets;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(CangNanCommandHelper.intToByte2(350)));
    }
}

