package com.aote.webmeter.server.tcp;

import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/**
 * TCP服务监听器
 *
 * @author Mrriver
 * @date 2019/2/11
 */
public class TcpListener implements ServletContextListener {
    private TcpServer[] tcpServers;

    /**
     * 配置文件路径
     */
    private static final String PATH = "config/server/TCPListenerConfig.json";

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        //读取Tcp配置文件
        if (TcpListener.class.getClassLoader().getResourceAsStream(PATH) != null) {
            JSONObject params = JsonTools.readJsonFile(PATH);
            //读取Logic名
            String logicName = params.getString("callBackName");
            //读取Tcp端口信息
            JSONArray ports = params.getJSONArray("tcpPort");
            tcpServers = new TcpServer[ports.length()];
            LogicServer service = WebApplicationContextUtils.
                    getWebApplicationContext(sce.getServletContext()).getBean(LogicServer.class);
            //读取TCP接收消息格式
            String msgReceiveType = params.getString("msgReceiveType");
            //读取TCP发送消息格式
            String msgSendType = params.getString("msgSendType");
            for (int i = 0; i < ports.length(); i++) {
                TcpServer tcpServer = new TcpServer(
                        logicName,
                        ports.getInt(i),
                        service,
                        MsgTypeEnum.toType(msgReceiveType),
                        MsgTypeEnum.toType(msgSendType)
                );
                //放入Tcp服务器数组
                tcpServers[i] = tcpServer;
            }
        }
        for (TcpServer tcpServer : tcpServers) {
            //启动TcpServer
            tcpServer.start();
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        for (TcpServer tcpServer : tcpServers) {
            if (tcpServer != null && tcpServer.isInterrupted()) {
                //销毁TcpServer
                tcpServer.interrupt();
            }
        }
    }
}
