package com.aote.webmeter.module.weixintcp;

import com.af.plugins.ConvertTools;
import com.viewshine.codec.Commerce30;
import com.viewshine.codec.DecodeResult;
import com.viewshine.codec.engine.CodecDataItem;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Map;

/**
 * 威星TCP对接兼容工具
 * @author Mrriver
 */
public class WeiXinTcpTools {
    public static byte[] RestoreMeter(String meterCode, String meterType, Boolean haveNextCmd) {
        return Commerce30.RestoreMeter(meterCode,meterType,haveNextCmd);
    }

    public static byte[] SetPriceModel(String meterCode, String meterType, Map<String,String> params, Boolean haveNextCmd) {
        return Commerce30.SetPriceModel(meterCode,meterType,params,haveNextCmd);
    }

    public static byte[] ValveControl(String meterCode, String meterType, Map<String,String> params, Boolean haveNextCmd) {
        return Commerce30.ValveControl(meterCode,meterType,params,haveNextCmd);
    }

    public static byte[] Recharge(String meterCode, String meterType, Map<String,String> params, Boolean haveNextCmd) {
        return Commerce30.Recharge(meterCode,meterType,params,haveNextCmd);
    }

    public static byte[] SetCycleGasVolume(String meterCode, String meterType, Map<String,String> params, Boolean haveNextCmd) {
        return Commerce30.SetCycleGasVolume(meterCode,meterType,params,haveNextCmd);
    }

    public static JSONObject Decode(byte[] msg, Boolean haveNextCmd) {
        DecodeResult docodeResult = Commerce30.Decode(msg,haveNextCmd);
        JSONArray array = new JSONArray();
        if (docodeResult.getDataItems() != null){
            for(CodecDataItem codecDataItem : docodeResult.getDataItems()){
                array.put(com.alibaba.fastjson.JSONObject.toJSONString(codecDataItem));
            }
        }
        JSONObject object = new JSONObject();
        object.put("isSuccess",docodeResult.isSuccess());
        object.put("errCode",docodeResult.getErrCode());
        object.put("errMsg",docodeResult.getErrMsg());
        object.put("meterCode",docodeResult.getMeterCode());
        object.put("cmdCode",docodeResult.getCmdCode());
        object.put("cmdName",docodeResult.getCmdName());
        object.put("time",docodeResult.getTime());
        object.put("meterType",docodeResult.getMeterType());
        object.put("dataItems",array);
        object.put("cmdable",docodeResult.isCmdable());
        object.put("echoData",docodeResult.getEchoData());
        return object;
    }

    public static JSONObject getParams(JSONArray params){
        JSONObject object = new JSONObject();
        for(Object obj : params){
            JSONObject jo = new JSONObject(String.valueOf(obj));
            String result = null;
            if (jo.has("value")){
                result = jo.getString("value");
            }
            object.put("param"+jo.getString("code"),result);
        }
        return object;
    }

    public static String base64Encode(byte[] bytes) {
        return ConvertTools.base64Encode(bytes);
    }

    public static String base64Encode(String result) {
        return "00";
    }
}
