package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.aote.webmeter.enums.ModuleEnum;
import org.apache.log4j.Logger;
import org.json.JSONObject;

/**
 * 物联网表指令-逻辑映射工具（V1.2）
 * 指令-逻辑映射配置：mainInstructs.json
 * @author Mrriver
 * @date 2020/6/18
 */
public class GetInstructsTools {
    private static final Logger LOGGER = Logger.getLogger(GetInstructsTools.class);
    /**
     * 指令-逻辑映射配置路径
     */
    private static final String CONFIG_URL = "webmeter/mainInstructs.json";
    /**
     * 指令-逻辑映射列表
     */
    private static final JSONObject INSTRUCT_LIST;

    static {
        if (GetInstructsTools.class.getClassLoader().getResourceAsStream(CONFIG_URL) != null){
            INSTRUCT_LIST = JsonTools.readJsonFile(CONFIG_URL);
            LOGGER.debug("加载指令-逻辑映射配置文件完成");
        } else {
            throw new RuntimeException("缺少指令-逻辑映射配置文件：mainInstructs.json");
        }
    }

    /**
     * 获取指令-业务逻辑名
     * @param instructName 指令中文名
     * @return 业务逻辑名
     */
    public String getInstruct(String instructName) {
        if (INSTRUCT_LIST.has(instructName)){
            String moduleName = WebMeterInfo.getModuleName();
            //如果是公共模块，代表测试用
            if(ModuleEnum.toType(moduleName) == ModuleEnum.PUBLIC_MODULE){
                return "debug";
            }
            String logicName = INSTRUCT_LIST.getString(instructName);
            return moduleName + logicName;
        } else {
            throw new RuntimeException("未映射名为【"+instructName+"】的指令");
        }
    }
}
