package com.aote.webmeter.module.weisidaflowmeter;

import com.af.plugins.CommonTools;
import com.yd.entity.Command;
import com.yd.resolver.ValveResolver;
import com.yd.utils.DataUtils;
import com.yd.utils.HexStringUtils;
import com.yd.utils.ModBusUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Map;

public class Tool {
    public static String getSetLakeCode(String value) {
        int temp = 0;
        try {
            temp = Integer.parseInt(value);
            if (temp <= 0) {
                return "0000";
            }

            String s = String.format("%4s", Integer.toHexString(temp));
            return s.replace(' ', '0');
        } catch (Exception e) {
            return "0000";
        }
    }

    public static String getSetTimeCode(String version, String value) {
        String ret;

        String hour = value.substring(0, 2);
        Integer iHour = Integer.parseInt(hour);
        String minute = value.substring(2, 4);
        int iMinute = Integer.parseInt(minute);
        hour = String.format("%2s", Integer.toHexString(iHour));
        hour = hour.replace(' ', '0');
        minute = String.format("%2s", Integer.toHexString(iMinute));
        minute = minute.replace(' ', '0');
        if ("3".equals(version)) {
            ret = hour + minute;
        } else {
            ret = minute + hour;
        }
        return ret;
    }


    /**
     * 获取增加CRC校验码之后的命令
     *
     * @param command
     * @return
     */
    public String getCRC(String command) {
        return HexStringUtils.bytesToHexString(ModBusUtils.getData(HexStringUtils.hexStringToBytes(command)));
    }

    public static JSONObject resolve(String name, String Response) throws Exception {
        Command command = new Command();
        command.setName(name);
        command.setResponse(Response);
        ValveResolver vResolver = new ValveResolver();
        Map<String, Object> map = vResolver.resolve(command);
        JSONObject jsonObject = new JSONObject(map);

        if ("query_coil_status".equals(name)) {
            String temp = jsonObject.getString("battery");
            jsonObject.put("inner_battery", temp.substring(temp.indexOf("：") + 1, temp.indexOf(";")));
            jsonObject.put("outer_battery", temp.substring(temp.lastIndexOf("：") + 1));
        }
        return jsonObject;
    }

    public static JSONObject resolveUpData(String data) throws Exception {
        Map<String, Object> result;
        if (data != null && data.length() == 52) {
            result = DataUtils.resolveUpData(data);
        } else if (data != null && data.length() >= 84) {
            result = DataUtils.resolveUpDataNew(data);
        } else {
            result = null;
        }
        return new JSONObject(result);
    }

    public JSONObject resolveValveStatus(String temp) {
        JSONObject jsonObject = new JSONObject();
        if (temp == null || "".equals(temp)) {
            jsonObject.put("inner_battery", "normal");
            jsonObject.put("outer_battery", "normal");
            return jsonObject;
        }
        jsonObject.put("inner_battery", temp.substring(temp.indexOf("：") + 1, temp.indexOf(";")));
        jsonObject.put("outer_battery", temp.substring(temp.lastIndexOf("：") + 1));
        return jsonObject;
    }

    /**
     * 解析24小时用气量指令
     *
     * @param response
     * @return
     */
    public static String resolveHourGas(String response) {
        response = response.replaceAll(" ", "");
        if (response == null) {
            return "";
        }
        if (response.length() != 106) {
            return "";
        }

        JSONArray jsonArray = new JSONArray();
        response.substring(2, 4);
        for (int i = 0; i < 24; i++) {
            jsonArray.put(CommonTools.div(Integer.parseInt(response.substring(i * 4 + 6, i * 4 + 10), 16), 100));
        }
        return jsonArray.toString();
    }

    /**
     * 金额乘100，转化为16进制，长度8位
     *
     * @param dec
     * @return
     */
    public static String getHex8Money(String dec) {
        double money = Double.parseDouble(dec);
        if (money <= 0.0) {
            return "00000000";
        }
        long moneyI = (long) (money * 100);
        if(moneyI > 4294967295L){
            return "ffffffff";
        }
        String s = String.format("%8s",Long.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    public static String getHex8MoneyOverdraft(String dec) {
        double money = Double.parseDouble(dec);
        if (money < 0.0) {
            money = money * -1;
        } else {
            return "00000000";
        }
        long moneyI = (long) (money * 100);
        if(moneyI > 4294967295L){
            return "ffffffff";
        }
        String s = String.format("%8s", Long.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    public static String getHex12Money(String dec) {
        double money = Double.parseDouble(dec);
        if (money <= 0.0) {
            return "000000000000";
        }
        long moneyI = (long) (money * 100);
        if(moneyI >= 281474976710655L){
            return "FFFFFFFFFFFF";
        }
        String s = String.format("%12s", Long.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    /**
     * 金额乘100，转化为16进制，长度4位
     *
     * @param dec
     * @return
     */
    public String getHex4Money(String dec) {
        double money = Double.parseDouble(dec);
        int moneyI = (int) (money * 100);
        String s = String.format("%4s", Integer.toHexString(moneyI));
        return s.replace(' ', '0');
    }

    /**
     * @param day 几号
     * @return
     */
    public static String getCode(int day) {
        return getStartAddr(day) + "0002";
    }

    private static String getStartAddr(int day) {
        if (day == 0) {
            return "00cf";
        } else if (day > 0 && day <= 30) {
            int value = day * 2 + 205;
            String ret = String.format("%4s", Integer.toHexString(value));
            return ret.replace(' ', '0');
        } else {
            return "0000";
        }
    }

    public static void main(String[] args) {
        System.out.println(getHex8Money("900000000"));
        System.out.println(getHex12Money("900000000"));
    }


}
