package com.aote.webmeter.tools;

import org.json.JSONObject;

/**
 * 物联网表-营收业务兼容性组件
 * @author 物联网表小组
 */
public class CompatTools {

    /**
     * 获取查询表具信息的基础条件表达式
     * @param userId 表档案ID
     * @return 条件表达式
     */
    public static String getBasicCondition(Object userId) {
        String userIdValue = String.valueOf(userId);
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V1:
            case Vue_V2:
                return "t_userfiles.f_user_id = '"+ userIdValue +"'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "t_userfiles.id = '"+ userIdValue +"'";
            case Vue_V3:
            default:
                return "t_userfiles.f_userfiles_id = '"+ userIdValue +"'";
        }
    }

    /**
     * 获取查询表具信息的基础条件表达式
     * @param object 含有表档案原始ID的查询结果
     * @return 条件表达式
     */
    public static String getBasicCondition(JSONObject object){
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V1:
            case Vue_V2:
                return "t_userfiles.f_user_id = '"+ object.getString("f_user_id") +"'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "t_userfiles.id = '"+ object.getString("f_user_id") +"'";
            case Vue_V3:
            default:
                return "t_userfiles.f_userfiles_id = '"+ object.getString("f_userfiles_id") +"'";
        }
    }

    /**
     * 获取更新换表记录的SQL语句
     * @param id 换表记录ID
     * @return SQL语句
     */
    public static String getUpdateChangeMeterSql(Object id){
        String idValue = String.valueOf(id);
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V1:
            case Vue_V2:
                return "update t_changemeter set f_sendsuccess = '成功' where id = '"+idValue+"'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "update t_changmeter set f_sendsuccess = '成功' where id = '"+idValue+"'";
            case Vue_V3:
            default:
                return "update t_changetables set f_sendsuccess = '成功' where id = '"+idValue+"'";
        }
    }

    /**
     * 获取更新调价记录的SQL语句
     * @param id 调价记录ID
     * @return SQL语句
     */
    public static String getUpdateSetPriceMeterSql(Object id){
        String idValue = String.valueOf(id);
        switch (WebMeterInfo.getSaleNameEnum()){
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "UPDATE t_changestairprice SET f_sendsuccess = '成功' where id = '"+ idValue +"'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            default:
                return "UPDATE t_pricechange SET f_sendsuccess = '成功' WHERE id = '"+ idValue +"'";
        }
    }

    /**
     * 获取更新换表补气记录的SQL语句
     * @param id 换表补气记录ID
     * @return SQL语句
     */
    public static String getUpdateSupplyGasMeterSql(Object id){
        String idValue = String.valueOf(id);
        switch (WebMeterInfo.getSaleNameEnum()){
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "UPDATE t_changmeter SET f_isSupplyGas = '成功' WHERE id = '"+ idValue +"'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            default:
                return "UPDATE t_fillgas SET f_sendsuccess = '成功' WHERE id = '"+ idValue +"'";
        }
    }

    /**
     * 获取更新补费扣费记录的SQL语句
     * @param id 换表补气记录ID
     * @return SQL语句
     */
    public static String getUpdateAdjustMoneyMeterSql(Object id){
        String idValue = String.valueOf(id);
        switch (WebMeterInfo.getSaleNameEnum()){
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "update t_cbgas set f_sendsuccess = '成功' where id = '"+ idValue +"'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            default:
                return "UPDATE t_fillgas SET f_sendsuccess = '成功' WHERE id = '"+ idValue +"'";
        }
    }

    /**
     * 获取更新表档案的SQL语句
     * @param userId 表档案ID
     * @param isOpenAccount 是否开户
     * @return SQL语句
     */
    public static String getUpdateUserFilesSql(Object userId, Boolean isOpenAccount){
        String userIdValue = String.valueOf(userId);
        String type;
        if(isOpenAccount) {
            type = "f_sendsuccess = '成功'";
        } else {
            type = "f_sendsuccess = null";
        }
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V1:
            case Vue_V2:
                return "update t_userfiles set "+ type +" where f_user_id = '"+ userIdValue +"'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "update t_userfiles set "+ type +" where id = '"+ userIdValue +"'";
            case Vue_V3:
            default:
                return "update t_userfiles set "+ type +" where f_userfiles_id = '"+ userIdValue +"'";
        }
    }

    /**
     * 获取指令表名称
     * @return 指令表名称
     */
    public static String getInstructTableName(){
        switch (WebMeterInfo.getSaleNameEnum()){
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "t_webmeter_instruct";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            default:
                return "t_instruct";
        }
    }

    /**
     * 获取表档案主键字段名
     * @return 表档案主键字段名
     */
    public static String getUserFilesId(){
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V3:
                return "f_userfiles_id";
            case Vue_V1:
            case Vue_V2:
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
            default:
                return "f_user_id";
        }
    }

    /**
     * 获取表档案主键原始字段名
     * @return 表档案主键原始字段名
     */
    public static String getOriginalUserFilesId(){
        switch (WebMeterInfo.getSaleNameEnum()){
            case Vue_V3:
                return "f_userfiles_id";
            case Vue_V1:
            case Vue_V2:
                return "f_user_id";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
            default:
                return "id";
        }
    }

    /**
     * 根据表号及表状态获取指定查询列表具信息的Query参数JSON
     *
     * @param columns 查询列 默认：表号(f_meternumber),表档案ID(userid)
     * @param meterNumber 表号
     * @param tableState 表状态 默认：正常
     * @return 适用于SQL@webmeterGetBaseData的Query参数JSON
     */
    public static JSONObject getMeterInfoCondition(String columns,Object meterNumber, String tableState) {
        JSONObject result = new JSONObject();
        result.put("items",columns);
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
                result.put("tableName","t_userfiles");
                result.put("condition", "t_userfiles.f_meternumber = '" + meterNumber + "' " +
                        "and t_userfiles.f_userstate = '" + tableState + "'");
                break;
            case SILVER_LIGHT2:
                result.put("tableName","t_userfiles,t_userinfo");
                result.put("condition", "t_userfiles.f_meternumber = '" + meterNumber + "' " +
                        "and t_userinfo.f_userstate = '" + tableState + "' "+
                        "and t_userfiles.f_userid = t_userinfo.f_userinfoid");
                break;
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            default:
                result.put("tableName","t_userfiles");
                result.put("condition","t_userfiles.f_meternumber = '" + meterNumber + "' " +
                        "and t_userfiles.f_table_state = '" + tableState + "'");
                break;
        }
        return result;
    }
    public static JSONObject getMeterInfoCondition(Object meterNumber, String tableState) {
        String columns = String.format("t_userfiles.f_meternumber,t_userfiles.%s userid",
                CompatTools.getOriginalUserFilesId());
        return getMeterInfoCondition(columns, meterNumber, tableState);
    }
    public static JSONObject getMeterInfoCondition(Object meterNumber) {
        return getMeterInfoCondition(meterNumber, "正常");
    }

    /**
     * 获取组织机构字段名称
     */
    public static String getOrganColumnName() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1:
            case Vue_V2:
                return "f_filialeids";
            case Vue_V3:
                return "f_filialeid";
            default:
                return null;
        }
    }

    /**
     * 根据预定义名称获取通用资源映射名称
     *
     * @param resName  资源预定义名称
     * @param baseType -1：非通用版本，0：Vue或银光的局部通用版本，1：全局通用版本,默认-1
     * @return 通用资源映射名称
     */
    public static String getResName(String resName, Integer baseType) {
        if (baseType == 0) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT:
                case SILVER_LIGHT2:
                    return resName + "SL";
                default:
                    return resName + "Vue";
            }
        } else if (baseType == -1) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT:
                    return resName + "SL1";
                case SILVER_LIGHT2:
                    return resName + "SL2";
                case Vue_V1:
                    return resName + "VueV1";
                case Vue_V2:
                    return resName + "VueV2";
                case Vue_V3:
                    return resName + "VueV3";
                default:
                    return null;
            }
        } else {
            return resName;
        }
    }

    public static String getResName(String resName) {
        return getResName(resName, -1);
    }
}
