package com.aote.webmeter.module.lanbaoshinewsystem;

import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.module.qinchuan.Encryption;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

/**
 * 蓝宝石工具类
 *
 * @author 马栋梁
 */
public class Tools {


    @Autowired
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(Tools.class);

    /**
     * 过期时间
     */
    private Date expirationTime = null;
    /**
     * 秘钥
     */
    private String token;

    /**
     * 秘钥是否有效
     */
    public boolean isToken() {
        return expirationTime != null && expirationTime.compareTo(DateTools.getNow()) > 0;
    }

    /**
     * 初始化秘钥信息
     */
    public boolean initToken(String url, String loginName, String pwd, JSONObject header) {
        JSONObject object = null;
        JSONObject content = new JSONObject();
        try {
            content.put("loginName", loginName);
            content.put("pwd", Encryption.MD5Encryption(pwd));
            String s = RestTools.post(url + "?loginName=" + loginName + "&pwd=" + Encryption.MD5Encryption(pwd), content, header);
            object = JsonTools.convertToJson(s);
            if ("success".equals(object.getString("State"))) {
                JSONObject data = object.getJSONObject("Data");
                String expiration = data.getString("expiration");
                expiration = expiration.substring(0, expiration.lastIndexOf('.'));
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                long time = formatter.parse(expiration).getTime();
                expirationTime = new Date(time);
                token = data.getString("token");
                return true;
            } else {
                logger.warn(object);
                return false;
            }
        } catch (Throwable e) {
            logger.error("加载Token过程中出现未知错误，请及时联系管理员处理。");
            logger.error("URL");
            logger.error(url + "?loginName=" + loginName + "&pwd=" + Encryption.MD5Encryption(pwd));
            logger.error("Header");
            logger.error(header);
            logger.error("Content");
            logger.error(content);
            if (object != null) {
                logger.error("接口返回消息:" + object);
            }
            return false;
        }

    }

    public String formatDate(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date creationTime = formatter.parse(date);
            return formatter.format(creationTime);
        } catch (ParseException e) {
            e.printStackTrace();
            return date;
        }
    }

    public JSONObject sendInstruct(String url, JSONObject header, JSONObject content) {
        try {
            String instructResult = RestTools.post(url, content, header);
            JSONObject ret = JsonTools.convertToJson(instructResult);
            return ret;
        } catch (Throwable e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("State", "fail");
            jsonObject.put("Message", "接口请求发生异常");
            jsonObject.put("Data", "");
            return jsonObject;
        }
    }

    public JSONObject formatPriceDetails(JSONArray prices) {
        Double[] retPrices = new Double[5];
        Integer[] retGas = new Integer[5];
        retPrices[0] = 1.0;
        retGas[0] = 65535;
        for (int i = 0; i < prices.length(); i++) {
            retPrices[i] = prices.getJSONObject(i).getDouble("f_price");
            retGas[i] = prices.getJSONObject(i).getInt("f_gas");
        }
        for (int i = prices.length() == 0 ? 1 : prices.length(); i < retPrices.length; i++) {
            retPrices[i] = retPrices[i - 1];
            retGas[i] = retGas[i - 1];
        }
        JSONObject ret = new JSONObject();
        for (int i = 0; i < retPrices.length; i++) {
            ret.put("price" + (i + 1), retPrices[i]);
            ret.put("gas" + (i + 1), retGas[i]);
        }
        return ret;
    }

    public String getCtrlTimeout(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date creationTime = formatter.parse(date);
            Calendar c = Calendar.getInstance();
            c.setTime(creationTime);
            c.add(Calendar.DAY_OF_MONTH, 3);
            return formatter.format(c.getTime());
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }

    }

    public String genCommandId() {
        StringBuffer str = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < 10; i++) {
            str.append(random.nextInt(10));
        }
        return str.toString();
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
