package com.aote.webmeter.tools.stair;

import com.aote.webmeter.tools.Util;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.NumberFormat;

/**
 * 银光阶梯气价计算插件
 *
 * @author 兼容
 */
public class StairComputeTools {

	private static final String STAIR_TYPE_COLUMN = "f_stairtype";
	private static final String NORMAL_STAIR_TYPE = "未设";

	/**
	 * 传入参数:(每档气价,每档限购气量,阶梯月数), 时间段内的累计气量, 本次购气量
	 * return:每档购气量,每档金额
	 */
	public JSONObject compute(JSONObject stairInfo, BigDecimal sumAmount, BigDecimal gas) {
		// 计算阶梯气价的中间结果(每档购气量和每档金额)
		BigDecimal stair1num = new BigDecimal(0);
		BigDecimal stair2num = new BigDecimal(0);
		BigDecimal stair3num = new BigDecimal(0);
		BigDecimal stair4num = new BigDecimal(0);
		BigDecimal stair1fee = new BigDecimal(0);
		BigDecimal stair2fee = new BigDecimal(0);
		BigDecimal stair3fee = new BigDecimal(0);
		BigDecimal stair4fee = new BigDecimal(0);
		// 总金额
		BigDecimal chargenum = new BigDecimal(0);

		BigDecimal stair1price = BigDecimal.valueOf(stairInfo.getDouble("f_stair1price"));
		BigDecimal stair1amount = BigDecimal.valueOf(stairInfo.getDouble("f_stair1amount"));
		BigDecimal stair2price;
		BigDecimal stair2amount;
		BigDecimal stair3price;
		BigDecimal stair3amount;
		BigDecimal stair4price;
		if(stairInfo.has("f_stair2price")){
			stair2price = BigDecimal.valueOf(stairInfo.getDouble("f_stair2price"));
			stair2amount = BigDecimal.valueOf(stairInfo.getDouble("f_stair2amount"));
			if(stairInfo.has("f_stair3price")){
				stair3price = BigDecimal.valueOf(stairInfo.getDouble("f_stair3price"));
				stair3amount = BigDecimal.valueOf(stairInfo.getDouble("f_stair3amount"));
				if(stairInfo.has("f_stair4price")){
					stair4price = BigDecimal.valueOf(stairInfo.getDouble("f_stair4price"));
				} else {
					stair4price = stair3price;
				}
			} else {
				stair3price = stair2price;
				stair3amount = stair2amount;
				stair4price = stair2price;
			}
		} else {
			stair2price = stair1price;
			stair2amount = stair1amount;
			stair3price = stair1price;
			stair3amount = stair1amount;
			stair4price = stair1price;
		}

		// 针对设置阶梯气价的用户运算
		if (!stairInfo.getString(STAIR_TYPE_COLUMN).equals(NORMAL_STAIR_TYPE)) {
			// 累计购气量
			BigDecimal allAmount = sumAmount.add(gas);
			// 当前购气量在第一阶梯
			if (sumAmount.compareTo(stair1amount) < 0) {
				if (allAmount.compareTo(stair1amount) < 0) {
					stair1num = gas;
					stair1fee = gas.multiply(stair1price);
					chargenum = gas.multiply(stair1price);
				} else if (allAmount.compareTo(stair1amount) >= 0 && allAmount.compareTo(stair2amount) < 0) {
					stair1num = stair1amount.subtract(sumAmount);
					stair1fee = (stair1amount.subtract(sumAmount)).multiply(stair1price);
					stair2num = allAmount.subtract(stair1amount);
					stair2fee = (allAmount.subtract(stair1amount)).multiply(stair2price);
					chargenum = stair1fee.add(stair2fee);
				} else if (allAmount.compareTo(stair2amount) >= 0 && allAmount.compareTo(stair3amount) < 0) {
					stair1num = stair1amount.subtract(sumAmount);
					stair1fee = (stair1amount.subtract(sumAmount)).multiply(stair1price);
					stair2num = stair2amount.subtract(stair1amount);
					stair2fee = (stair2amount.subtract(stair1amount)).multiply(stair2price);
					stair3num = allAmount.subtract(stair2amount);
					stair3fee = (allAmount.subtract(stair2amount)).multiply(stair3price);
					chargenum = stair1fee.add(stair2fee).add(stair3fee);
				} else if (allAmount.compareTo(stair3amount) >= 0) {
					stair1num = stair1amount.subtract(sumAmount);
					stair1fee = (stair1amount.subtract(sumAmount)).multiply(stair1price);
					stair2num = stair2amount.subtract(stair1amount);
					stair2fee = (stair2amount.subtract(stair1amount)).multiply(stair2price);
					stair3num = stair3amount.subtract(stair2amount);
					stair3fee = (stair3amount.subtract(stair2amount)).multiply(stair3price);
					stair4num = allAmount.subtract(stair3amount);
					stair4fee = (allAmount.subtract(stair3amount)).multiply(stair4price);
					chargenum = stair1fee.add(stair2fee).add(stair3fee).add(stair4fee);
				}
				// 当前已购气量在阶梯二内
			} else if (sumAmount.compareTo(stair1amount) >= 0 && sumAmount.compareTo(stair2amount) < 0) {
				if (allAmount.compareTo(stair2amount) < 0) {
					stair2num = gas;
					stair2fee = gas.multiply(stair2price);
					chargenum = stair2fee;
				} else if (allAmount.compareTo(stair2amount) >= 0 && allAmount.compareTo(stair3amount) < 0) {
					stair2num = stair2amount.subtract(sumAmount);
					stair2fee = (stair2amount.subtract(sumAmount)).multiply(stair2price);
					stair3num = allAmount.subtract(stair2amount);
					stair3fee = (allAmount.subtract(stair2amount)).multiply(stair3price);
					chargenum = stair2fee.add(stair3fee);
				} else {
					stair2num = stair2amount.subtract(sumAmount);
					stair2fee = (stair2amount.subtract(sumAmount)).multiply(stair2price);
					stair3num = stair3amount.subtract(stair2amount);
					stair3fee = (stair3amount.subtract(stair2amount)).multiply(stair3price);
					stair4num = allAmount.subtract(stair3amount);
					stair4fee = (allAmount.subtract(stair3amount)).multiply(stair4price);
					chargenum = stair2fee.add(stair3fee).add(stair4fee);
				}
				// 当前已购气量在阶梯三内
			} else if (sumAmount.compareTo(stair2amount) >= 0 && sumAmount.compareTo(stair3amount) < 0) {
				if (allAmount.compareTo(stair3amount) < 0) {
					stair3num = gas;
					stair3fee = gas.multiply(stair3price);
					chargenum = stair3fee;
				} else {
					stair3num = stair3amount.subtract(sumAmount);
					stair3fee = (stair3amount.subtract(sumAmount)).multiply(stair3price);
					stair4num = allAmount.subtract(stair3amount);
					stair4fee = (allAmount.subtract(stair3amount)).multiply(stair4price);
					chargenum = stair3fee.add(stair4fee);
				}
				// 当前已购气量超过阶梯三
			} else if (sumAmount.compareTo(stair3amount) >= 0) {
				stair4num = gas;
				stair4fee = gas.multiply(stair4price);
				chargenum = stair4fee;
			}
			// 该用户未设置阶梯气价
		} else {
			BigDecimal gasPrice;
			// 当f_stairtype为"未设"时的的气价
			if (stairInfo.has("f_gasprice")) {
				gasPrice = Util.convertBigDecimal(stairInfo.get("f_gasprice"));
			} else {
				gasPrice = Util.convertBigDecimal(stairInfo.get("f_stair1price"));
			}
			chargenum = gas.multiply(gasPrice);
			stair1num = new BigDecimal(0);
			stair2num = new BigDecimal(0);
			stair3num = new BigDecimal(0);
			stair4num = new BigDecimal(0);
			stair1fee = new BigDecimal(0);
			stair2fee = new BigDecimal(0);
			stair3fee = new BigDecimal(0);
			stair4fee = new BigDecimal(0);
		}
		JSONObject jo = new JSONObject();
		jo.put("stair1num", stair1num);
		jo.put("stair1fee", stair1fee);
		jo.put("stair2num", stair2num);
		jo.put("stair2fee", stair2fee);
		jo.put("stair3num", stair3num);
		jo.put("stair3fee", stair3fee);
		jo.put("stair4num", stair4num);
		jo.put("stair4fee", stair4fee);
		NumberFormat nf = NumberFormat.getInstance();
		nf.setGroupingUsed(false);
		nf.setMinimumFractionDigits(2);
		nf.setMaximumFractionDigits(8);
		String scoreStr = nf.format(chargenum.doubleValue());
		jo.put("chargenum", Double.valueOf(scoreStr));
		return jo;
	}
}
