package com.aote.webmeter.tools;

import com.aote.module.ModuleMapper;
import com.aote.redis.RedisUtil;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import java.util.Map;

/**
 * Redis物联网表数据初始化工具（V1.0）
 *
 * @author Mrriver
 * @date 2019/07/03
 */

@Component
public class RedisInitDataTools {
    private static final Logger LOGGER = Logger.getLogger(RedisInitDataTools.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    public SessionFactory sessionFactory;

    /**
     * redis加载初始数据
     * @throws Exception 异常
     */
    @Transactional(readOnly = true)
    //@PostConstruct
    public void redisInitDataTools() throws Exception {
        LOGGER.debug("*****加载物联网表服务结算所需Redis数据*****");
        // 获取所有引入的模块名
        Map<String, Map<String, String>> map = ModuleMapper.getMap();
        for (String moduleName : map.keySet()) {
            //设置模块
            WebMeterInfo.setModuleName(moduleName);
            //获取表具品牌别名
            if (WebMeterInfo.has("meterBrandName")) {
                String alias = WebMeterInfo.getString("meterBrandName");
                //判断该模块是否需要Redis
                if (WebMeterInfo.has("isRedis")) {
                    Session session = sessionFactory.openSession();
                    TransactionSynchronizationManager.bindResource(sessionFactory, session);
                    try {
                        LOGGER.debug("*****模块【" + moduleName + "】加载Redis数据*****");
                        int pageIndex = 1;
                        JSONObject params = new JSONObject();
                        params.put("data", new JSONObject().put("f_meter_brand", alias));
                        while (true) {
                            JSONArray userfilesArray = sqlServer.query("redisGetMeterInfo", pageIndex, 500,
                                    params.toString());
                            if (userfilesArray.length() == 0) {
                                break;
                            }
                            LOGGER.debug("*****加载表档案（t_userfiles）信息，第" + pageIndex + "页*****");
                            for (int i = 0; i < userfilesArray.length(); i++) {
                                JSONObject userfilesObject = userfilesArray.getJSONObject(i);
                                //redis存入表档案信息
                                redisUtil.setHash("meter-" + userfilesObject.get("f_user_id"), userfilesObject);
                                //查询该表对应的用户信息
                                JSONArray userInfoArray = sqlServer.query("redisGetUserInfo",
                                        new JSONObject().put("userInfo_id", userfilesObject.get("f_userinfo_id")), 1);
                                if (userInfoArray.length() == 1) {
                                    JSONObject userInfoObject = userInfoArray.getJSONObject(0);
                                    //redis存入用户档案信息
                                    redisUtil.setHash("user-" + userInfoObject.get("f_userinfo_id"), userInfoObject);
                                }
                            }
                            LOGGER.debug("*****表档案（t_userfiles）信息第" + pageIndex + "页加载完成*****");
                            pageIndex++;
                        }
                        LOGGER.debug("*****模块【" + moduleName + "】加载Redis数据完成*****");
                    } finally {
                        TransactionSynchronizationManager.unbindResourceIfPossible(sessionFactory);
                        session.close();
                    }
                } else {
                    LOGGER.warn("*****模块【" + moduleName + "】跳过Redis数据加载*****");
                }
            }
        }
    }
}
