package com.aote.webmeter.module.xinlisystem;

import org.json.JSONObject;

import java.util.Calendar;
import java.util.Date;

/**
 * 杭州新力系统兼容工具
 * @author Mrriver
 */
public class XinLiSystemTools {
    private static JSONObject getPriceChangeInfo(String year, String month, String day) {
        if(month.length() == 1) {
            month = "0"+month;
        }
        if(day.length() == 1) {
            day = "0"+day;
        }
        String thisTime = month+"-"+day;
        JSONObject result = new JSONObject();
        System.out.println(thisTime);
        result.put("months","2");
        if ((thisTime.compareTo("03-16") >= 0) && (thisTime.compareTo("05-16") < 0)) {
            result.put("date", "0516");
            result.put("startDate", year + "0316");
            result.put("realDate", year + "-" + "05-16");
        } else if ((thisTime.compareTo("05-16") >= 0) && (thisTime.compareTo("07-16") < 0))
        {
            result.put("date", "0716");
            result.put("startDate", year + "0516");
            result.put("realDate", year + "-" + "07-16");
        } else if ((thisTime.compareTo("07-16") >= 0) && (thisTime.compareTo("09-16") < 0))
        {
            result.put("date", "0916");
            result.put("startDate", year + "0716");
            result.put("realDate", year + "-" + "09-16");
        } else if ((thisTime.compareTo("09-16") >= 0) && (thisTime.compareTo("11-16") < 0))
        {
            result.put("date", "1116");
            result.put("startDate", year + "0916");
            result.put("realDate", year + "-" + "11-16");
        } else {
            if (thisTime.compareTo("06-01") > 0) {
                int newYear = Integer.parseInt(year) + 1;
                result.put("startDate", year + "1116");
                result.put("realDate", newYear + "-" + "03-16");
                result.put("endDate", newYear + "0316");
            } else {
                int oldYear = Integer.parseInt(year) - 1;
                result.put("startDate", oldYear + "1116");
                result.put("realDate", year + "-" + "03-16");
                result.put("endDate", year + "0316");
            }
            result.put("date", "0316");
            result.put("months", "4");
        }
        return result;
    }

    // 计算开始时间方法
    public static JSONObject countDate(Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        String year = String.valueOf(now.get(Calendar.YEAR));
        String month = String.valueOf(now.get(Calendar.MONTH)+1);
        String day = String.valueOf(now.get(Calendar.DATE));
        return getPriceChangeInfo(year, month, day);
    }

    // 计算预调价
    public static JSONObject prepareCountDate() {
        Calendar now = Calendar.getInstance();
        String year = String.valueOf(now.get(Calendar.YEAR));
        String month = String.valueOf(now.get(Calendar.MONTH)+1);
        String day = "16";
        return getPriceChangeInfo(year, month, day);
    }
}
