package com.aote.webmeter.module.weisidamoney;

import org.json.JSONObject;

import java.sql.SQLOutput;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;

/**
 * 维斯达NB金额表对接兼容工具
 *
 * @author Mrriver
 */
public class WeiSiDaMoneyToolsTest {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    public static String getRandomMeterNumber() {
        Random random = new Random();
        int i = random.nextInt(100);
        return i + "";
    }

    public static void main(String[] args) {
        System.out.println(getRandomMeterNumber());
    }
    public JSONObject getUsedGasByDate(String hex) {
        JSONObject result = new JSONObject();
        result.put("f_naturalgas1", "10");
        result.put("f_naturalgas2", "0");
        result.put("f_naturalgas3", "0");
        result.put("f_naturalgas4", "0");
        result.put("f_naturalgas5", "0");
        result.put("f_naturalgas6", "0");
        return result;
    }

    public JSONObject getAlarmInfo(String hex) {
        JSONObject result = new JSONObject();
        //获取拆卸报警信息
        result.put("f_SplitAlarm", 0);
        result.put("f_LowLithiumBattery", 0);
        //获取上报类型信息

        result.put("uploadExceptionMode", false);
        result.put("f_upload_type", "手动上报");
        result.put("exceptionLevel", "");
        return result;
    }

    //获取上报时间/上次上报时间/上次表状态/外部晶振/版本号信息
    public JSONObject getUploadDateInfo(String hex) {
        JSONObject result = new JSONObject();
        result.put("f_hand_date", "2020-04-15 10:09:00");
        result.put("f_last_hand_date", "2020-04-14 10:09:00");
        result.put("f_last_meter_state_msg", "L-6 正常");
        result.put("f_XTIpllStopFlag", "0");
        result.put("f_software_version", "0");
        return result;
    }

    //获取上报时间（兼容旧协议）
    public JSONObject getOldUploadDateInfo(String eventTime) throws ParseException {
        JSONObject result = new JSONObject();
        result.put("f_hand_date", "2020-04-15 10:09:00");
        return result;
    }

    private static byte[] hexStringToBytes(String hexString) {
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte[] hexString2binaryString(String hexString) {
        StringBuilder bString = new StringBuilder();
        String tmp;
        for (int i = 0; i < hexString.length(); i++) {
            tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString.substring(i, i + 1), 16));
            bString.append(tmp.substring(tmp.length() - 4));
        }
        if (bString.length() == 4) {
            //补足0
            bString = new StringBuilder("0000").append(bString);
        }
        //反转
        bString.reverse();
        byte[] result = new byte[bString.length()];
        for (int i = 0; i < bString.length(); ++i) {
            result[i] = charToByte(bString.charAt(i));
        }
        return result;
    }

    /**
     * 将一个int数字转换为二进制的字符串形式。(反转)
     *
     * @param num    需要转换的int类型数据
     * @param digits 要转换的二进制位数，位数不足则在前面补0
     * @return 二进制的字符串形式
     */
    public static byte[] toBinary(int num, int digits) {
        String cover = Integer.toBinaryString(1 << digits).substring(1);
        String s = Integer.toBinaryString(num);
        String resultStr = s.length() < digits ? cover.substring(s.length()) + s : s;
        byte[] result = new byte[resultStr.length()];
        int index = resultStr.length() - 1;
        for (int i = 0; i < resultStr.length(); ++i) {
            result[index] = charToByte(resultStr.charAt(i));
            index--;
        }
        return result;
    }

    public static byte[] string2binaryString(String str) {
        return toBinary(Integer.parseInt(str), 8);
    }

    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }

    //获取上报类型信息
    private static JSONObject getUploadType(String hex) {
        String uploadType;
        String exceptionLevel = "";
        boolean uploadExceptionMode = false;
        hex = "0" + hex + "0";
        switch (hex) {
            case "00000000":
                uploadType = "手动上报";
                break;
            case "00000010":
                uploadType = "自动上报";
                break;
            case "00000100":
                uploadType = "锂电低电上报";
                break;
            case "00001000":
                uploadType = "拆表上报";
                break;
            case "00010000":
                uploadType = "插卡上报";
                break;
            case "00100000":
                uploadType = "上电校时上报";
                break;
            case "01000000":
                uploadType = "重发上报";
                break;
            case "00000110":
                uploadType = "E-7单干簧管故障";
                uploadExceptionMode = true;
                exceptionLevel = "故障型";
                break;
            case "00001010":
                uploadType = "E-8双干簧管故障";
                uploadExceptionMode = true;
                exceptionLevel = "故障型";
                break;
            case "00010010":
                uploadType = "E-23透支过气";
                uploadExceptionMode = true;
                exceptionLevel = "故障型";
                break;
            case "00100010":
                uploadType = "E-21透支关阀";
                uploadExceptionMode = true;
                exceptionLevel = "警示型";
                break;
            case "01000010":
                uploadType = "E-16周期关阀";
                uploadExceptionMode = true;
                exceptionLevel = "警示型";
                break;
            case "00001110":
                uploadType = "E-17过流报警";
                uploadExceptionMode = true;
                exceptionLevel = "故障型";
                break;
            case "00110000":
                uploadType = "E-29微流量泄露";
                uploadExceptionMode = true;
                exceptionLevel = "故障型";
                break;
            case "00010110":
                uploadType = "电池低电上报";
                break;
            case "00100110":
                uploadType = "补抄上报";
                break;
            case "01000110":
                uploadType = "查询ICCID上报";
                break;
            case "00011110":
                uploadType = "断外电上报";
                break;
            case "00101110":
                uploadType = "补抄1个月上报";
                break;
            case "01001110":
                uploadType = "上电立即上报";
            default:
                uploadType = "其他上报(" + hex + ")";
                break;
        }
        return new JSONObject()
                .put("uploadType", uploadType)
                .put("uploadExceptionMode", uploadExceptionMode)
                .put("exceptionLevel", exceptionLevel);
    }

    //获取上次表状态
    private static String getLastState(int hex) {
        switch (hex) {
            case 0:
                return "L-6 正常";
            case 1:
                return "L-10 表内部通讯错误";
            case 2:
                return "L-18 表和平台已通讯成功但平台未准备到位";
            case 3:
                return "L-12 读版本号、信号强度错误";
            case 4:
                return "L-15 上报数据后，一直未收到平台正确命令";
            case 5:
                return "L–0 上报数据失败，收到OK";
            case 6:
                return "L-14 上报数据失败，收到ERROR";
            case 7:
                return "L-4 命令区域码错误";
            case 8:
                return "L-4-1 命令校验错误";
            case 9:
                return "L-16 已处理完平台命令，给平台发送回应数据时失败";
            case 10:
                return "L-19 上报补抄数据收到平台回应AAFC后，一直未收到正确命令";
            case 11:
                return "L-9 上报补抄数据回复OK后，约60s内没收到平台回应AAFC";
            case 12:
                return "L-20 第3次发送补抄数据收到ERROR";
            case 13:
                return "L-17 平台命令未收完全";
            default:
                return "未知";
        }
    }
}
