package com.aote.webmeter.module.jicheng;

import com.af.plugins.RestTools;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import java.lang.management.ManagementFactory;
import java.util.Set;

/**
 * 积成抄表系统工具类
 */
public class JiChengADSystemTools {
    private static final Logger log = Logger.getLogger(JiChengADSystemTools.class);
    private static String url;
    private static String exceptionUrl;

    static {
        //获取当前服务的端口
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = null;
        boolean isOK;
        try {
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("org.apache.coyote.http11.Http11AprProtocol")));
            isOK = true;
        } catch (Exception e) {
            try {
                objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
                isOK = true;
            } catch (MalformedObjectNameException e2) {
                log.error("出现异常：", e2);
                isOK = false;
            }
        }
        if (isOK) {
            String port = objectNames.iterator().next().getKeyProperty("port");
            //定义Logic请求地址
            url = "http://localhost:" + port + "/webmeter/rs/logic/JiChengADSystemRunHandPlan";
            exceptionUrl = "http://localhost:" + port + "/webmeter/rs/logic/JiChengADSystemRunExceptionHandPlan";
        }
    }

    /**
     * 积成抄表
     *
     * @param array
     * @return
     */
    public static JSONArray handPlan(JSONArray array) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.length(); i++) {
            try {
                JSONObject response = new JSONObject(RestTools.post(url, array.getJSONObject(i)));
                if (!response.has("status")) {
                    result.put(response);
                }
            } catch (Exception e) {
                log.error("抄表时请求发生异常:",e);
            }
        }
        return result;
    }

    public static JSONArray saveException(JSONArray array) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.length(); i++) {
            try {
                JSONObject response = new JSONObject(RestTools.post(exceptionUrl, array.getJSONObject(i)));
                if (!response.has("status")) {
                    result.put(response);
                }
            } catch (Exception e) {
                log.error("获取异常信息时请求发生异常:",e);
            }
        }
        return result;
    }
}
