SELECT
	s.f_curtotal_gas,
	s.f_curtotal_fee,
	s.id sellid,
	u.f_user_id customer_code,
	s.f_pregas gas,
	s.f_collection Money,
	'JF' + CONVERT (VARCHAR(20), s.id) cid,
	s.f_operator operator,
	s.f_delivery_date charge_date,
	s.f_stairprice_id
FROM
	t_sellinggas s
	JOIN t_userfiles u ON u.f_userinfo_id = s.f_userinfo_id
    JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
WHERE
	(
		s.f_sendsuccess = '不成功'
		OR s.f_sendsuccess IS NULL
	)
and s.f_charge_type in ('物联网收费','物联网退费')
AND s.f_charge_state = '有效'
AND DATEDIFF(
	DAY,
	s.f_delivery_date,
	GETDATE ()
) <= 7
AND b.f_alias in ({f_meter_brand})
AND u.f_table_state = '正常'