SELECT
	s.id corid,
	u.f_user_id customer_code,
	abs(s.f_correct_collection) Money,
	'CZ' + CONVERT (VARCHAR(20), s.id) cid,
	s.f_correct_date charge_date,
	s.f_operator operator,
	abs(s.f_correct_gas) gas,
	sell.f_stairprice_id
FROM
	 t_correctrecord s
	 join t_sellinggas sell on s.f_correct_id =sell.id
	 JOIN t_userfiles u ON u.f_user_id = s.f_user_id
	 JOIN t_gasbrand b ON u.f_gasbrand_id = b.id
WHERE
	(
		s.f_sendsuccess = '不成功'
		OR s.f_sendsuccess IS NULL
	)
AND s.f_correct_type = '物联网收费撤销'
AND s.f_correct_state = '有效'
AND DATEDIFF(
	DAY,
	s.f_correct_date,
	GETDATE ()
) <= 7
AND b.f_alias in ({f_meter_brand})
AND u.f_table_state = '正常'