SELECT
	*
FROM
	(
SELECT
	ui.f_userinfo_id,				                            --用户编号
	uf.f_user_id,						                            --表编号
	uf.f_meternumber,				                            --表号
	ui.f_user_name,					                            --用户名
	ui.f_address,						                            --用户地址
	ui.f_address_detail,		                            --用户地址(针对非民用)
	ui.f_user_type,                                     --用户类型
	ui.f_gasproperties,                                 --用气性质
  ui.f_balance,                                       --账户结余
  ui.f_area,                                          --辖区
  ui.f_slice_area,                                    --片区
  uf.f_input_date,
  ui.f_street,                                        --街道
  ui.f_residential_area,                              --小区
	ISNULL(uf.f_position,'未知') AS f_position,					--表安装位置
	gb.id AS f_gasbrand_id,	                            --品牌识别列
	gb.f_meter_brand,				                            --气表品牌
	gm.id AS f_gasmodel_id,	                            --型号识别列
	gm.f_meter_style,				                            --气表型号
	gb.f_meter_type,				                            --气表类型
	uf.f_table_state,				                            --气表状态
	gb.f_alias,                                         --表厂别名
	uf.f_meter_base,				                            --气表底数
	ISNULL(uf.f_total_usegas_amount,0) AS f_total_usegas_amount, --表累购金额
	ISNULL(uf.f_valve_state,'未知') AS f_valve_state, 		--阀门状态
  ui.f_createfile_date,                               --建档日期
  ui.f_orgstr                                        --分公司代号
FROM
	t_userfiles uf
	LEFT JOIN t_userinfo ui ON (ui.f_userinfo_id= uf.f_userinfo_id)
	LEFT JOIN t_gasbrand gb ON (uf.f_gasbrand_id= gb.id)
	LEFT JOIN t_gasmodel gm ON (uf.f_gasmodel_id= gm.id)
	) t_userfiles
WHERE
  {condition}
ORDER BY
	f_user_id DESC
