/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.logic.LogicServer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class);
    private SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd");

    public static String dataIsNull(JSONObject obj, String name) {
        return obj.isNull(name) ? "" : obj.get(name).toString();
    }

    public static Object dataIsNull(JSONObject obj, String name, Object result) {
        return obj.isNull(name) ? result : obj.get(name);
    }

    public static BigDecimal getBigDecimal() {
        return new BigDecimal(0.0);
    }

    public static Integer strConvertInt(String str) {
        return Integer.parseInt(str);
    }

    public static String[] StringSplitting(String str, String str1) {
        return str.split(str1);
    }

    public JSONArray deleteName(JSONArray ja, String name) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < ja.length(); ++i) {
            result.put(ja.getJSONObject(i).get(name));
        }
        System.out.println(result);
        return result;
    }

    public JSONObject runLogic(JSONObject ja) {
        WebApplicationContext cl = ContextLoaderListener.getCurrentWebApplicationContext();
        LogicServer ls = (LogicServer)cl.getBean(LogicServer.class);
        JSONObject param = new JSONObject().put("instructType", (Object)"\u9600\u95e8\u63a7\u5236").put("inputtor", (Object)ja.getString("inputtor")).put("contentData", (Object)new JSONObject().put("isOpen", ja.getInt("contentData")));
        JSONArray jarray = ja.getJSONArray("userid");
        JSONObject result = new JSONObject();
        ArrayList<Integer> cg = new ArrayList<Integer>();
        ArrayList<Integer> sb = new ArrayList<Integer>();
        for (int i = 0; i < jarray.length(); ++i) {
            JSONObject p = jarray.getJSONObject(i);
            try {
                param.put("condition", (Object)("t_userfiles.f_user_id= '" + p.getInt("f_user_id") + "'"));
                param.put("meterBrandName", (Object)p.getString("f_alias"));
                param.put("f_user_id", p.getInt("f_user_id")).put("f_userinfo_id", p.getInt("f_userinfo_id"));
                param.put("state", 1);
                ls.run("saveInstruct", param, null);
                ls.run("updateNetWorkValve", param, null);
                cg.add(p.getInt("f_user_id"));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("f_user_id\u4e3a:" + p.getInt("f_user_id") + "\u5728\u4fdd\u5b58\u6307\u4ee4\u65f6\u51fa\u9519"), (Throwable)e);
                sb.add(p.getInt("f_user_id"));
            }
        }
        return result.put("cg", cg).put("sb", sb);
    }

    public JSONArray packageData(JSONArray ja) throws ParseException {
        JSONArray result = new JSONArray();
        JSONObject js = null;
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject data = ja.getJSONObject(i);
            if (js != null) {
                if (js.getInt("f_user_id") != data.getInt("f_user_id")) {
                    result.put((Object)js);
                    js = this.fillFinalJSON(data);
                } else {
                    js = this.fillChangeData(js, data);
                }
            } else {
                js = this.fillFinalJSON(data);
            }
            if (i != ja.length() - 1) continue;
            result.put((Object)js);
        }
        return result;
    }

    private JSONObject fillFinalJSON(JSONObject data) throws ParseException {
        JSONObject js = new JSONObject();
        logger.info((Object)data);
        js.put("f_user_id", data.getInt("f_user_id")).put("f_address", (Object)data.getString("f_address")).put("f_area", (Object)data.getString("f_area")).put("f_street", (Object)data.getString("f_street")).put("f_slice_area", (Object)data.getString("f_slice_area")).put("f_residential_area", (Object)data.getString("f_residential_area")).put("f_user_name", (Object)data.getString("f_user_name"));
        if (!data.isNull("day")) {
            js.put(this.spellJSONKey(data.getString("day")), data.getDouble("usergas"));
        }
        return js;
    }

    private JSONObject fillChangeData(JSONObject js, JSONObject data) throws ParseException {
        if (data.getString("day") != null) {
            js.put(this.spellJSONKey(data.getString("day")), data.getDouble("usergas"));
        }
        return js;
    }

    private String spellJSONKey(String day) throws ParseException {
        return "day" + this.si.parse(day).getDate();
    }

    public long strToLong(String str) {
        return Long.parseLong(str);
    }
}

