package com.aote.webmeter.tools;

import com.aote.logic.LogicServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author GaoChengLong Waki
 * @date 2018/11/23 10:16
 */
public class Utils {

    private static Logger logger = Logger.getLogger(Utils.class);
    private SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd");

    /**
     * 判断该名称的json值是否存在在传入的json中
     *
     * @return 空字符串则并不存在，否则返回值
     */
    public static String dataIsNull(JSONObject obj, String name) {
        return obj.isNull(name) ? "" : obj.get(name).toString();
    }

    public static Object dataIsNull(JSONObject obj, String name, Object result) {
        return obj.isNull(name) ? result : obj.get(name);
    }

    public static BigDecimal getBigDecimal() {
        return new BigDecimal(0.0);
    }

    /**
     * 字符串转Integer
     */
    public static Integer strConvertInt(String str) {
        return Integer.parseInt(str);
    }

    /**
     * 字符串拆分：按照某一特殊字符串拆分
     * str:被拆分的字符串
     * str1:特殊字符串
     */
    public static String[] StringSplitting(String str,String str1) {
        return str.split(str1);
    }

    /**
     * 删除jsonArray中的key值
     */
    public JSONArray deleteName(JSONArray ja, String name) {
        JSONArray result = new JSONArray();
        for (int i = 0; i < ja.length(); i++) {
            result.put(ja.getJSONObject(i).get(name));
        }
        System.out.println(result);
        return result;
    }

    /**
     * 通过插件执行Logic
     * 不能通过单元测试,因为单元测试并没有定义上下文，所以取不到Bean工厂
     * 依旧会被回滚,没时间去找原因了。下次再说吧，方法先留着。
     */
    public JSONObject runLogic(JSONObject ja) {
        // 获取Spring的Bean生产工厂
        WebApplicationContext cl = ContextLoaderListener.getCurrentWebApplicationContext();
        LogicServer ls = cl.getBean(LogicServer.class);
        JSONObject param = new JSONObject().put("instructType", "阀门控制")
                .put("inputtor", ja.getString("inputtor"))
                .put("contentData", new JSONObject().put("isOpen", ja.getInt("contentData")));
        JSONArray jarray = ja.getJSONArray("userid");
        JSONObject result = new JSONObject();
        List<Integer> cg = new ArrayList<>();
        List<Integer> sb = new ArrayList<>();
        for (int i = 0; i < jarray.length(); i++) {
            JSONObject p = jarray.getJSONObject(i);
            try {
                // 组织saveInstruct的数据
                param.put("condition", "t_userfiles.f_user_id= '" + p.getInt("f_user_id") + "'");
                param.put("meterBrandName", p.getString("f_alias"));
                // 组织updateNetWorkValve的数据
                param.put("f_user_id", p.getInt("f_user_id"))
                        .put("f_userinfo_id", p.getInt("f_userinfo_id"));
                param.put("state", 1);
                ls.run("saveInstruct", param, null);
                ls.run("updateNetWorkValve", param, null);
                cg.add(p.getInt("f_user_id"));
            } catch (Exception e) {
                logger.error("f_user_id为:" + p.getInt("f_user_id") + "在保存指令时出错", e);
                sb.add(p.getInt("f_user_id"));
            }
        }
        return result.put("cg", cg).put("sb", sb);
    }

    /**
     * 对数据库的数据进行包装，包装成为前台日用气量统计报表的DataGrid使用的数据
     */
    public JSONArray packageData(JSONArray ja) throws ParseException {
        // 如果用的的day==null则代表着这个月没有抄表哦
        JSONArray result = new JSONArray();
        JSONObject js = null;
        for (int i = 0; i < ja.length(); i++) {
            JSONObject data = ja.getJSONObject(i);
            if (js != null) {
                // 判断是否与上一条数据相同
                if (js.getInt("f_user_id") != data.getInt("f_user_id")) {
                    // 当其不相同代表已经迭代到了下一位用户
                    // 先保存数据
                    result.put(js);
                    // 然后填充新数据
                    js = fillFinalJSON(data);
                } else {
                    // 填充本次抄表的数据
                    js = fillChangeData(js, data);
                }
            } else {
                // 填充新数据
                js = fillFinalJSON(data);
            }
            // 判断是否到最后一条了
            if (i == (ja.length() - 1)) {
                result.put(js);
            }
        }
        return result;
    }

    /**
     * 填充不变的数据
     */
    private JSONObject fillFinalJSON(JSONObject data) throws ParseException {
        JSONObject js = new JSONObject();
        // 取出固定的数据
        logger.info(data);
        js.put("f_user_id", data.getInt("f_user_id")).put("f_address", data.getString("f_address"))
                .put("f_area", data.getString("f_area")).put("f_street", data.getString("f_street"))
                .put("f_slice_area", data.getString("f_slice_area")).put("f_residential_area", data.getString("f_residential_area"))
                .put("f_user_name", data.getString("f_user_name"));
        // 检查是否有抄表数据,不等于null则代表着有,如果有则取day值和usergas值  抄表值就暂时不取了
        if (!data.isNull("day")) {
            // 检查这个抄表信息属于哪一天。拼装json的key值
            js.put(spellJSONKey(data.getString("day")), data.getDouble("usergas"));
        }
        return js;
    }

    /**
     * 填充可变的数据
     */
    private JSONObject fillChangeData(JSONObject js, JSONObject data) throws ParseException {
        if (data.getString("day") != null) {
            // 检查这个抄表信息属于哪一天。拼装json的key值
            js.put(spellJSONKey(data.getString("day")), data.getDouble("usergas"));
        }
        return js;
    }

    /**
     * 检查当前这一天是属于哪个key值的
     */
    private String spellJSONKey(String day) throws ParseException {
        return "day" + si.parse(day).getDate();
    }

    /**
     * String转long
     * @param str
     * @return
     */
    public  long strToLong(String str){
        return Long.parseLong(str);
    }
}
