package com.aote.webmeter.tools;

import org.apache.log4j.Logger;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

/**
 * 物联网表基础工具
 * @author 物联网表小组
 */
public class BasicTools {
    private static Logger logger = Logger.getLogger(BasicTools.class);
    /**
     * 物联网表MD5加密
     * @param param 需要加密的参数
     * @return MD5加密后的字符串
     */
    public static String md5(String param) {
        char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] strTemp = param.getBytes(StandardCharsets.UTF_8);
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = hexDigits[byte0 >>> 4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }
            return new String(str);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 业务逻辑线程睡眠
     * @param millis 睡眠时间，单位：毫秒
     */
    public static void sleep(Integer millis) throws InterruptedException {
        Thread.sleep(millis);
    }
}
