package com.aote.webmeter.module.weisidamoney;

import com.af.plugins.ConvertTools;
import org.json.JSONObject;

/**
 * 维斯达NB金额表对接兼容工具
 * @author Mrriver
 */
public class WeiSiDaMoneyTools {
    public JSONObject getUsedGasByDate(String hex) {
        int[] nums = getHexArray(hex.split(""));

        JSONObject result = new JSONObject();
        result.put("f_naturalgas1", String.format("%.2f", (double)(nums[0] * 16 + nums[1]) * 0.01D));
        result.put("f_naturalgas2", String.format("%.2f", (double)(nums[2] * 16 + nums[3]) * 0.01D));
        result.put("f_naturalgas3", String.format("%.2f", (double)(nums[4] * 16 + nums[5]) * 0.01D));
        result.put("f_naturalgas4", String.format("%.2f", (double)(nums[6] * 16 + nums[7]) * 0.01D));
        result.put("f_naturalgas5", String.format("%.2f", (double)(nums[8] * 16 + nums[9]) * 0.01D));
        result.put("f_naturalgas6", String.format("%.2f", (double)(nums[10] * 16 + nums[11]) * 0.01D));
        return result;
    }

    public JSONObject getAlarmInfo(String hex){
        //获取拆卸报警信息
        String tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hex
                .substring(0, 1), 16));
        String tmp1 = "0000" + Integer.toBinaryString(Integer.parseInt(hex.substring(1,2),16));
        tmp = tmp.substring(tmp.length() - 4);
        tmp = tmp + tmp1.substring(tmp1.length() - 4);
        byte[] tmpArray = ConvertTools.binaryStrToBinaryArray(tmp);
        //获取拆卸报警时间
        int[] nums = getHexArray(hex.split(""));
        JSONObject result = new JSONObject();
        result.put("f_SplitAlarm",tmpArray[tmpArray.length-1]);
        result.put("f_LowLithiumBattery",tmpArray[0]);
        result.put("f_SplitAlarmDate",String.format("20%s%s-%s%s-%s%s %s%s:%s%s:00",nums[2],nums[3],nums[4],nums[5],nums[6],nums[7],nums[8],nums[9],nums[10],nums[11]));
        return result;
    }

    private int[] getHexArray(String[] array){
        int[] nums = new int[array.length];
        for(int i = 0; i < array.length; ++i) {
            String param = array[i];
            switch(param) {
                case "A":
                    nums[i] = 10;
                    break;
                case "B":
                    nums[i] = 11;
                    break;
                case "C":
                    nums[i] = 12;
                    break;
                case "D":
                    nums[i] = 13;
                    break;
                case "E":
                    nums[i] = 14;
                    break;
                case "F":
                    nums[i] = 15;
                    break;
                default:
                    nums[i] = Integer.parseInt(array[i]);
            }
        }
        return nums;
    }
}
