package com.aote.webmeter.module.weisidaflowmeter;

import com.yd.entity.Command;
import com.yd.resolver.ValveResolver;
import org.json.JSONObject;

/**
 * 维斯达NB流量计控制阀对接兼容工具
 * @author Mrriver
 */
public class WeiSiDaFlowMeterTools {

    //解析数据
    public JSONObject resolve(JSONObject object) throws Exception {
        Command command = new Command();
        command.setName(object.getString("name"));
        command.setContext(object.getString("context"));
        command.setResponse(object.getString("response"));
        ValveResolver valveResolver = new ValveResolver();
        return new JSONObject(valveResolver.resolve(command));
    }

    private int[] getHexArray(String[] array){
        int[] nums = new int[array.length];
        for(int i = 0; i < array.length; ++i) {
            String param = array[i];
            switch(param) {
                case "A":
                    nums[i] = 10;
                    break;
                case "B":
                    nums[i] = 11;
                    break;
                case "C":
                    nums[i] = 12;
                    break;
                case "D":
                    nums[i] = 13;
                    break;
                case "E":
                    nums[i] = 14;
                    break;
                case "F":
                    nums[i] = 15;
                    break;
                default:
                    nums[i] = Integer.parseInt(array[i]);
            }
        }
        return nums;
    }
}
