package com.aote.webmeter;

import java.math.BigDecimal;
import java.text.DecimalFormat;


import com.af.plugins.RestTools;
import jdk.nashorn.internal.scripts.JO;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;


import com.af.plugins.RedisTools;
import com.af.plugins.calculate.StairpriceSettlement;
import com.af.plugins.calculate.UnitpriceSettlement;
import org.omg.CORBA.ARG_IN;

import javax.swing.plaf.synth.SynthSpinnerUI;
import javax.ws.rs.PUT;


/**
 *
 * 进行结算和结余
 * @author liuyi
 *
 */


public class RedisBalance {

	private static Logger log = Logger.getLogger(RedisBalance.class);

	public JSONObject redisSettlement(String meterNumber,JSONObject params){
		DecimalFormat decimalFormat  = new DecimalFormat("0.00");
		log.debug("传入参数:"+params.toString());
		//通过表号，获取Redis数据
		JSONObject value = new JSONObject(RedisTools.getValue(meterNumber));
		//上次剩余金额
		BigDecimal lastBalance =new BigDecimal(value.getString("lastBalance"));
		//上次表底数
		BigDecimal lastTableBase = new BigDecimal(value.getString("lastTableBase"));
		//气价类型(1:固定单价，2:阶梯气价)
		String priceType = value.getString("priceType");
		//气价信息
		JSONArray priceArray = value.getJSONArray("priceArray");
		//本次表底数
		BigDecimal tableBase = new BigDecimal(params.getString("tableBase"));
		//本次用气量
		BigDecimal useGas = tableBase.subtract(lastTableBase);
		//当前单价
		BigDecimal price;
		//划价结果
		JSONObject result;
		//划价明细
		JSONArray chargePrice;

		//传入参数
		JSONArray jsonArray = new JSONArray();
		if("1".equals(priceType)){
			JSONObject priceDetail = priceArray.getJSONObject(0);
			price = new BigDecimal(priceDetail.getString("price"));
			result = new UnitpriceSettlement()
					.calcCharge(jsonArray.put(new JSONObject().put("f_unitprice",price))
							,useGas);
		} else if("2".equals(priceType)){
			for(int i = 0;i < priceArray.length()-1; i++){
				jsonArray.put(priceArray.getJSONObject(i));
			}
			JSONObject priceDetail = priceArray.getJSONObject(priceArray.length()-1);
			jsonArray.put(priceDetail);
			//阶梯累购气量
			BigDecimal sumAmount = new BigDecimal(params.getString("sumAmount"));
			jsonArray.put(new JSONObject().put("sumamount",sumAmount));
			result = new StairpriceSettlement().calcCharge(jsonArray, useGas);
			chargePrice = result.getJSONArray("chargeprice");
			price = chargePrice.getJSONObject(0).getBigDecimal("f_price");
			for(int i = 1;i<chargePrice.length();i++){
				JSONObject chargeJson = chargePrice.getJSONObject(i);
				if(chargeJson.getBigDecimal("f_gas")
						.compareTo(new BigDecimal(0)) > 0){
					price = chargeJson.getBigDecimal("f_price");
				}
			}
		} else {
			throw new RuntimeException("尚未支持其他气价类型！");
		}

		//本次用气金额
		BigDecimal useAmount = result.getBigDecimal("chargenum");
		//本次剩余金额=上次剩余金额-本次用气金额
		BigDecimal balance = lastBalance.subtract(useAmount);

		//------更新redis中的数据------
		//上次剩余金额 <- 本次剩余金额
		String balanceStr = decimalFormat.format(balance);
		value.put("lastBalance",balanceStr);
		//上次表底数 <- 本次表底数
		value.put("lastTableBase",tableBase.toString());
		//当前单价
		value.put("unitPrice",price.toString());

		RedisTools.setValue(meterNumber,value.toString());
		JSONObject jsonObject2 = new JSONObject();
		jsonObject2.put("returnCode","SUCCESS");
		jsonObject2.put("balance",balanceStr);
		jsonObject2.put("unitPrice",price.toString());
		System.out.println(value.toString());
		return jsonObject2;
	}
}
