package com.aote.webmeter.module.qiaosong;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ReadMeterUtil {

	public String switchMD5(String s) {
		String mdStr = "";
		char[] hexDigits = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			 
	        try {
	            byte[] btInput = s.getBytes();
	            // 获得MD5摘要算法的 MessageDigest 对象
	            MessageDigest mdInst = MessageDigest.getInstance("MD5");
	            // 使用指定的字节更新摘要
	            mdInst.update(btInput);
	            // 获得密文
	            byte[] md = mdInst.digest();
	            // 把密文转换成十六进制的字符串形式
	            int j = md.length;
				char[] str = new char[j * 2];
	            int k = 0;
				for (byte byte0 : md) {
					str[k++] = hexDigits[byte0 >>> 4 & 0xf];
					str[k++] = hexDigits[byte0 & 0xf];
				}
	            return new String(str);
	        } catch (Exception e) {
	            e.printStackTrace();
	            return null;
	        }
	}

	/**
	 * 字符串转换URL码
	 */
	public static String encode(String string) throws UnsupportedEncodingException {
		return URLEncoder.encode(string,"UTF-8");
	}

	/**
	 * URL码转字符串
	 */
	public static String decode(String unicode) throws UnsupportedEncodingException {
		return URLDecoder.decode(unicode,"UTF-8");
	}

	/**
	 * 字符串 SHA 加密
	 */
	public static String encodeSha(final String strText) {
		// 返回值
		String strResult = null;

		// 是否是有效字符串
		if (strText != null && strText.length() > 0) {
			try {
				// SHA 加密开始
				// 创建加密对象 并傳入加密類型
				MessageDigest messageDigest = MessageDigest
						.getInstance("SHA-512");
				// 传入要加密的字符串
				messageDigest.update(strText.getBytes());
				// 得到 byte 類型结果
				byte[] byteBuffer = messageDigest.digest();

				// 將 byte 轉換爲 string
				StringBuilder strHexString = new StringBuilder();
				// 遍歷 byte buffer
				for (byte b : byteBuffer) {
					String hex = Integer.toHexString(0xff & b);
					if (hex.length() == 1) {
						strHexString.append('0');
					}
					strHexString.append(hex);
				}
				// 得到返回結果
				strResult = strHexString.toString();
			} catch (NoSuchAlgorithmException e) {
				e.printStackTrace();
			}
		}
		return strResult;
	}

	public static void main(String[] args) throws UnsupportedEncodingException {
		System.out.println(ReadMeterUtil.encode("张三"));
	}
}
