package com.aote.webmeter.tools;


import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;


import com.af.plugins.ConvertTools;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.poi.util.StringUtil;
import org.json.JSONArray;
import org.json.JSONObject;


public class Encryption {
	public static String MD5Encryption(JSONObject jo,String key ){
		StringBuilder sb = new StringBuilder();
		Set<String> keySet = jo.keySet();
		List<String> list = new ArrayList<>(keySet);
		Collections.sort(list);
		for (String string : list) {
			Object value = jo.get(string);
			if("".equals(value)){
				continue;
			}
			sb.append(string).append("=").append(value).append("&");
		}
		sb.append("key=").append(key);
		return  DigestUtils.md5Hex(sb.toString()).toUpperCase();
	}

	public static String Base64Encryption(String param){

		return ConvertTools.base64Encode(param.getBytes(StandardCharsets.UTF_8));
	}

	public static String Base64Encryption(byte[] param){

		return ConvertTools.base64Encode(param);
	}

	public static byte[] SHA1Encryption(String param){

		try {
			MessageDigest md5 = MessageDigest.getInstance("SHA");
			md5.update(param.getBytes(StandardCharsets.UTF_8));
			return md5.digest();
		}catch (Exception e) {
			return null;
		}
	}

	public static byte[] Base64Decryption(String param){
		return ConvertTools.base64Decode(param.getBytes(StandardCharsets.UTF_8));
	}

	public static String getUUID(){
		return UUID.randomUUID().toString().replace("-", "");
	}



}
